/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.network;

import com.chaosthedude.naturescompass.NaturesCompass;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncPacket {
    private boolean canTeleport;
    private List<ResourceLocation> allowedBiomes;

    public SyncPacket() {
    }

    public SyncPacket(boolean canTeleport, List<ResourceLocation> allowedBiomes) {
        this.canTeleport = canTeleport;
        this.allowedBiomes = allowedBiomes;
    }

    public SyncPacket(PacketBuffer buf) {
        this.canTeleport = buf.readBoolean();
        this.allowedBiomes = new ArrayList<ResourceLocation>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.allowedBiomes.add(new ResourceLocation(buf.func_218666_n()));
        }
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeBoolean(this.canTeleport);
        buf.writeInt(this.allowedBiomes.size());
        for (ResourceLocation biome : this.allowedBiomes) {
            buf.func_192572_a(biome);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            NaturesCompass.canTeleport = this.canTeleport;
            NaturesCompass.allowedBiomes = this.allowedBiomes;
        });
        ctx.get().setPacketHandled(true);
    }
}

