/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.gui.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.konkrete.rendering.animation.AnimationRenderer;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SimpleLoadingScreen
extends Screen {
    private static ResourceLocation MOJANG_LOGO_TEXTURE = new ResourceLocation("textures/gui/title/mojangstudios.png");
    private final Minecraft mc;
    private LoadingAnimationRenderer loading = new LoadingAnimationRenderer("keksuccino/animations/loading", 15, true, 0, 0, 16, 16, "konkrete", null);
    private String status = "";
    private boolean darkmode = false;

    public SimpleLoadingScreen(Minecraft mc) {
        super((ITextComponent)new StringTextComponent(""));
        this.mc = mc;
    }

    public void func_230430_a_(MatrixStack matrix, int p_render_1_, int p_render_2_, float p_render_3_) {
        int color = new Color(239, 50, 61).getRGB();
        if (this.darkmode) {
            color = new Color(26, 26, 26).getRGB();
        }
        SimpleLoadingScreen.func_238467_a_((MatrixStack)matrix, (int)0, (int)0, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)color);
        int j2 = (int)((double)this.mc.func_228018_at_().func_198107_o() * 0.5);
        int i1 = (int)((double)this.mc.func_228018_at_().func_198087_p() * 0.5);
        double d0 = Math.min((double)this.mc.func_228018_at_().func_198107_o() * 0.75, (double)this.mc.func_228018_at_().func_198087_p()) * 0.25;
        int j1 = (int)(d0 * 0.5);
        double d1 = d0 * 4.0;
        int k1 = (int)(d1 * 0.5);
        this.mc.func_110434_K().func_110577_a(MOJANG_LOGO_TEXTURE);
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        SimpleLoadingScreen.func_238466_a_((MatrixStack)matrix, (int)(j2 - k1), (int)(i1 - j1), (int)k1, (int)((int)d0), (float)-0.0625f, (float)0.0f, (int)120, (int)60, (int)120, (int)120);
        SimpleLoadingScreen.func_238466_a_((MatrixStack)matrix, (int)j2, (int)(i1 - j1), (int)k1, (int)((int)d0), (float)0.0625f, (float)60.0f, (int)120, (int)60, (int)120, (int)120);
        this.loading.setPosX(this.field_230708_k_ / 2 - this.loading.getWidth() / 2);
        this.loading.setPosY(this.field_230709_l_ - 80);
        RenderSystem.color4f((float)0.0f, (float)0.733f, (float)1.0f, (float)1.0f);
        this.loading.render(matrix);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawStatus(this.status, matrix, this.field_230708_k_ / 2, this.loading.getPosY() + this.loading.getHeight() + 20);
        super.func_230430_a_(matrix, p_render_1_, p_render_2_, p_render_3_);
    }

    public boolean func_231178_ax__() {
        return false;
    }

    public void setStatusText(String status) {
        this.status = status;
    }

    public void drawStatus(String text, MatrixStack matrix, int width, int height) {
        this.mc.field_71466_p.func_238421_b_(matrix, text, (float)(width - Minecraft.func_71410_x().field_71466_p.func_78256_a(text) / 2), (float)height, Color.WHITE.getRGB());
    }

    public void setDarkmode(boolean b) {
        this.darkmode = b;
    }

    public void setLoadingAnimationColor(String hex) {
        this.loading.setHexColor(hex);
    }

    private static class LoadingAnimationRenderer
    extends AnimationRenderer {
        private String hex = "#ffffffff";

        public LoadingAnimationRenderer(String resourceDir, int fps, boolean loop, int posX, int posY, int width, int height, String modid, String hex) {
            super(resourceDir, fps, loop, posX, posY, width, height, modid);
            if (hex != null) {
                this.hex = hex;
            }
        }

        @Override
        protected void renderFrame(MatrixStack matrix) {
            int h = this.getHeight();
            int w = this.getWidth();
            int x2 = this.getPosX();
            int y2 = this.getPosY();
            if (this.isStretchedToStreensize()) {
                h = Minecraft.func_71410_x().field_71462_r.field_230709_l_;
                w = Minecraft.func_71410_x().field_71462_r.field_230708_k_;
                x2 = 0;
                y2 = 0;
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a((ResourceLocation)this.resources.get(this.currentFrame()));
            RenderSystem.enableBlend();
            float[] colorf = RenderUtils.getColorFromHexString(this.hex).getComponents(new float[4]);
            if (colorf != null) {
                RenderSystem.color4f((float)colorf[0], (float)colorf[1], (float)colorf[2], (float)colorf[3]);
            } else {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f);
            }
            IngameGui.func_238463_a_((MatrixStack)matrix, (int)x2, (int)y2, (float)0.0f, (float)0.0f, (int)w, (int)h, (int)w, (int)h);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        }

        public void setHexColor(String hex) {
            this.hex = hex == null ? "#ffffffff" : hex;
        }
    }
}

