/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.network.packets.battles;

import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.network.ByteBufTCG;
import com.pixelmonmod.tcg.network.data.AbstractTCGPacket;
import com.pixelmonmod.tcg.network.data.PacketDirection;
import com.pixelmonmod.tcg.tileentity.BattleOwnedTileEntityController;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class PrizeSelectorToClientPacket
extends AbstractTCGPacket {
    private BlockPos blockPos;
    private int prizeIndex;
    private ImmutableCard prize;

    public PrizeSelectorToClientPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public PrizeSelectorToClientPacket(BlockPos blockPos, int prizeIndex, ImmutableCard prize) {
        this();
        this.blockPos = blockPos;
        this.prizeIndex = prizeIndex;
        this.prize = prize;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.blockPos);
        buffer.writeInt(this.prizeIndex);
        ByteBufTCG.writeCard(buffer, this.prize);
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.blockPos = buffer.func_179259_c();
        this.prizeIndex = buffer.readInt();
        this.prize = ByteBufTCG.readCard(buffer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(NetworkEvent.Context context) {
        ClientWorld w;
        BattleOwnedTileEntityController b;
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity e = mc.field_71439_g;
        if (mc.field_71441_e != null && (b = (BattleOwnedTileEntityController)(w = mc.field_71441_e).func_175625_s(this.blockPos)) != null) {
            b.revealPrize(this.prizeIndex, this.prize);
        }
    }
}

