/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.network;

import com.pixelmonmod.tcg.api.accessors.Cards;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.duel.state.TrainerCardState;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;

public class ByteBufTCG {
    private static final int COMMON_TYPE = 0;
    private static final int POKEMON_TYPE = 1;
    private static final int TRAINER_TYPE = 2;

    public static void writeBlockPos(PacketBuffer buf, BlockPos blockPos) {
        buf.writeInt(blockPos.func_177958_n());
        buf.writeInt(blockPos.func_177956_o());
        buf.writeInt(blockPos.func_177952_p());
    }

    public static BlockPos readBlockPos(PacketBuffer buf) {
        return new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void writeCard(PacketBuffer buf, ImmutableCard card) {
        buf.func_180714_a(card.getCode());
    }

    public static void writeFaceDownCard(PacketBuffer buf) {
        buf.func_180714_a(ImmutableCard.FACE_DOWN_CODE);
    }

    public static ImmutableCard readCard(PacketBuffer buf) {
        String cardCode = buf.func_218666_n();
        if (cardCode.equalsIgnoreCase(ImmutableCard.FACE_DOWN_CODE)) {
            return ImmutableCard.faceDown();
        }
        return Cards.fromCode(cardCode);
    }

    public static void writeCardList(PacketBuffer buf, List<ImmutableCard> cards) {
        buf.writeInt(cards.size());
        for (ImmutableCard card : cards) {
            ByteBufTCG.writeCard(buf, card);
        }
    }

    public static void writeFaceDownCardList(PacketBuffer buf, List<ImmutableCard> cards) {
        buf.writeInt(cards.size());
        for (ImmutableCard card : cards) {
            ByteBufTCG.writeFaceDownCard(buf);
        }
    }

    public static List<ImmutableCard> readCardList(PacketBuffer buf) {
        int size = buf.readInt();
        ArrayList<ImmutableCard> cards = new ArrayList<ImmutableCard>();
        for (int i = 0; i < size; ++i) {
            cards.add(ByteBufTCG.readCard(buf));
        }
        return cards;
    }

    public static CommonCardState readCardState(PacketBuffer buf) {
        int type = buf.readInt();
        switch (type) {
            case 0: {
                return new CommonCardState(buf);
            }
            case 1: {
                return new PokemonCardState(buf);
            }
            case 2: {
                return new TrainerCardState(buf);
            }
        }
        return null;
    }

    public static void writeCardState(PacketBuffer buf, CommonCardState cardState) {
        if (cardState instanceof PokemonCardState) {
            buf.writeInt(1);
        } else if (cardState instanceof TrainerCardState) {
            buf.writeInt(2);
        } else {
            buf.writeInt(0);
        }
        cardState.write(buf, true);
    }
}

