/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.trainer;

import com.pixelmonmod.tcg.api.card.CardType;
import com.pixelmonmod.tcg.api.util.helper.SelectorHelper;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorDisplay;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.duel.state.TrainerCardState;
import com.pixelmonmod.tcg.duel.trainer.BaseTrainerEffect;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;

public class EnergyRetrieval
extends BaseTrainerEffect {
    @Override
    public boolean canPlay(GameClientState client) {
        return client.getMe().getHand().size() >= 2 && client.getMe().getDiscardPile().stream().anyMatch(c -> c.getCardType() == CardType.ENERGY);
    }

    @Override
    public CardSelectorState getSelectorState(TrainerCardState trainer, GameServerState server) {
        PlayerServerState me = server.getPlayer(server.getCurrentTurn());
        if (trainer.getParameters().size() == 0) {
            return SelectorHelper.generateSelectorForDiscardFromHand(me, 1, null);
        }
        if (trainer.getParameters().size() == 1) {
            CardSelectorState selector = new CardSelectorState(1, 2, CardSelectorDisplay.Select, false);
            for (int i = 0; i < me.getDiscardPile().size(); ++i) {
                if (me.getDiscardPile().get(i).getCardType() != CardType.ENERGY) continue;
                selector.getCardList().add(new CardWithLocation(new CommonCardState(me.getDiscardPile().get(i)), true, BoardLocation.DiscardPile, i));
            }
            return selector;
        }
        return null;
    }

    @Override
    public boolean canApply(TrainerCardState trainer, GameServerState server) {
        return trainer.getParameters().size() >= 2;
    }

    @Override
    public void apply(TrainerCardState trainer, GameServerState server) {
        CommonCardState handCard = trainer.getParameters().get(0);
        CommonCardState energy1 = trainer.getParameters().get(1);
        CommonCardState energy2 = null;
        if (trainer.getParameters().size() > 2) {
            energy2 = trainer.getParameters().get(2);
        }
        PlayerServerState me = server.getPlayer(server.getCurrentTurn());
        me.getHand().remove(handCard.getData());
        me.getDiscardPile().add(handCard.getData());
        me.getHand().add(energy1.getData());
        me.getDiscardPile().remove(energy1.getData());
        if (energy2 != null) {
            me.getHand().add(energy2.getData());
            me.getDiscardPile().remove(energy2.getData());
        }
    }

    @Override
    public boolean canSkipSelector() {
        return false;
    }

    @Override
    public void applySkipSelector(TrainerCardState trainer, PokemonCardState pokemon, GameServerState server, BoardLocation b, int p) {
    }
}

