/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.block;

import com.pixelmonmod.pixelmon.blocks.GenericRotatableModelBlock;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.tcg.api.accessors.TCGItems;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.util.helper.LogicHelper;
import com.pixelmonmod.tcg.api.util.helper.NetworkHelper;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.item.DeckItem;
import com.pixelmonmod.tcg.item.RulebookItem;
import com.pixelmonmod.tcg.item.ShadowWandItem;
import com.pixelmonmod.tcg.network.packets.battles.TCGGuiClientPacket;
import com.pixelmonmod.tcg.tileentity.BattleOwnedTileEntityController;
import com.pixelmonmod.tcg.tileentity.BattleRuleOwnedTileEntity;
import com.pixelmonmod.tcg.tileentity.ServerOwnedTileEntityBattleController;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BattleControllerBlock
extends GenericRotatableModelBlock {
    public static final BooleanProperty ON = BooleanProperty.func_177716_a((String)"on");
    private float scale;

    public BattleControllerBlock(String name, float scale) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.5f, 10.0f));
        this.scale = scale;
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)ON, (Comparable)Boolean.valueOf(false)));
    }

    public float getScale() {
        return this.scale;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Override
    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new ServerOwnedTileEntityBattleController();
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (worldIn.field_72995_K || !(placer instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)placer;
        if (player.field_71071_by == null) {
            return;
        }
        for (ItemStack items : player.field_71071_by.field_70462_a) {
            if (items == null || items.func_77973_b() != TCGItems.rule_book || !items.func_77942_o() || worldIn.func_175625_s(pos) == null) continue;
            CompoundNBT tag = items.func_77978_p();
            BattleRuleOwnedTileEntity te = (BattleRuleOwnedTileEntity)worldIn.func_175625_s(pos);
            te.setDeckSize(tag.func_74762_e("DeckSize"));
            te.setPrizeCount(tag.func_74762_e("PrizeCount"));
            te.setTimeLimit(tag.func_74762_e("TimeLimit"));
            te.setEloMinimum(tag.func_74762_e("EloMinimum"));
            te.setStartingCommand(tag.func_74779_i("StartingCommand"));
            te.setEndingCommand(tag.func_74779_i("EndingCommand"));
            te.setStartingMessage(tag.func_74779_i("StartingMessage"));
            te.setEndingMessage(tag.func_74779_i("EndingMessage"));
            player.func_241151_a_((ITextComponent)new StringTextComponent(TextFormatting.AQUA + "Placed BattleBox with following rules:"), ChatType.GAME_INFO, Util.field_240973_b_);
            player.func_241151_a_((ITextComponent)new StringTextComponent(TextFormatting.LIGHT_PURPLE + "Deck size: " + TextFormatting.WHITE + tag.func_74762_e("DeckSize")), ChatType.GAME_INFO, Util.field_240973_b_);
            player.func_241151_a_((ITextComponent)new StringTextComponent(TextFormatting.LIGHT_PURPLE + "Prize count: " + TextFormatting.WHITE + tag.func_74762_e("PrizeCount")), ChatType.GAME_INFO, Util.field_240973_b_);
            player.func_241151_a_((ITextComponent)new StringTextComponent(TextFormatting.LIGHT_PURPLE + "Turn time limit: " + TextFormatting.WHITE + tag.func_74762_e("TimeLimit")), ChatType.GAME_INFO, Util.field_240973_b_);
            player.func_241151_a_((ITextComponent)new StringTextComponent(TextFormatting.LIGHT_PURPLE + "Elo requirement: " + TextFormatting.WHITE + tag.func_74762_e("EloMinimum")), ChatType.GAME_INFO, Util.field_240973_b_);
            player.func_241151_a_((ITextComponent)new StringTextComponent(TextFormatting.LIGHT_PURPLE + "Starting command: " + TextFormatting.WHITE + tag.func_74779_i("StartingCommand")), ChatType.GAME_INFO, Util.field_240973_b_);
            player.func_241151_a_((ITextComponent)new StringTextComponent(TextFormatting.LIGHT_PURPLE + "Ending command: " + TextFormatting.WHITE + tag.func_74779_i("EndingCommand")), ChatType.GAME_INFO, Util.field_240973_b_);
            player.func_241151_a_((ITextComponent)new StringTextComponent(TextFormatting.LIGHT_PURPLE + "Starting message: " + TextFormatting.WHITE + tag.func_74779_i("StartingMessage")), ChatType.GAME_INFO, Util.field_240973_b_);
            player.func_241151_a_((ITextComponent)new StringTextComponent(TextFormatting.LIGHT_PURPLE + "Ending message: " + TextFormatting.WHITE + tag.func_74779_i("EndingMessage")), ChatType.GAME_INFO, Util.field_240973_b_);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (hand == Hand.OFF_HAND) {
            return ActionResultType.PASS;
        }
        player.func_213317_d(Vector3d.field_186680_a);
        BattleOwnedTileEntityController bc = (BattleOwnedTileEntityController)world.func_175625_s(pos);
        if (player.func_184586_b(hand) != ItemStack.field_190927_a && player.func_184586_b(hand).func_77973_b() instanceof RulebookItem) {
            if (player.func_184586_b(hand).func_77942_o() && world.func_175625_s(pos) != null) {
                CompoundNBT tag = player.func_184586_b(hand).func_77978_p();
                bc.setDeckSize(tag.func_74762_e("DeckSize"));
                bc.setPrizeCount(tag.func_74762_e("PrizeCount"));
                bc.setTimeLimit(tag.func_74762_e("TimeLimit"));
                bc.setEloMinimum(tag.func_74762_e("EloMinimum"));
                bc.setStartingCommand(tag.func_74779_i("StartingCommand"));
                bc.setEndingCommand(tag.func_74779_i("EndingCommand"));
                bc.setStartingMessage(tag.func_74779_i("StartingMessage"));
                bc.setEndingMessage(tag.func_74779_i("EndingMessage"));
                player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.AQUA + "Updated BattleBox with following rules:"), Util.field_240973_b_);
                player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.LIGHT_PURPLE + "Deck size: " + TextFormatting.WHITE + tag.func_74762_e("DeckSize")), Util.field_240973_b_);
                player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.LIGHT_PURPLE + "Prize count: " + TextFormatting.WHITE + tag.func_74762_e("PrizeCount")), Util.field_240973_b_);
                player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.LIGHT_PURPLE + "Turn time limit: " + TextFormatting.WHITE + tag.func_74762_e("TimeLimit")), Util.field_240973_b_);
                player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.LIGHT_PURPLE + "Elo requirement: " + TextFormatting.WHITE + tag.func_74762_e("EloMinimum")), Util.field_240973_b_);
                player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.LIGHT_PURPLE + "Starting command: " + TextFormatting.WHITE + tag.func_74779_i("StartingCommand")), Util.field_240973_b_);
                player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.LIGHT_PURPLE + "Ending command: " + TextFormatting.WHITE + tag.func_74779_i("EndingCommand")), Util.field_240973_b_);
                player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.LIGHT_PURPLE + "Starting message: " + TextFormatting.WHITE + tag.func_74779_i("StartingMessage")), Util.field_240973_b_);
                player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.LIGHT_PURPLE + "Ending message: " + TextFormatting.WHITE + tag.func_74779_i("EndingMessage")), Util.field_240973_b_);
            }
            return ActionResultType.PASS;
        }
        if (bc != null) {
            GameServerState server = bc.getGameServer();
            if (server == null) {
                return ActionResultType.PASS;
            }
            ServerPlayerEntity p = (ServerPlayerEntity)player;
            boolean joined = false;
            for (int i = 0; i < 2; ++i) {
                if (server.getPlayer(i) == null || !server.getPlayer(i).getEntityPlayer().func_146103_bH().getId().equals(p.func_146103_bH().getId())) continue;
                server.getPlayer(i).setEntityPlayer((PlayerEntity)p);
                server.getPlayer(i).setInGUI(true);
                joined = true;
                NetworkHelper.sendPacket(new TCGGuiClientPacket(pos, i, false), p);
                break;
            }
            if (!joined) {
                if (server.isGameInProgress()) {
                    int playerIndex = 0;
                    NetworkHelper.sendPacket(new TCGGuiClientPacket(pos, playerIndex, true), p);
                    server.getSpectators().put(p.func_110124_au(), playerIndex);
                    return ActionResultType.SUCCESS;
                }
                if (player.func_184586_b(hand) != null && player.func_184586_b(hand).func_77973_b() instanceof ShadowWandItem) {
                    bc.toggleShadowGame();
                    if (bc.isShadowGame()) {
                        ChatHandler.sendFormattedChat((ICommandSource)player, TextFormatting.DARK_PURPLE, "Dark powers now dwell in this BattleBox.", new Object[0]);
                    } else {
                        ChatHandler.sendFormattedChat((ICommandSource)player, TextFormatting.DARK_PURPLE, "Dark powers no longer dwell in this BattleBox.", new Object[0]);
                    }
                    return ActionResultType.PASS;
                }
                if (player.func_184586_b(hand) == null || !(player.func_184586_b(hand).func_77973_b() instanceof DeckItem)) {
                    ChatHandler.sendFormattedChat((ICommandSource)player, TextFormatting.RED, "You have to hold a deck to join!", new Object[0]);
                    return ActionResultType.PASS;
                }
                List<ImmutableCard> cards = LogicHelper.getCards(player, player.func_184586_b(hand));
                String error = LogicHelper.validateDeck(cards, bc.getDeckSize());
                if (error != null) {
                    ChatHandler.sendFormattedChat((ICommandSource)player, TextFormatting.RED, error, new Object[0]);
                    return ActionResultType.PASS;
                }
                for (int i = 0; i < 2; ++i) {
                    if (server.getPlayer(i) != null) continue;
                    server.setPlayer(i, new PlayerServerState((PlayerEntity)p));
                    joined = true;
                    NetworkHelper.sendPacket(new TCGGuiClientPacket(pos, i, false), p);
                    break;
                }
            }
            if (!joined) {
                ChatHandler.sendFormattedChat((ICommandSource)p, TextFormatting.RED, "BattleBox is busy!", new Object[0]);
            }
            world.func_184138_a(pos, state, (BlockState)state.func_206870_a((Property)ON, (Comparable)Boolean.valueOf(server.isGameInProgress())), 8);
            return joined ? ActionResultType.SUCCESS : ActionResultType.PASS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{ON});
    }
}

