/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.api.util.helper;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.util.TargetPoint;
import com.pixelmonmod.tcg.TCG;
import com.pixelmonmod.tcg.network.data.TCGPacket;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class NetworkHelper {
    public static void sendPacket(TCGPacket packet, ServerPlayerEntity serverPlayer) {
        TCG.network.send(PacketDistributor.PLAYER.with(() -> serverPlayer), packet);
        if (Pixelmon.LOG_PACKETS) {
            TCG.LOGGER.info("Packet sent: " + packet.getClass().getSimpleName());
        }
    }

    public static void sendPacket(ServerPlayerEntity serverPlayer, TCGPacket packet) {
        TCG.network.send(PacketDistributor.PLAYER.with(() -> serverPlayer), packet);
        if (Pixelmon.LOG_PACKETS) {
            TCG.LOGGER.info("Packet sent: " + packet.getClass().getSimpleName());
        }
    }

    public static void sendNearbyPacket(TCGPacket packet, PacketDistributor.TargetPoint targetPoint) {
        TCG.network.send(PacketDistributor.NEAR.with(() -> targetPoint), packet);
        if (Pixelmon.LOG_PACKETS) {
            TCG.LOGGER.info("Packet sent: " + packet.getClass().getSimpleName());
        }
    }

    public static void sendNearbyPacket(PacketDistributor.TargetPoint targetPoint, TCGPacket packet) {
        TCG.network.send(PacketDistributor.NEAR.with(() -> targetPoint), packet);
        if (Pixelmon.LOG_PACKETS) {
            TCG.LOGGER.info("Packet sent: " + packet.getClass().getSimpleName());
        }
    }

    public static void sendNearbyPacket(TargetPoint targetPoint, Function<ServerPlayerEntity, TCGPacket> packetFunction) {
        double radiusSq = targetPoint.getRadius() * targetPoint.getRadius();
        List players = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v();
        for (int i = 0; i < players.size(); ++i) {
            double d2;
            double d1;
            double d0;
            ServerPlayerEntity player = (ServerPlayerEntity)players.get(i);
            if (player.field_70170_p.func_234923_W_() != targetPoint.getDimension() || !((d0 = targetPoint.getX() - player.func_226277_ct_()) * d0 + (d1 = targetPoint.getY() - player.func_226278_cu_()) * d1 + (d2 = targetPoint.getZ() - player.func_226281_cx_()) * d2 < radiusSq)) continue;
            NetworkHelper.sendPacket(player, packetFunction.apply(player));
        }
    }

    public static void sendToDimension(TCGPacket packet, World world) {
        TCG.network.send(PacketDistributor.DIMENSION.with(() -> ((World)world).func_234923_W_()), packet);
        if (Pixelmon.LOG_PACKETS) {
            TCG.LOGGER.info("Packet sent: " + packet.getClass().getSimpleName());
        }
    }

    public static void sendToAllTracking(TCGPacket packet, Entity entity) {
        TCG.network.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), packet);
        if (Pixelmon.LOG_PACKETS) {
            TCG.LOGGER.info("Packet sent: " + packet.getClass().getSimpleName());
        }
    }

    public static void sendToAll(TCGPacket packet) {
        TCG.network.send(PacketDistributor.ALL.with(() -> null), packet);
        if (Pixelmon.LOG_PACKETS) {
            TCG.LOGGER.info("Packet sent: " + packet.getClass().getSimpleName());
        }
    }

    public static void sendToServer(TCGPacket packet) {
        if (Minecraft.func_71410_x().field_71439_g != null) {
            TCG.network.sendToServer(packet);
            if (Pixelmon.LOG_PACKETS) {
                TCG.LOGGER.info("Packet sent: " + packet.getClass().getSimpleName());
            }
        }
    }
}

