/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.api.card;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.init.registry.ItemRegistration;
import com.pixelmonmod.tcg.item.DeckItem;
import java.util.List;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ThemeDeck {
    private final int id;
    private final String name;
    private List<ImmutableCard> cards = Lists.newArrayList();
    private List<ImmutableCard> extraCards = Lists.newArrayList();
    private final transient String json;

    public ThemeDeck(int id, String name, List<ImmutableCard> cards, List<ImmutableCard> extraCards, String json) {
        this.id = id;
        this.name = name;
        this.cards = cards;
        this.extraCards = extraCards;
        this.json = json;
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<ImmutableCard> getCards() {
        return this.cards;
    }

    public List<ImmutableCard> getExtraCards() {
        return this.extraCards;
    }

    public ITextComponent getLocalizedName() {
        return new TranslationTextComponent("deck." + this.getName().toLowerCase() + ".name");
    }

    public ItemStack getItemStack(int count) {
        ItemStack itemDeck = new ItemStack((IItemProvider)ItemRegistration.DECK.get(), 1);
        DeckItem.Deck deck = new DeckItem.Deck(new Inventory(62), false, -1);
        int i = 0;
        for (ImmutableCard card : this.getCards()) {
            try {
                deck.inventory.func_70299_a(i, card.getItemStack(1));
                ++i;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Pixelmon.LOGGER.error("Theme Deck: " + this.name + " had more than 60 cards! Please remove cards till it only has 60 cards");
                break;
            }
        }
        deck.writeToStack(itemDeck);
        itemDeck.func_190920_e(count);
        itemDeck.func_200302_a(this.getLocalizedName());
        return itemDeck;
    }

    public ItemStack getItemStack() {
        return this.getItemStack(1);
    }

    public String getJson() {
        return this.json;
    }
}

