/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.generation.features;

import com.mojang.serialization.Codec;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.blocks.enums.EnumPokechestVisibility;
import com.pixelmonmod.pixelmon.blocks.tileentity.PokeChestTileEntity;
import com.pixelmonmod.pixelmon.world.dimension.ultraspace.UltraSpace;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class PokeChestFeature
extends Feature<NoFeatureConfig> {
    private static int lastChunk = 0;
    private static int lastX;
    private static int lastZ;
    private static int totalPlaced;
    private static int normalPlaced;
    private static int ultraPlaced;

    public PokeChestFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean place(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (UltraSpace.is(world)) {
            return false;
        }
        if (PixelmonConfigProxy.getSpawning().getPokeLoot().isSpawnNormal() || PixelmonConfigProxy.getSpawning().getPokeLoot().isSpawnHidden()) {
            this.genBlocks(rand, pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, world);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void genBlocks(Random random, int chunkX, int chunkZ, ISeedReader world) {
        int x = random.nextInt(16) + chunkX * 16;
        int z = random.nextInt(16) + chunkZ * 16;
        int y = world.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, new BlockPos(x, 0, z)).func_177956_o();
        int distance = (int)Math.sqrt(Math.pow(lastX - x, 2.0) + Math.pow(lastZ - z, 2.0));
        if (distance >= PixelmonConfigProxy.getSpawning().getPokeLoot().getSpawnRate().getMinDistance() && lastChunk % PixelmonConfigProxy.getSpawning().getPokeLoot().getSpawnRate().getMinChunk() == 0) {
            BlockState underBlockState = world.func_180495_p(new BlockPos(x, y - 1, z));
            Block underBlock = underBlockState.func_177230_c();
            while (underBlock.func_203417_a((ITag)BlockTags.field_206952_E) || underBlock.func_203417_a((ITag)BlockTags.field_200031_h) || underBlockState.func_185904_a() == Material.field_151579_a) {
                if (--y <= 0) {
                    return;
                }
                underBlockState = world.func_180495_p(new BlockPos(x, y - 1, z));
                underBlock = underBlockState.func_177230_c();
            }
            if (underBlockState.func_185904_a() != Material.field_151587_i && underBlockState.func_185904_a() != Material.field_151586_h) {
                TileEntity chestEntity;
                Block block = PixelmonBlocks.poke_chest;
                if (normalPlaced > 4) {
                    if (ultraPlaced > 4) {
                        block = PixelmonBlocks.master_chest;
                        ultraPlaced = 0;
                    } else {
                        block = PixelmonBlocks.ultra_chest;
                        ++ultraPlaced;
                    }
                    normalPlaced = 0;
                } else {
                    ++normalPlaced;
                }
                BlockPos currentPos = new BlockPos(x, y, z);
                if (PixelmonConfigProxy.getSpawning().getPokeLoot().isSpawnHidden() && totalPlaced % PixelmonConfigProxy.getSpawning().getPokeLoot().getSpawnRate().getHiddenFrequency() == 0 && totalPlaced != 0 && block == PixelmonBlocks.poke_chest) {
                    world.func_180501_a(currentPos, PixelmonBlocks.poke_chest.func_176223_P(), 18);
                    chestEntity = world.func_175625_s(currentPos);
                    if (!(chestEntity instanceof PokeChestTileEntity)) return;
                    chestEntity.func_226984_a_((World)world.func_201672_e(), currentPos);
                    ((PokeChestTileEntity)chestEntity).setVisibility(EnumPokechestVisibility.Hidden);
                } else if (PixelmonConfigProxy.getSpawning().getPokeLoot().isSpawnNormal()) {
                    world.func_180501_a(currentPos, block.func_176223_P(), 18);
                } else if (PixelmonConfigProxy.getSpawning().getPokeLoot().isSpawnHidden()) {
                    world.func_180501_a(currentPos, PixelmonBlocks.poke_chest.func_176223_P(), 18);
                    chestEntity = world.func_175625_s(currentPos);
                    if (chestEntity instanceof PokeChestTileEntity) {
                        ((PokeChestTileEntity)chestEntity).setVisibility(EnumPokechestVisibility.Hidden);
                    }
                }
                TileEntity t0 = world.func_175625_s(currentPos);
                if (t0 instanceof PokeChestTileEntity) {
                    PokeChestTileEntity t = (PokeChestTileEntity)t0;
                    t.setChestOneTime(PixelmonConfigProxy.getSpawning().getPokeLoot().getSpawnMode().isOneTimeUse());
                    t.setDropOneTime(PixelmonConfigProxy.getSpawning().getPokeLoot().getSpawnMode().isOncePerPlayer());
                    t.setTimeEnabled(PixelmonConfigProxy.getSpawning().getPokeLoot().getSpawnMode().isTimeEnabled());
                    lastX = x;
                    lastZ = z;
                    ++totalPlaced;
                } else {
                    world.func_217377_a(currentPos, false);
                }
            } else {
                --lastChunk;
            }
        }
        ++lastChunk;
    }

    static {
        lastZ = 0;
        totalPlaced = 0;
        normalPlaced = 0;
        ultraPlaced = 0;
    }
}

