/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.dimension.ultraspace.surfacebuilders;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class UltraCraterSurfaceBuilder
extends SurfaceBuilder<SurfaceBuilderConfig> {
    private long seed;
    private ImmutableMap<BlockState, OctavesNoiseGenerator> floorNoises = ImmutableMap.of();
    private OctavesNoiseGenerator patchNoise;

    public UltraCraterSurfaceBuilder(Codec<SurfaceBuilderConfig> codec) {
        super(codec);
    }

    public void apply(Random random, IChunk chunk, Biome biome, int p_205610_4_, int p_205610_5_, int floorHeight, double p_205610_7_, BlockState p_205610_9_, BlockState p_205610_10_, int p_205610_11_, long p_205610_12_, SurfaceBuilderConfig config) {
        int i = p_205610_11_ + 1;
        int j = p_205610_4_ & 0xF;
        int k = p_205610_5_ & 0xF;
        int i1 = (int)(p_205610_7_ / 3.0 + 3.0 + random.nextDouble() * 0.25);
        boolean flag = this.patchNoise.func_205563_a((double)p_205610_4_ * 0.03125, 109.0, (double)p_205610_5_ * 0.03125) * 75.0 + random.nextDouble() > 0.0;
        BlockState blockstate = this.findBiggest(p_205610_4_, p_205610_11_, p_205610_5_);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        BlockState blockstate2 = chunk.func_180495_p((BlockPos)blockpos$mutable.func_181079_c(j, 128, k));
        for (int j1 = floorHeight; j1 >= 0; --j1) {
            blockpos$mutable.func_181079_c(j, j1, k);
            BlockState blockstate3 = chunk.func_180495_p((BlockPos)blockpos$mutable);
            if ((blockstate2.func_196958_f() || blockstate2 == p_205610_10_) && blockstate3.func_203425_a(p_205610_9_.func_177230_c())) {
                for (int l1 = 0; l1 < i1 && chunk.func_180495_p((BlockPos)blockpos$mutable).func_203425_a(p_205610_9_.func_177230_c()); ++l1) {
                    if (flag && j1 >= i - 4 && j1 <= i + 1) {
                        chunk.func_177436_a((BlockPos)blockpos$mutable, this.getPatchBlockState(), false);
                    } else {
                        chunk.func_177436_a((BlockPos)blockpos$mutable, blockstate, false);
                    }
                    blockpos$mutable.func_189536_c(Direction.DOWN);
                }
            }
            blockstate2 = blockstate3;
        }
    }

    private BlockState findBiggest(int i, int j, int k) {
        double biggest = -2.147483647E9;
        BlockState state = null;
        double value = 0.0;
        for (Map.Entry entry : this.floorNoises.entrySet()) {
            value = ((OctavesNoiseGenerator)entry.getValue()).func_205563_a((double)i, (double)j, (double)k);
            if (!(value > biggest)) continue;
            biggest = value;
            state = (BlockState)entry.getKey();
        }
        return state;
    }

    public void func_205548_a(long seed) {
        if (this.seed != seed || this.patchNoise == null || this.floorNoises.isEmpty()) {
            this.floorNoises = UltraCraterSurfaceBuilder.initPerlinNoises(this.getFloorBlockStates(), seed);
            this.patchNoise = new OctavesNoiseGenerator(new SharedSeedRandom(seed + (long)this.floorNoises.size()), (List)ImmutableList.of((Object)0));
        }
        this.seed = seed;
    }

    private static ImmutableMap<BlockState, OctavesNoiseGenerator> initPerlinNoises(ImmutableList<BlockState> blocks, long seed) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState blockstate : blocks) {
            builder.put((Object)blockstate, (Object)new OctavesNoiseGenerator(new SharedSeedRandom(seed), (List)ImmutableList.of((Object)-4)));
            ++seed;
        }
        return builder.build();
    }

    protected ImmutableList<BlockState> getFloorBlockStates() {
        return ImmutableList.of((Object)Blocks.field_196836_iG.func_176223_P(), (Object)Blocks.field_196868_iW.func_176223_P());
    }

    protected BlockState getPatchBlockState() {
        return Blocks.field_196830_iD.func_176223_P();
    }
}

