/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.spawning;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawningTweak;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnActionPokemon;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnInfoPokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.storage.TransientData;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.spawning.PlayerTrackingSpawner;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.MathHelper;

public class FluteLevelTweak
implements SpawningTweak {
    @Override
    public void doTweak(AbstractSpawner spawner, SpawnAction<? extends Entity> action) {
        if (!(action instanceof SpawnActionPokemon)) {
            return;
        }
        SpawnActionPokemon spawnActionPokemon = (SpawnActionPokemon)action;
        PixelmonEntity pokemon = (PixelmonEntity)spawnActionPokemon.getOrCreateEntity();
        SpawnActionPokemon actionPokemon = (SpawnActionPokemon)action;
        if (!(action.spawnInfo instanceof SpawnInfoPokemon)) {
            return;
        }
        if (pokemon.isBossPokemon()) {
            return;
        }
        int newLevel = this.getTweakedLevel(spawner, actionPokemon, actionPokemon.pokemon.getPokemonLevel());
        pokemon.getPokemon().setLevel(newLevel);
        pokemon.func_70606_j(pokemon.getPokemon().getHealth());
    }

    public int getTweakedLevel(AbstractSpawner spawner, SpawnAction<? extends Entity> action, int level) {
        PlayerPartyStorage storage = spawner instanceof PlayerTrackingSpawner ? ((PlayerTrackingSpawner)spawner).playerStorage : StorageProxy.getParty((ServerPlayerEntity)action.spawnLocation.cause);
        if (storage == null) {
            return level;
        }
        TransientData td = storage.transientData;
        long time = System.currentTimeMillis();
        if (td.isBlackFluteActive(time)) {
            return MathHelper.func_76125_a((int)(level + RandomHelper.rand.nextInt(PixelmonConfigProxy.getSpawning().getLureFluteLevelModifier())), (int)1, (int)PixelmonConfigProxy.getGeneral().getMaxLevel());
        }
        if (td.isWhiteFluteActive(time)) {
            return MathHelper.func_76125_a((int)(level - RandomHelper.rand.nextInt(PixelmonConfigProxy.getSpawning().getLureFluteLevelModifier())), (int)1, (int)PixelmonConfigProxy.getGeneral().getMaxLevel());
        }
        return level;
    }
}

