/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.editor;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.quests.client.editor.ui.TextField;
import com.pixelmonmod.pixelmon.quests.editor.QuestElementType;
import com.pixelmonmod.pixelmon.quests.editor.args.ArgumentType;
import com.pixelmonmod.pixelmon.quests.editor.args.QuestElementArgument;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class QuestElement {
    private QuestElementType type;
    private String name;
    private String identifier;
    private QuestElementArgument[] args;
    private transient String extra = "";
    private final ArrayList<TextField> fields = new ArrayList();

    public QuestElement(QuestElementType type, String identifier, boolean unused) {
        this(type, identifier, new QuestElementArgument("Arg 1", true, false, ArgumentType.TEXT, new String[0]), new QuestElementArgument("Arg 2", true, false, ArgumentType.TEXT, new String[0]), new QuestElementArgument("Arg 3", true, false, ArgumentType.TEXT, new String[0]), new QuestElementArgument("Arg 4", true, false, ArgumentType.TEXT, new String[0]), new QuestElementArgument("Arg 5", true, false, ArgumentType.TEXT, new String[0]), new QuestElementArgument("Arg 6", true, false, ArgumentType.TEXT, new String[0]), new QuestElementArgument("Arg 7", true, false, ArgumentType.TEXT, new String[0]), new QuestElementArgument("Arg 8", true, false, ArgumentType.TEXT, new String[0]), new QuestElementArgument("Arg 9", true, false, ArgumentType.TEXT, new String[0]), new QuestElementArgument("Arg 10", true, false, ArgumentType.TEXT, new String[0]));
    }

    public QuestElement(QuestElementType type, String identifier, QuestElementArgument ... args) {
        this(type, identifier, "quest.element." + identifier.toLowerCase(Locale.ROOT) + "", args);
    }

    public QuestElement(QuestElementType type, String identifier, String name, QuestElementArgument ... args) {
        this.type = type;
        this.name = name;
        this.identifier = identifier;
        this.args = args;
    }

    public QuestElement(PacketBuffer buf) {
        this.readFromByteBuf(buf);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initialize(Minecraft mc, int x, int y, int w, int h) {
        int left = x + w / 2 + 6;
        int top = y + 22;
        int width = 121;
        int height = 9;
        this.fields.clear();
        int i = 0;
        for (QuestElementArgument arg : this.args) {
            TextField field = new TextField(mc.field_71466_p, left, top + (height + 8) * i, width, height, -6908266, -7895161);
            field.setMaxStringLength(Integer.MAX_VALUE);
            field.setText(arg.getCurrentValue());
            this.updateValidity(field, arg);
            this.fields.add(field);
            ++i;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(MatrixStack matrix, Minecraft mc, int x, int y, int w, int h) {
        if (this.fields.size() != this.args.length) {
            this.initialize(mc, x, y, w, h);
        }
        int index = 0;
        for (TextField field : this.fields) {
            QuestElementArgument arg = this.args[index];
            field.renderWidget(matrix, x, y, Minecraft.func_71410_x().func_184121_ak());
            mc.field_71466_p.func_238421_b_(matrix, TextFormatting.BOLD + arg.getName(), (float)field.xPosition, (float)(field.yPosition - 8), 0);
            if (arg.getOptions().length > 0) {
                GlStateManager.func_227740_m_();
                GlStateManager.func_227676_b_((int)770, (int)771);
                ScreenHelper.drawImage(matrix, Resources.refresh, (float)(field.xPosition + field.width - field.height), (float)field.yPosition, (float)field.height, (float)field.height, 0.0f, 0.6f, 1.0f, 1.0f, 2.0f);
            }
            ++index;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onClick(double mouseX, double mouseY, int mouseButton) {
        int index = 0;
        for (TextField field : this.fields) {
            QuestElementArgument arg = this.args[index];
            boolean skip = false;
            if (arg.getOptions().length > 0) {
                int x = field.xPosition + field.width - field.height;
                int y = field.yPosition;
                if (mouseX > (double)x && mouseX < (double)(x + field.height) && mouseY > (double)y && mouseY < (double)(y + field.height)) {
                    skip = true;
                    boolean set = false;
                    String value = arg.getTrueCurrentValue();
                    for (int i = 0; i < arg.getOptions().length; ++i) {
                        if (!arg.getOptions()[i].equalsIgnoreCase(value)) continue;
                        if (i + 1 == arg.getOptions().length) {
                            arg.setCurrentValue("");
                        } else {
                            arg.setCurrentValue(arg.getOptions()[i + 1]);
                        }
                        set = true;
                    }
                    if (!set) {
                        arg.setCurrentValue(arg.getOptions()[0]);
                    }
                    field.setText(arg.getCurrentValue());
                    this.updateValidity(field, arg);
                }
            }
            if (!skip) {
                field.mouseClicked(mouseX, mouseY, mouseButton);
            }
            ++index;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onType(char c, int i) {
        int index = 0;
        for (TextField field : this.fields) {
            if (field.isFocused() && field.charTyped(c, i)) {
                QuestElementArgument arg = this.args[index];
                arg.setCurrentValue(field.getText());
                this.updateValidity(field, arg);
            }
            ++index;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateValidity(TextField field, QuestElementArgument arg) {
        boolean valid = arg.isValid();
        field.setTextColor(valid ? 0xFFFFFF : 14889216);
        field.setBorderColour(valid ? -7895161 : -1888000);
    }

    public QuestElement copy() {
        QuestElementArgument[] args = new QuestElementArgument[this.args.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.args[i].copy();
        }
        return new QuestElement(this.type, this.identifier, args);
    }

    public void duplicate(QuestElement element) {
        this.type = element.type;
        this.name = element.name;
        this.identifier = element.identifier;
        this.args = new QuestElementArgument[element.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i] = element.args[i].copy();
        }
    }

    public QuestElement create(Quest quest, String args) {
        QuestElement qe = this.copy();
        String[] split = args.split(" ");
        int start = 1;
        if (qe.type == QuestElementType.ACTION) {
            qe.setExtra(split[0]);
            ++start;
        }
        for (int i = start; i < split.length; ++i) {
            int argIndex = i - start;
            if (argIndex >= qe.args.length) continue;
            String value = split[i];
            if (qe.args[argIndex].isString()) {
                boolean translatable;
                String str = quest.getUnlocalizedString(value);
                boolean bl = translatable = str != null && I18n.func_188566_a((String)str);
                if (!translatable && (str == null || value.isEmpty() || value.equalsIgnoreCase("-"))) {
                    value = "";
                } else if (!translatable) {
                    value = str;
                }
            }
            qe.args[argIndex].setCurrentValue(value);
        }
        return qe;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public String getExtra() {
        return this.extra;
    }

    public QuestElementType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public QuestElementArgument[] getArgs() {
        return this.args;
    }

    public String build(Quest quest, Stage stage, int i) {
        if (this.type == QuestElementType.OBJECTIVE) {
            StringBuilder builder = new StringBuilder(this.identifier);
            int j = 0;
            for (QuestElementArgument arg : this.args) {
                if (arg.isString()) {
                    String key = "s" + stage.getStage() + "-o" + i + "-p" + j++;
                    if (arg.isEmpty()) {
                        builder.append(" -");
                        quest.removeUnlocalizedString(key);
                        continue;
                    }
                    if (I18n.func_188566_a((String)quest.getLangKey(arg.getTrueCurrentValue())) || I18n.func_188566_a((String)arg.getTrueCurrentValue())) {
                        builder.append(" ").append(arg.getTrueCurrentValue());
                        continue;
                    }
                    builder.append(" ").append(key);
                    quest.putUnlocalizedString(key, arg.getCurrentValue());
                    continue;
                }
                builder.append(" ").append(arg.getTrueCurrentValue());
            }
            return builder.toString();
        }
        if (this.type == QuestElementType.ACTION) {
            StringBuilder builder = new StringBuilder(this.extra).append(" ").append(this.identifier);
            int j = 0;
            for (QuestElementArgument arg : this.args) {
                if (arg.isString()) {
                    String key = "s" + stage.getStage() + "-a" + i + "-p" + j++;
                    if (arg.isEmpty()) {
                        builder.append(" -");
                        quest.removeUnlocalizedString(key);
                        continue;
                    }
                    if (I18n.func_188566_a((String)quest.getLangKey(arg.getTrueCurrentValue())) || I18n.func_188566_a((String)arg.getTrueCurrentValue())) {
                        builder.append(" ").append(arg.getTrueCurrentValue());
                        continue;
                    }
                    builder.append(" ").append(key);
                    quest.putUnlocalizedString(key, arg.getCurrentValue());
                    continue;
                }
                builder.append(" ").append(arg.getTrueCurrentValue());
            }
            return builder.toString();
        }
        return "";
    }

    public void readFromByteBuf(PacketBuffer buf) {
        this.type = QuestElementType.values()[buf.readByte()];
        this.name = buf.func_218666_n();
        this.identifier = buf.func_218666_n();
        this.args = new QuestElementArgument[buf.readShort()];
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i] = new QuestElementArgument(buf);
        }
    }

    public void writeToByteBuf(PacketBuffer buf) {
        buf.writeByte(this.type.ordinal());
        buf.func_180714_a(this.name);
        buf.func_180714_a(this.identifier);
        buf.writeShort(this.args.length);
        for (QuestElementArgument arg : this.args) {
            arg.writeToByteBuf(buf);
        }
    }
}

