/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.client.ui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.quests.client.ObjectiveDetail;
import com.pixelmonmod.pixelmon.quests.client.QuestDataClient;
import com.pixelmonmod.pixelmon.quests.client.QuestProgressClient;
import com.pixelmonmod.pixelmon.quests.client.ui.GuiListQuest;
import com.pixelmonmod.pixelmon.quests.comm.AbandonQuestPacket;
import com.pixelmonmod.pixelmon.quests.quest.QuestColor;
import java.awt.Color;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiQuests
extends Screen {
    private Button random;
    private Button craft;
    private GuiListQuest questList;
    private GuiListQuest completeList;
    private boolean showActive = true;
    private int activeSeperator = 25;
    private boolean init = false;
    private boolean abandoning = false;
    private int abandonColor = -5767168;
    private boolean rising = true;

    public GuiQuests() {
        super(StringTextComponent.field_240750_d_);
    }

    public void func_231160_c_() {
        this.field_230710_m_.clear();
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        int gap = 3;
        int x = this.field_230708_k_ / 2 - 125;
        int y = this.field_230709_l_ / 2 - 100;
        this.questList = new GuiListQuest(this.field_230706_i_.field_71466_p, x + 7, y + 23, 104, 9);
        this.completeList = new GuiListQuest(this.field_230706_i_.field_71466_p, x + 7, y + 27, 104, 9);
        this.refreshQuests();
        this.questList.setFocused(true);
    }

    public void refreshQuests() {
        this.questList.lines.clear();
        this.completeList.lines.clear();
        for (QuestProgressClient qpc : QuestDataClient.getInstance().getQuests()) {
            if (qpc.getName() == null) continue;
            this.questList.addLine(qpc);
        }
        for (QuestProgressClient qpc : QuestDataClient.getInstance().getCompleteQuests()) {
            this.completeList.addLine(qpc);
        }
        this.questList.selectQuest(-1);
        this.completeList.selectQuest(-1);
    }

    public void func_230446_a_(MatrixStack p_230446_1_) {
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        int gap = 3;
        int x = this.field_230708_k_ / 2 - 125;
        int y = this.field_230709_l_ / 2 - 100;
        int div = 2 * gap;
        int border = 25;
        int lowerBorder = dispHeight - border - div;
        float v = (float)(x + gap * 3) + 3.0f * (float)dispWidth / 4.0f;
        int sliderSpeed = 5;
        if (mouseX >= (double)((int)((float)(x + gap * 3) + (float)dispWidth / 2.0f) + 1) && mouseX <= (double)((int)((float)x + 3.0f * (float)dispWidth / 4.0f)) && mouseY >= (double)(y + lowerBorder - div) && mouseY <= (double)(y + dispHeight - div)) {
            QuestProgressClient selectedQuest = null;
            if (this.questList.selectedQuest != null && this.questList.selectedQuest != -1) {
                selectedQuest = this.questList.lines.get(this.questList.selectedQuest);
            }
            if (selectedQuest != null) {
                boolean openEye;
                boolean bl = openEye = QuestDataClient.getInstance().getDisplayQuest() != selectedQuest;
                if (openEye) {
                    QuestDataClient.getInstance().setDisplayQuest(selectedQuest);
                } else {
                    QuestDataClient.getInstance().setDisplayQuest(null);
                }
            }
        } else {
            QuestProgressClient clickedOnQuest;
            if (mouseX >= (double)v && mouseX <= (double)(x + dispWidth - 2) && mouseY >= (double)(y + lowerBorder - div) && mouseY <= (double)(y + dispHeight - div)) {
                QuestProgressClient selectedQuest;
                if (this.questList.selectedQuest != null && this.questList.selectedQuest != -1 && (selectedQuest = this.questList.lines.get(this.questList.selectedQuest)).isAbandonable()) {
                    if (!this.abandoning) {
                        this.questList.scrollUp();
                        this.completeList.scrollUp();
                        this.abandoning = true;
                    } else {
                        if (QuestDataClient.getInstance().getDisplayQuest() == selectedQuest) {
                            QuestDataClient.getInstance().setDisplayQuest(null);
                        }
                        NetworkHelper.sendToServer(new AbandonQuestPacket(selectedQuest));
                    }
                }
                return true;
            }
            if (this.activeSeperator == border && mouseX > (double)(x - gap) && mouseX < (double)(x - gap + dispWidth / 2) && mouseY > (double)y && mouseY < (double)(y + this.activeSeperator) && !this.showActive) {
                this.showActive = true;
                this.questList.setFocused(true);
                this.completeList.setFocused(false);
            } else if (this.activeSeperator == lowerBorder && mouseX > (double)(x - gap) && mouseX < (double)(x - gap + dispWidth / 2) && mouseY > (double)(y + this.activeSeperator + div) && mouseY < (double)(y + dispHeight) && this.showActive) {
                this.showActive = false;
                this.completeList.setFocused(true);
                this.questList.setFocused(false);
            } else if (this.questList.isFocused) {
                QuestProgressClient clickedOnQuest2 = this.questList.mouseClicked(mouseX, mouseY, 0, this.questList.yPos + 8);
                if (clickedOnQuest2 != null) {
                    int lineindex = this.questList.lines.indexOf(clickedOnQuest2);
                    this.completeList.selectQuest(-1);
                    this.questList.selectQuest(lineindex);
                }
            } else if (this.completeList.isFocused && (clickedOnQuest = this.completeList.mouseClicked(mouseX, mouseY, 0, this.completeList.yPos + 8)) != null) {
                int lineindex = this.completeList.lines.indexOf(clickedOnQuest);
                this.questList.selectQuest(-1);
                this.completeList.selectQuest(lineindex);
            }
        }
        this.abandoning = false;
        return true;
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float f) {
        int qlh;
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.blendFunc((int)770, (int)771);
        super.func_230430_a_(matrix, mouseX, mouseY, f);
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        this.field_230706_i_.func_110434_K().func_110577_a(Resources.backgroundTexture);
        int gap = 3;
        int x = this.field_230708_k_ / 2 - 125;
        int y = this.field_230709_l_ / 2 - 100;
        int div = 2 * gap;
        int border = 25;
        int lowerBorder = dispHeight - border - div;
        if (!this.init) {
            this.activeSeperator = dispHeight - border - div;
        }
        int sliderSpeed = 5;
        if (!this.showActive) {
            if (this.activeSeperator > border) {
                this.activeSeperator -= sliderSpeed;
                if (this.activeSeperator <= border) {
                    this.activeSeperator = border;
                }
            }
        } else if (this.activeSeperator < lowerBorder) {
            this.activeSeperator += sliderSpeed;
            if (this.activeSeperator >= lowerBorder) {
                this.activeSeperator = lowerBorder;
            }
        }
        if ((qlh = this.activeSeperator - border - 12) <= 2) {
            this.questList.isEnabled = false;
        } else {
            this.questList.isEnabled = true;
            this.questList.height = qlh;
            this.questList.displayLines = (int)(9.0f * ((float)qlh / (float)(lowerBorder - border - 12)));
        }
        float titleBorder = 8.5f;
        int clh = lowerBorder - 12 - this.activeSeperator;
        this.completeList.yPos = y + (int)titleBorder + this.activeSeperator + div + 16;
        if (clh <= 2) {
            this.completeList.isEnabled = false;
        } else {
            this.completeList.isEnabled = true;
            this.completeList.height = clh;
            this.completeList.displayLines = (int)(9.0f * ((float)clh / (float)(lowerBorder - 12 - border)));
        }
        GuiQuests.func_238463_a_((MatrixStack)matrix, (int)(x - gap), (int)y, (float)0.0f, (float)0.0f, (int)(dispWidth / 2), (int)this.activeSeperator, (int)((int)((float)dispWidth / 2.0f)), (int)this.activeSeperator);
        GuiQuests.func_238463_a_((MatrixStack)matrix, (int)(x - gap), (int)(y + this.activeSeperator + div), (float)0.0f, (float)0.0f, (int)(dispWidth / 2), (int)(dispHeight - div - this.activeSeperator), (int)((int)((float)dispWidth / 2.0f)), (int)(dispHeight - div - this.activeSeperator));
        GuiQuests.func_238463_a_((MatrixStack)matrix, (int)(x + dispWidth / 2 + gap + 1), (int)y, (float)0.0f, (float)0.0f, (int)(dispWidth / 2), (int)dispHeight, (int)((int)((float)dispWidth / 2.0f)), (int)dispHeight);
        String textA = TextFormatting.BOLD + I18n.func_135052_a((String)"quest.ui.quests", (Object[])new Object[0]);
        this.field_230712_o_.func_238421_b_(matrix, textA, (float)(x - gap + dispWidth / 4 - this.field_230712_o_.func_78256_a(textA) / 2), (float)y + titleBorder, 0xFFFFFF);
        String textB = TextFormatting.BOLD + I18n.func_135052_a((String)"quest.ui.history", (Object[])new Object[0]);
        this.field_230712_o_.func_238421_b_(matrix, textB, (float)(x - gap + dispWidth / 4 - this.field_230712_o_.func_78256_a(textB) / 2), (float)y + titleBorder + (float)this.activeSeperator + (float)div, 0xFFFFFF);
        if (this.questList.isEnabled) {
            this.questList.drawBackground(matrix);
            this.questList.drawText(matrix);
        }
        if (this.completeList.isEnabled) {
            this.completeList.drawBackground(matrix);
            this.completeList.drawText(matrix);
        }
        QuestProgressClient selectedQuest = null;
        if (this.questList.selectedQuest != null && this.questList.selectedQuest != -1) {
            selectedQuest = this.questList.lines.get(this.questList.selectedQuest);
        } else if (this.completeList.selectedQuest != null && this.completeList.selectedQuest != -1) {
            selectedQuest = this.completeList.lines.get(this.completeList.selectedQuest);
        }
        if (selectedQuest != null) {
            String title = selectedQuest.getName();
            String desc = selectedQuest.getDesc();
            int width = (int)((float)dispWidth / 2.0f - 9.0f);
            int descHeight = this.field_230712_o_.func_78267_b(desc, width);
            int strWidth = this.field_230712_o_.func_78256_a(title);
            double wf = 95.0;
            double finalWidth = Math.min((double)strWidth, wf - 6.0);
            ScreenHelper.drawSquashedString(matrix, this.field_230712_o_, title, false, (float)wf, (float)((int)((double)((float)(x + gap) + (float)dispWidth / 4.0f * 3.0f) - finalWidth / 2.0 + 6.0)), (float)((int)((float)y + titleBorder)), 0xFFFFFF, true);
            ScreenHelper.drawSplitString(matrix, desc, (int)((float)(x + gap * 3) + (float)dispWidth / 2.0f), (int)((float)y + titleBorder + 17.0f), width, 0xFFFFFF);
            for (ObjectiveDetail od : selectedQuest.getObjectives()) {
                int channel = 5;
                String detail = selectedQuest.format(od);
                if (detail.isEmpty()) continue;
                int detailHeight = this.field_230712_o_.func_78267_b(detail, width - channel);
                int n = (int)((float)(x + gap * 3) + (float)dispWidth / 2.0f) + channel;
                int n2 = (int)((float)y + titleBorder + 14.0f) + descHeight;
                this.field_230712_o_.getClass();
                ScreenHelper.drawSplitString(matrix, detail, n, n2 + 9, width - channel, 0xFFFFFF);
                descHeight += detailHeight;
            }
            RenderSystem.enableBlend();
            RenderSystem.enableAlphaTest();
            RenderSystem.blendFunc((int)770, (int)771);
            this.field_230706_i_.func_110434_K().func_110577_a(selectedQuest.isComplete() ? Resources.question_mark : selectedQuest.getIcon().getResource());
            if (selectedQuest.isComplete()) {
                RenderSystem.color4f((float)0.8509804f, (float)0.8509804f, (float)0.8509804f, (float)1.0f);
            } else {
                QuestColor color = selectedQuest.getColor();
                RenderSystem.color4f((float)color.floatR(), (float)color.floatG(), (float)color.floatB(), (float)1.0f);
            }
            GuiQuests.func_238463_a_((MatrixStack)matrix, (int)((int)((double)((float)(x + gap) + (float)dispWidth / 4.0f * 3.0f) - finalWidth / 2.0) - 11), (int)((int)((float)y + titleBorder) - 4), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
        int inactiveButtonColor = -9079435;
        boolean openEye = selectedQuest == null || QuestDataClient.getInstance().getDisplayQuest() != selectedQuest;
        GuiQuests.func_238467_a_((MatrixStack)matrix, (int)((int)((float)(x + gap * 3) + (float)dispWidth / 2.0f) + 1), (int)(y + lowerBorder - div), (int)((int)((float)x + 3.0f * (float)dispWidth / 4.0f)), (int)(y + dispHeight - div), (int)(selectedQuest == null || selectedQuest.isComplete() ? inactiveButtonColor : (openEye ? -12884481 : -10467329)));
        float v = (float)(x + gap * 3) + 3.0f * (float)dispWidth / 4.0f;
        int resting = -5767168;
        int alerting = -1179648;
        int diff = 65536;
        if (this.abandoning) {
            if (this.rising) {
                this.abandonColor += diff;
                if (this.abandonColor >= alerting) {
                    this.rising = false;
                }
            } else {
                this.abandonColor -= diff;
                if (this.abandonColor <= resting) {
                    this.rising = true;
                }
            }
        } else if (this.abandonColor > resting) {
            this.abandonColor -= diff;
            if (this.abandonColor <= resting) {
                this.abandonColor = resting;
            }
        } else {
            this.abandonColor = resting;
        }
        GuiQuests.func_238467_a_((MatrixStack)matrix, (int)((int)v), (int)(y + lowerBorder - div), (int)(x + dispWidth - 2), (int)(y + dispHeight - div), (int)(selectedQuest == null || selectedQuest.isComplete() || !selectedQuest.isAbandonable() ? inactiveButtonColor : this.abandonColor));
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.blendFunc((int)770, (int)771);
        if (openEye) {
            this.field_230706_i_.func_110434_K().func_110577_a(Resources.eyeTexture);
        } else {
            this.field_230706_i_.func_110434_K().func_110577_a(Resources.eyeClosedTexture);
        }
        GuiQuests.func_238463_a_((MatrixStack)matrix, (int)((int)((float)(x + gap * 3) + (float)dispWidth / 2.0f) + 11), (int)((int)((float)(y + lowerBorder) - (float)div * 1.55f)), (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
        this.field_230706_i_.func_110434_K().func_110577_a(Resources.crossTexture);
        GuiQuests.func_238463_a_((MatrixStack)matrix, (int)((int)v + 11), (int)((int)((float)(y + lowerBorder) - (float)div * 1.55f)), (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
        String leftButton = openEye ? I18n.func_135052_a((String)"quest.ui.track", (Object[])new Object[0]) : I18n.func_135052_a((String)"quest.ui.hide", (Object[])new Object[0]);
        this.field_230712_o_.func_238421_b_(matrix, leftButton, (float)((int)((float)(x + gap * 3) + (float)dispWidth / 2.0f) + 27) - (float)this.field_230712_o_.func_78256_a(leftButton) / 2.0f, (float)((int)((float)(y + lowerBorder) - (float)div * 1.55f) + 26), 0xFFFFFF);
        String rightButton = this.abandoning ? I18n.func_135052_a((String)"quest.ui.abandoncheck", (Object[])new Object[0]) : I18n.func_135052_a((String)"quest.ui.abandon", (Object[])new Object[0]);
        this.field_230712_o_.func_238421_b_(matrix, rightButton, (float)((int)v + 27) - (float)this.field_230712_o_.func_78256_a(rightButton) / 2.0f, (float)((int)((float)(y + lowerBorder) - (float)div * 1.55f) + 26), 0xFFFFFF);
        if (Pixelmon.isDevEnvironment()) {
            this.field_230712_o_.func_238421_b_(matrix, "X: " + mouseX + " Y: " + mouseY, (float)(mouseX + 10), (float)(mouseY + 10), Color.red.getRGB());
        }
        if (!this.init) {
            this.init = true;
        }
    }

    public boolean func_231043_a_(double p_231043_1_, double p_231043_3_, double mousewheelDirection) {
        if (mousewheelDirection == 1.0) {
            if (this.questList.isFocused) {
                this.questList.scrollDown();
            } else if (this.completeList.isFocused) {
                this.completeList.scrollDown();
            }
        } else if (mousewheelDirection == -1.0) {
            if (this.questList.isFocused) {
                this.questList.scrollUp();
            } else if (this.completeList.isFocused) {
                this.completeList.scrollUp();
            }
        }
        return true;
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void func_231023_e_() {
    }
}

