/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.listener;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.CommonHelper;
import com.pixelmonmod.pixelmon.enums.EnumFeatureState;
import com.pixelmonmod.pixelmon.enums.EnumMegaItem;
import com.pixelmonmod.pixelmon.enums.EnumMegaItemsUnlocked;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EntityPlayerExtension {
    public static DataParameter<String> dwPokeballs;
    public static DataParameter<Byte> dwMegaItem;
    public static DataParameter<Byte> dwMegaItemsUnlocked;
    public static DataParameter<Byte> dwShinyCharm;
    public static DataParameter<Byte> dwOvalCharm;
    public static DataParameter<Byte> dwExpCharm;
    public static DataParameter<Byte> dwCatchingCharm;
    public static DataParameter<Byte> dwMarkCharm;
    public static DataParameter<Byte> dwHween;

    public static boolean isDefined(PlayerEntity player) {
        return player.func_184212_Q().func_187219_c(dwPokeballs) != null && player.func_184212_Q().func_187219_c(dwMegaItem) != null && player.func_184212_Q().func_187219_c(dwMegaItemsUnlocked) != null && player.func_184212_Q().func_187219_c(dwShinyCharm) != null && player.func_184212_Q().func_187219_c(dwOvalCharm) != null && player.func_184212_Q().func_187219_c(dwExpCharm) != null && player.func_184212_Q().func_187219_c(dwCatchingCharm) != null && player.func_184212_Q().func_187219_c(dwMarkCharm) != null && player.func_184212_Q().func_187219_c(dwHween) != null;
    }

    @SubscribeEvent
    public static void handleConstruction(EntityEvent.EntityConstructing event) {
        if (event.getEntity() instanceof PlayerEntity) {
            EntityDataManager dw = event.getEntity().func_184212_Q();
            dw.func_187214_a(dwPokeballs, (Object)",,,,,,");
            dw.func_187214_a(dwMegaItem, (Object)0);
            dw.func_187214_a(dwMegaItemsUnlocked, (Object)0);
            dw.func_187214_a(dwShinyCharm, (Object)0);
            dw.func_187214_a(dwOvalCharm, (Object)0);
            dw.func_187214_a(dwExpCharm, (Object)0);
            dw.func_187214_a(dwCatchingCharm, (Object)0);
            dw.func_187214_a(dwMarkCharm, (Object)0);
            dw.func_187214_a(dwHween, (Object)0);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            EntityPlayerExtension.resendAll((ServerPlayerEntity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            EntityPlayerExtension.resendAll((ServerPlayerEntity)event.getPlayer());
        }
    }

    private static void resendAll(ServerPlayerEntity player) {
        PlayerPartyStorage party = StorageProxy.getParty(player);
        if (party != null) {
            EntityPlayerExtension.updatePlayerPokeballs(player, party.getAll());
            EntityPlayerExtension.updatePlayerMegaItem(player, party.getMegaItem());
            EntityPlayerExtension.updatePlayerMegaItemsUnlocked(player, party.getMegaItemsUnlocked());
            EntityPlayerExtension.updatePlayerOvalCharm(player, party.getOvalCharm());
            EntityPlayerExtension.updatePlayerShinyCharm(player, party.getShinyCharm());
            EntityPlayerExtension.updatePlayerHweenRobe(player, party.getHweenRobe());
        }
    }

    public static void updatePlayerPokeballs(ServerPlayerEntity player, Pokemon[] pokemon) {
        if (player == null) {
            return;
        }
        StringBuilder ballsList = new StringBuilder();
        for (int i = 0; i < pokemon.length; ++i) {
            if (pokemon[i] != null && !pokemon[i].isEgg()) {
                ballsList.append(pokemon[i].getBall().getName()).append(",");
                continue;
            }
            ballsList.append(",");
        }
        player.func_184212_Q().func_187227_b(dwPokeballs, (Object)ballsList.toString());
    }

    public static String[] getPlayerPokeballs(PlayerEntity player) {
        String ballsList = (String)player.func_184212_Q().func_187225_a(dwPokeballs);
        String[] splits = ballsList.split(",");
        String[] balls = new String[6];
        System.arraycopy(splits, 0, balls, 0, splits.length);
        return balls;
    }

    public static void updatePlayerMegaItem(ServerPlayerEntity player, EnumMegaItem megaItem) {
        player.func_184212_Q().func_187227_b(dwMegaItem, (Object)((byte)megaItem.ordinal()));
    }

    public static EnumMegaItem getPlayerMegaItem(PlayerEntity player) {
        return EnumMegaItem.fromOrdinal(((Byte)player.func_184212_Q().func_187225_a(dwMegaItem)).byteValue());
    }

    public static void updatePlayerMegaItemsUnlocked(ServerPlayerEntity player, EnumMegaItemsUnlocked megaItemsUnlocked) {
        player.func_184212_Q().func_187227_b(dwMegaItemsUnlocked, (Object)((byte)megaItemsUnlocked.ordinal()));
    }

    public static EnumMegaItemsUnlocked getPlayerMegaItemsUnlocked(PlayerEntity player) {
        return EnumMegaItemsUnlocked.fromOrdinal(((Byte)player.func_184212_Q().func_187225_a(dwMegaItemsUnlocked)).byteValue());
    }

    public static void updatePlayerShinyCharm(ServerPlayerEntity player, EnumFeatureState charm) {
        player.func_184212_Q().func_187227_b(dwShinyCharm, (Object)((byte)charm.ordinal()));
    }

    public static EnumFeatureState getPlayerShinyCharm(PlayerEntity player) {
        return EnumFeatureState.values()[(Byte)player.func_184212_Q().func_187225_a(dwShinyCharm)];
    }

    public static void updatePlayerOvalCharm(ServerPlayerEntity player, EnumFeatureState charm) {
        player.func_184212_Q().func_187227_b(dwOvalCharm, (Object)((byte)charm.ordinal()));
    }

    public static EnumFeatureState getPlayerOvalCharm(PlayerEntity player) {
        return EnumFeatureState.values()[(Byte)player.func_184212_Q().func_187225_a(dwOvalCharm)];
    }

    public static void updatePlayerHweenRobe(ServerPlayerEntity player, EnumFeatureState charm) {
        player.func_184212_Q().func_187227_b(dwHween, (Object)((byte)charm.ordinal()));
    }

    public static void updatePlayerExpCharm(ServerPlayerEntity player, EnumFeatureState charm) {
        player.func_184212_Q().func_187227_b(dwExpCharm, (Object)((byte)charm.ordinal()));
    }

    public static EnumFeatureState getPlayerExpCharm(PlayerEntity player) {
        return EnumFeatureState.values()[(Byte)player.func_184212_Q().func_187225_a(dwExpCharm)];
    }

    public static void updatePlayerCatchingCharm(ServerPlayerEntity player, EnumFeatureState charm) {
        player.func_184212_Q().func_187227_b(dwCatchingCharm, (Object)((byte)charm.ordinal()));
    }

    public static EnumFeatureState getPlayerCatchingCharm(PlayerEntity player) {
        return EnumFeatureState.values()[(Byte)player.func_184212_Q().func_187225_a(dwCatchingCharm)];
    }

    public static void updatePlayerMarkCharm(ServerPlayerEntity player, EnumFeatureState charm) {
        player.func_184212_Q().func_187227_b(dwMarkCharm, (Object)((byte)charm.ordinal()));
    }

    public static EnumFeatureState getPlayerMarkCharm(PlayerEntity player) {
        return EnumFeatureState.values()[(Byte)player.func_184212_Q().func_187225_a(dwMarkCharm)];
    }

    public static EnumFeatureState getPlayerHweenRobe(PlayerEntity player) {
        return EnumFeatureState.values()[(Byte)player.func_184212_Q().func_187225_a(dwHween)];
    }

    static {
        CommonHelper.disableLogMessage(EntityDataManager.class, ".*EntityPlayerExtension.*");
        dwPokeballs = EntityDataManager.func_187226_a(PlayerEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
        dwMegaItem = EntityDataManager.func_187226_a(PlayerEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
        dwMegaItemsUnlocked = EntityDataManager.func_187226_a(PlayerEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
        dwShinyCharm = EntityDataManager.func_187226_a(PlayerEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
        dwOvalCharm = EntityDataManager.func_187226_a(PlayerEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
        dwExpCharm = EntityDataManager.func_187226_a(PlayerEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
        dwCatchingCharm = EntityDataManager.func_187226_a(PlayerEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
        dwMarkCharm = EntityDataManager.func_187226_a(PlayerEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
        dwHween = EntityDataManager.func_187226_a(PlayerEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    }
}

