/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.SheerForce;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.StickyHold;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.SuctionCups;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.HeldItem;
import net.minecraft.item.Item;

public class RedCardItem
extends HeldItem {
    public RedCardItem() {
        super(EnumHeldItems.redCard, new Item.Properties());
    }

    @Override
    public void postProcessDamagingAttackTarget(PixelmonWrapper attacker, PixelmonWrapper target, Attack attack, float damage) {
        PixelmonWrapper randomPokemon;
        if (attacker.bc.simulateMode || attacker.getParticipant().getType() == ParticipantType.WildPokemon) {
            return;
        }
        if (attacker.isFainted() || target.isFainted()) {
            return;
        }
        if (attacker.getBattleAbility() instanceof SheerForce && attack.getMove().hasSecondaryEffect()) {
            return;
        }
        if (attack.isAttack(AttackRegistry.KNOCK_OFF) && !target.getBattleAbility().isAbility((Class<? extends AbstractAbility>)StickyHold.class)) {
            return;
        }
        if (damage > 0.0f && (randomPokemon = attacker.getParticipant().getRandomPartyPokemon()) != null) {
            target.consumeItem();
            attacker.bc.sendToAll("pixelmon.helditems.redcard", target.getNickname());
            if (attacker.getBattleAbility() instanceof SuctionCups) {
                attacker.getBattleAbility().stopsForcedSwitches(attacker, target);
            } else if (attacker.isDynamax > 0 || attacker.stopsForcedSwitches(target)) {
                attacker.bc.sendToAll("pixelmon.helditems.noeffect", new Object[0]);
            } else {
                attacker.bc.sendToAll("pixelmon.effect.flee", attacker.getNickname());
                attacker.forceRandomSwitch(randomPokemon.getPokemonUUID());
            }
        }
    }
}

