/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.armor;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.ArmorEffectEvent;
import com.pixelmonmod.pixelmon.items.armor.armoreffects.IArmorEffect;
import com.pixelmonmod.pixelmon.items.armor.armoreffects.IItemAttributeModifier;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.Event;

public class GenericArmor
extends ArmorItem {
    public IArmorEffect effect = null;
    public IItemAttributeModifier itemAttributeModifier = null;
    public final IArmorMaterial field_200882_e;

    public GenericArmor(IArmorMaterial material, EquipmentSlotType armorType) {
        super(material, armorType, new Item.Properties().func_200916_a(ItemGroup.field_78037_j));
        this.field_200882_e = material;
    }

    public GenericArmor setEffect(IArmorEffect effect) {
        this.effect = effect;
        return this;
    }

    public GenericArmor setItemAttributeModifiers(IItemAttributeModifier modifier) {
        this.itemAttributeModifier = modifier;
        return this;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        ArmorEffectEvent.Attribute event = new ArmorEffectEvent.Attribute(this, null, null, stack, this.effect, this.itemAttributeModifier);
        Multimap superMap = super.getAttributeModifiers(slot, stack);
        ListMultimap build = MultimapBuilder.hashKeys().linkedListValues().build();
        build.putAll(superMap);
        if (!Pixelmon.EVENT_BUS.post((Event)event) && event.getAttributeModifier() != null && slot == EquipmentSlotType.FEET) {
            for (Map.Entry entry : event.getAttributeModifier().getAttributeModifiers(stack, this).entries()) {
                build.put(entry.getKey(), entry.getValue());
            }
        }
        return build;
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        ArmorEffectEvent.Effect event = new ArmorEffectEvent.Effect(this, world, player, stack, this.effect, this.itemAttributeModifier);
        if (!Pixelmon.EVENT_BUS.post((Event)event) && event.getArmorEffect() != null) {
            event.getArmorEffect().onArmorTick(world, player, stack, this);
        }
    }

    public String func_77658_a() {
        return super.func_77658_a();
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return "pixelmon:textures/models/armor/" + this.modifyArmorName(stack.func_77973_b().toString()) + "_layer_" + (slot == EquipmentSlotType.LEGS ? 2 : 1) + ".png";
    }

    private String modifyArmorName(String itemName) {
        return itemName.substring(0, itemName.lastIndexOf("_")).toLowerCase();
    }
}

