/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.Palette;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.registries.PixelmonPalettes;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.items.IEquippable;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SpriteItem
extends PixelmonItem
implements IEquippable {
    public SpriteItem() {
        super(new Item.Properties().func_200916_a(null).func_200917_a(1));
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return super.func_200295_i(stack);
        }
        CompoundNBT tag = stack.func_77978_p();
        if (tag.func_74764_b("Nickname")) {
            return new StringTextComponent(tag.func_74779_i("Nickname") + " " + this.getLocalizedName());
        }
        if (tag.func_74767_n("isEgg") || tag.func_74762_e("eggCycles") > 0) {
            return new TranslationTextComponent("pixelmon.egg");
        }
        if (tag.func_74764_b("ndex")) {
            Species species = PixelmonSpecies.fromNationalDex(Integer.valueOf(tag.func_74765_d("ndex")));
            if (species == null) {
                return super.func_200295_i(stack);
            }
            Stats form = species.getForm(tag.func_74779_i("form"));
            Palette palette = PixelmonPalettes.fromName(tag.func_74779_i("palette"));
            PaletteProperties paletteProperties = this.getPalettePropertiesFromName(form, palette.getName());
            if (form == null || paletteProperties == null) {
                return super.func_200295_i(stack);
            }
            String name = species.getLocalizedName();
            if (form.isForm("mega", "megax", "megay", "primal", "alolan", "galarian") && !form.isDefault()) {
                name = form.getLocalizedName() + " " + name;
            }
            if (!paletteProperties.getName().equalsIgnoreCase("none")) {
                name = paletteProperties.getLocalizedName() + " " + name;
            }
            return new TranslationTextComponent("item.pixelmon.pixelmon_sprite", new Object[]{name});
        }
        return super.func_200295_i(stack);
    }

    @Override
    public EquipmentSlotType getEquipmentSlot(ItemStack stack) {
        return EquipmentSlotType.HEAD;
    }

    public PaletteProperties getPalettePropertiesFromName(Stats form, String name) {
        for (Gender gender : form.getPossibleGenders()) {
            for (PaletteProperties paletteProperties : form.getGenderProperties(gender).getPalettes()) {
                if (!paletteProperties.getName().equals(name)) continue;
                return paletteProperties;
            }
        }
        return null;
    }

    public boolean canEquip(ItemStack stack, EquipmentSlotType armorType, Entity entity) {
        return armorType == EquipmentSlotType.HEAD && stack.func_77942_o() && !stack.func_77978_p().func_74767_n("Unequippable");
    }

    @Override
    public String getEquippableModelKey() {
        return "pixelmon_sprite";
    }

    @Override
    public ResourceLocation getEquippableTexture() {
        return null;
    }

    @Override
    public Item getEquippableItem() {
        return this;
    }
}

