/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;

public class PixelmonBootsItem
extends ArmorItem {
    private static final UUID RUNNING_SHOES_UUID = UUID.fromString("B7060ADF-8FAF-4C0F-B816-87CB5721979F");
    private static final AttributeModifier OLD_RUNNING_SHOES_MODIFIER = new AttributeModifier(RUNNING_SHOES_UUID, Attributes.field_233821_d_.func_233754_c_(), 0.5, AttributeModifier.Operation.func_220372_a((int)1));
    private static final AttributeModifier NEW_RUNNING_SHOES_MODIFIER = new AttributeModifier(RUNNING_SHOES_UUID, Attributes.field_233821_d_.func_233754_c_(), 0.75, AttributeModifier.Operation.func_220372_a((int)1));

    public PixelmonBootsItem(IArmorMaterial materialIn, EquipmentSlotType slot) {
        super(materialIn, slot, new Item.Properties().func_200916_a(ItemGroup.field_78037_j).func_200918_c(1000));
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType slot) {
        if (slot != EquipmentSlotType.FEET) {
            return ImmutableMultimap.of();
        }
        HashMultimap o = HashMultimap.create();
        if (slot == EquipmentSlotType.FEET) {
            AttributeModifier modifier = this == PixelmonItems.old_running_boots ? OLD_RUNNING_SHOES_MODIFIER : NEW_RUNNING_SHOES_MODIFIER;
            o.put((Object)Attributes.field_233821_d_, (Object)modifier);
        }
        return o;
    }

    public void onArmorTick(ItemStack itemStack, World world, PlayerEntity player) {
        if (!world.field_72995_K && itemStack != null && player.func_184582_a(EquipmentSlotType.FEET) == itemStack) {
            Item item = itemStack.func_77973_b();
            if (item == PixelmonItems.new_running_boots) {
                if (!itemStack.func_77984_f()) {
                    if (itemStack.func_77951_h()) {
                        itemStack.func_196085_b(0);
                    }
                    return;
                }
                if (player.func_184812_l_() || player.func_175149_v() || player.func_184187_bx() != null || player.func_184613_cA()) {
                    return;
                }
                int maxDamage = PixelmonItems.new_running_boots.getMaxDamage(itemStack);
                if (itemStack.func_77952_i() >= maxDamage) {
                    player.func_184201_a(EquipmentSlotType.FEET, new ItemStack((IItemProvider)PixelmonItems.old_running_boots));
                } else {
                    double currentX = player.func_226277_ct_();
                    double currentZ = player.func_226281_cx_();
                    CompoundNBT compound = itemStack.func_190925_c("pos");
                    if (!compound.func_74764_b("x")) {
                        compound.func_74780_a("x", currentX);
                        compound.func_74780_a("z", currentZ);
                        return;
                    }
                    double bootLastX = compound.func_74769_h("x");
                    double bootLastZ = compound.func_74769_h("z");
                    double changeX = Math.abs(bootLastX - currentX);
                    double changeZ = Math.abs(bootLastZ - currentZ);
                    if (changeX >= 2.0 || changeZ >= 2.0) {
                        itemStack.func_196085_b(itemStack.func_77952_i() + 1);
                        compound.func_74780_a("x", currentX);
                        compound.func_74780_a("z", currentZ);
                    }
                }
            } else if (item == PixelmonItems.old_running_boots && itemStack.func_77951_h()) {
                itemStack.func_196085_b(0);
            }
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        if (stack.func_77973_b() == PixelmonItems.new_running_boots) {
            return "pixelmon:textures/models/armor/running_1.png";
        }
        return "pixelmon:textures/models/armor/oldrunning_1.png";
    }
}

