/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.blocks.enums.EnumPokechestVisibility;
import com.pixelmonmod.pixelmon.blocks.tileentity.PokeChestTileEntity;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import com.pixelmonmod.pixelmon.items.group.PixelmonItemGroups;
import javax.annotation.Nullable;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemFinderItem
extends PixelmonItem {
    private static final double RADIUS = 35.0;

    public ItemFinderItem() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(PixelmonItemGroups.TAB_POKE_LOOT));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        player.func_184811_cZ().func_185145_a((Item)this, 20);
        if (!world.field_72995_K) {
            PokeChestTileEntity chest = BlockHelper.findClosestTileEntity(PokeChestTileEntity.class, (Entity)player, 35.0, p -> p.getVisibility() == EnumPokechestVisibility.Hidden);
            if (chest != null) {
                Direction direction = this.getDirection(player, chest.func_174877_v());
                if (direction == Direction.NORTH) {
                    itemStack.func_196082_o().func_74768_a("Direction", 1);
                } else if (direction == Direction.SOUTH) {
                    itemStack.func_196082_o().func_74768_a("Direction", 2);
                } else if (direction == Direction.EAST) {
                    itemStack.func_196082_o().func_74768_a("Direction", 3);
                } else {
                    itemStack.func_196082_o().func_74768_a("Direction", 4);
                }
                world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_(), SoundEvents.field_187750_dc, SoundCategory.PLAYERS, 0.5f, 1.0f);
            } else {
                itemStack.func_196082_o().func_74768_a("Direction", 0);
            }
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemStack);
    }

    private Direction getDirection(PlayerEntity player, BlockPos pos) {
        int x = (int)(player.func_226277_ct_() - (double)pos.func_177958_n());
        int z = (int)(player.func_226281_cx_() - (double)pos.func_177952_p());
        Direction direction = Math.abs(x) > Math.abs(z) ? (x > 0 ? Direction.WEST : Direction.EAST) : (z > 0 ? Direction.NORTH : Direction.SOUTH);
        Direction facing = player.func_174811_aO();
        if (facing == direction) {
            return Direction.NORTH;
        }
        if (facing.func_176734_d() == direction) {
            return Direction.SOUTH;
        }
        if (facing.func_176746_e() == direction) {
            return Direction.EAST;
        }
        return Direction.WEST;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class PropertyGetter
    implements IItemPropertyGetter {
        public static final PropertyGetter INSTANCE = new PropertyGetter();

        public float call(ItemStack stack, @Nullable ClientWorld worldIn, @Nullable LivingEntity entityIn) {
            return stack.func_77942_o() ? (float)MathHelper.func_76125_a((int)stack.func_77978_p().func_74762_e("Direction"), (int)0, (int)4) : 0.0f;
        }
    }
}

