/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.init.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.raids.RegisterRaidEvent;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraftforge.eventbus.api.Event;

public class RaidRegistry {
    private static final List<RaidCollection> ALL_RAIDS = new ArrayList<RaidCollection>();
    private static final Map<String, RaidBiomeGrouping> BIOME_TO_RAIDS = new HashMap<String, RaidBiomeGrouping>();

    private RaidRegistry() {
        throw new IllegalStateException("Cannot instantiate this class");
    }

    public static List<RaidCollection> getAllRaids() {
        return ALL_RAIDS;
    }

    public static Map<String, RaidBiomeGrouping> getBiomeToRaids() {
        return BIOME_TO_RAIDS;
    }

    public static List<Integer> getBiomeStarWeights(String biome) {
        RaidBiomeGrouping grouping = BIOME_TO_RAIDS.getOrDefault(biome, null);
        if (grouping == null) {
            return PixelmonConfigProxy.getRaids().getDenStarWeights();
        }
        return grouping.getWeights();
    }

    public static void registerRaidSpawns(JsonObject json) {
        for (Map.Entry entry : json.entrySet()) {
            if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
            JsonObject inner = (JsonObject)entry.getValue();
            JsonArray biomes = inner.getAsJsonArray("biomes");
            JsonArray species = inner.getAsJsonArray("species");
            ArrayList<String> finalBiomes = new ArrayList<String>(biomes.size());
            for (JsonElement element : biomes) {
                finalBiomes.add(element.getAsString());
            }
            RaidStarGrouping grouping = new RaidStarGrouping();
            RegisterRaidEvent.Register event = new RegisterRaidEvent.Register(grouping);
            Pixelmon.EVENT_BUS.post((Event)event);
            if (!event.shouldUseDefaults()) continue;
            for (JsonElement element : species) {
                String str = element.getAsString();
                try {
                    String[] split = str.split("-");
                    String[] starStrs = split[0].split(",");
                    Species s = PixelmonSpecies.fromName(split[1]).getValueUnsafe();
                    if (s == null || !PixelmonConfigProxy.getRaids().isRaidHaveLegendaries() && s.getDefaultForm().getTags().isLegendary() || !PixelmonConfigProxy.getRaids().isRaidHaveLegendaries() && s.getDefaultForm().getTags().isUltraBeast() || PixelmonConfigProxy.getRaids().getRaidBlacklist().contains(s.getName()) || !PixelmonConfigProxy.getSpawning().isGenerationEnabled(s.getGeneration())) continue;
                    String form = "";
                    if (split.length > 2) {
                        form = split[2];
                    }
                    for (String starStr : starStrs) {
                        int star = Integer.parseInt(starStr);
                        RegisterRaidEvent.AddDefault e1 = new RegisterRaidEvent.AddDefault(grouping, star, new Raid(s.getDex(), form));
                        if (Pixelmon.EVENT_BUS.post((Event)e1)) continue;
                        grouping.addRaid(e1.getStars(), e1.getRaid());
                    }
                }
                catch (Exception e) {
                    Pixelmon.LOGGER.error("Failed to parse raid string: {}", (Object)str);
                }
            }
            ALL_RAIDS.add(new RaidCollection(finalBiomes, grouping));
        }
    }

    public static void remap() {
        BIOME_TO_RAIDS.clear();
        List<Integer> starWeights = PixelmonConfigProxy.getRaids().getDenStarWeights();
        for (RaidCollection collection : ALL_RAIDS) {
            for (String biome : collection.getBiomes()) {
                BIOME_TO_RAIDS.computeIfAbsent(biome, RaidBiomeGrouping::new);
                for (Map.Entry<Integer, List<Raid>> entry : collection.getRaids().getGroupings().entrySet()) {
                    BIOME_TO_RAIDS.get(biome).getRaids().addRaids(entry.getKey(), (Collection<Raid>)entry.getValue());
                }
                BIOME_TO_RAIDS.get(biome).setWeightsIfUnset(() -> {
                    ArrayList<Integer> weights = new ArrayList<Integer>(starWeights.size());
                    for (int i = 0; i < starWeights.size(); ++i) {
                        List<Raid> raids = i >= collection.getRaids().getGroupings().size() ? null : collection.getRaids().getGroup(i);
                        weights.add(raids == null || raids.isEmpty() ? 0 : (Integer)starWeights.get(i));
                    }
                    return weights;
                });
            }
        }
    }

    public static class Raid {
        private final int species;
        private final String form;

        public Raid(int species, String form) {
            this.species = species;
            this.form = form;
        }

        public int getSpecies() {
            return this.species;
        }

        public String getForm() {
            return this.form;
        }
    }

    public static class RaidStarGrouping {
        private final Map<Integer, List<Raid>> groupings = new HashMap<Integer, List<Raid>>(5);

        public RaidStarGrouping() {
            for (int i = 1; i <= 5; ++i) {
                this.groupings.put(i, new ArrayList());
            }
        }

        public Map<Integer, List<Raid>> getGroupings() {
            return this.groupings;
        }

        public List<Raid> getGroup(int stars) {
            return this.groupings.computeIfAbsent(stars, key -> new ArrayList());
        }

        public void addRaid(int stars, int species, String form) {
            this.addRaid(stars, new Raid(species, form));
        }

        public void addRaid(int stars, Raid raid) {
            this.getGroup(stars).add(raid);
        }

        public void addRaids(int stars, Collection<Raid> raids) {
            this.getGroup(stars).addAll(raids);
        }
    }

    public static class RaidBiomeGrouping {
        private final String biome;
        private final RaidStarGrouping raids;
        private final List<Integer> weights;

        public RaidBiomeGrouping(String biome) {
            this.biome = biome;
            this.raids = new RaidStarGrouping();
            this.weights = new ArrayList<Integer>();
        }

        public String getBiome() {
            return this.biome;
        }

        public RaidStarGrouping getRaids() {
            return this.raids;
        }

        public List<Integer> getWeights() {
            return this.weights;
        }

        public void setWeightsIfUnset(Supplier<List<Integer>> weights) {
            if (this.weights.isEmpty()) {
                this.weights.addAll((Collection<Integer>)weights.get());
            }
        }
    }

    public static class RaidCollection {
        private final List<String> biomes;
        private final RaidStarGrouping raids;

        public RaidCollection(List<String> biomes, RaidStarGrouping raids) {
            this.biomes = biomes;
            this.raids = raids;
        }

        public List<String> getBiomes() {
            return this.biomes;
        }

        public RaidStarGrouping getRaids() {
            return this.raids;
        }
    }
}

