/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.pixelmon.ai.FlyingPersistentGoal;
import com.pixelmonmod.pixelmon.ai.PixelmonMovementController;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.data.DataSync;
import com.pixelmonmod.pixelmon.api.pokemon.species.parameters.ControlledMovementLogic;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.util.helpers.EntityHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.client.models.animations.EnumRotation;
import com.pixelmonmod.pixelmon.comm.packetHandlers.UpdatePixelmonMovementPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractBattleEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.movement.PixelmonMovementBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.movement.PixelmonMovementFlying;
import com.pixelmonmod.pixelmon.entities.pixelmon.movement.PixelmonMovementGround;
import com.pixelmonmod.pixelmon.enums.EnumKeybinds;
import com.pixelmonmod.pixelmon.world.dimension.drowned.DrownedWorld;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;

public abstract class AbstractMovesEntity
extends AbstractBattleEntity {
    public static final float MAX_MOVE_MULTIPLIER = 1.4f;
    public static final float MIN_MOVE_MULTIPLIER = 0.3f;
    private static final String NBT_FLY_HEIGHT = "flyheight";
    private static final String NBT_IS_FLYING = "isFly";
    private static final String NBT_CAN_FLY = "canfly";
    public static final DataSync<AbstractMovesEntity, Boolean> SYNC_FLYING = new DataSync<AbstractMovesEntity, Boolean>(AbstractMovesEntity.class, DataSerializers.field_187198_h, (abstractMovesEntity, flying) -> {
        abstractMovesEntity.isFlying = flying;
    });
    public static final DataSync<AbstractMovesEntity, Boolean> SYNC_HOVERING = new DataSync<AbstractMovesEntity, Boolean>(AbstractMovesEntity.class, DataSerializers.field_187198_h, (abstractMovesEntity, hovering) -> {
        abstractMovesEntity.hovering = hovering;
    });
    private int baseFlyHeight = 30;
    private int baseSwimDepth = 5;
    private int flyHeight = -1;
    private int swimDepth = -1;
    private float fallRate = 0.04f;
    private float strafeUpDown = 0.0f;
    private float hoverRotationPitch = 20.0f;
    private float moveMultiplier = 0.3f;
    private float thermalPower = 0.0f;
    private boolean canFly = true;
    private boolean canFlyOverride = true;
    public float rotationRoll = 0.0f;
    public float prevRotationRoll = 0.0f;
    public float lastSpeed = -1.0f;
    public float lastStrafe = -1.0f;
    public float lastStrafeUp = -1.0f;
    private PixelmonMovementFlying movementFlying = new PixelmonMovementFlying(this);
    private PixelmonMovementGround movementGround = new PixelmonMovementGround(this);
    private boolean hovering = false;
    public int takeOffTicks = 0;
    public boolean lastFlyingState = false;
    Vector3d targetPosition;

    public AbstractMovesEntity(EntityType<? extends AbstractMovesEntity> type, World worldIn) {
        super((EntityType<? extends AbstractBattleEntity>)type, worldIn);
        this.field_70765_h = new PixelmonMovementController((MobEntity)this);
    }

    @Override
    protected void func_70088_a() {
        this.define(SYNC_FLYING, false);
        this.define(SYNC_HOVERING, false);
        super.func_70088_a();
    }

    public PixelmonMovementBase getMovement() {
        if (this.isFlying()) {
            return this.movementFlying;
        }
        return this.movementGround;
    }

    public void setFlying(boolean isFlying) {
        SYNC_FLYING.set((Entity)this, (Object)isFlying);
    }

    public boolean isFlying() {
        return this.isFlying;
    }

    public boolean isHovering() {
        return this.hovering;
    }

    public void toggleHover() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        boolean hovering = this.isHovering();
        if (this.isFlying() || hovering) {
            SYNC_HOVERING.set((Entity)this, (Object)(!hovering ? 1 : 0));
            this.calcMoveSpeed();
            NetworkHelper.sendToAllTracking(new UpdatePixelmonMovementPacket(this), (Entity)this);
        }
    }

    public void handleMovement(List<EnumKeybinds> movements) {
        this.getMovement().handleMovement(movements);
        if (!this.field_70170_p.field_72995_K) {
            NetworkHelper.sendToAllTracking(new UpdatePixelmonMovementPacket(this), (Entity)this);
        }
    }

    public void doJump() {
        this.func_70664_aZ();
    }

    protected float func_175134_bD() {
        return (float)Math.max(0.42, (double)(super.func_175134_bD() * this.func_213302_cg() / 2.0f));
    }

    public void takeOff() {
        if (this.isHovering()) {
            this.toggleHover();
        }
        this.field_70125_A = 20.0f;
        this.lastSpeed = -1.0f;
        this.lastStrafe = -1.0f;
        this.lastStrafeUp = -1.0f;
        this.strafeUpDown = 0.0f;
        this.takeOffTicks = 20;
        if (!this.field_70170_p.field_72995_K) {
            this.moveMultiplier = 0.2f;
            EntityHelper.setPosition((Entity)this, EnumRotation.y, this.func_226278_cu_() + 0.3);
            NetworkHelper.sendToAllTracking(new UpdatePixelmonMovementPacket(this), (Entity)this);
            this.setFlying(true);
        }
    }

    public boolean func_82171_bF() {
        return true;
    }

    @Override
    public boolean func_225503_b_(float distance, float damageMultiplier) {
        double moveForward;
        double speed;
        float[] ret = ForgeHooks.onLivingFall((LivingEntity)this, (float)distance, (float)damageMultiplier);
        if (ret == null) {
            return false;
        }
        double moveDown = Math.abs(this.func_213322_ci().field_72448_b) - 0.8;
        double d = speed = moveDown > (moveForward = (double)Math.abs(this.field_191988_bg) - 0.8) ? moveDown : moveForward;
        if (speed > 0.0) {
            this.func_184185_a(this.func_184588_d((int)speed * 6), 1.0f, 1.0f);
            this.func_70097_a(DamageSource.field_76379_h, (float)speed * 6.0f);
            int j = MathHelper.func_76128_c((double)this.func_226277_ct_());
            int k = MathHelper.func_76128_c((double)(this.func_226278_cu_() - (double)0.2f));
            int l = MathHelper.func_76128_c((double)this.func_226281_cx_());
            BlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos(j, k, l));
            if (iblockstate.func_185904_a() != Material.field_151579_a) {
                SoundType soundtype = iblockstate.func_177230_c().getSoundType(iblockstate, (IWorldReader)this.field_70170_p, new BlockPos(j, k, l), (Entity)this);
                this.func_184185_a(soundtype.func_185842_g(), soundtype.func_185843_a() * 0.5f, soundtype.func_185847_b() * 0.75f);
            }
        }
        return true;
    }

    public void calcMoveSpeed() {
        ControlledMovementLogic mountedFlyingParameters = this.getPokemon().getForm().getMovement().getMountedFlyingParameters();
        if (mountedFlyingParameters != null) {
            mountedFlyingParameters.calcMoveSpeed(this);
        }
    }

    public void setMovementTarget(Vector3d targetPosition) {
        this.targetPosition = targetPosition;
    }

    public Vector3d getTargetPosition() {
        return this.targetPosition;
    }

    @Override
    public void func_70030_z() {
        if (!this.isFlying() && this.hasOwner()) {
            this.field_70125_A = 0.0f;
            this.rotationRoll = 0.0f;
            this.func_189654_d(false);
        }
        if (!(this.field_70170_p.field_72995_K || !PixelmonConfigProxy.getGeneral().isDisabledNonPlayerMovement() || this.pokemon.getStorageAndPosition() != null && this.pokemon.getStorage() != null && this.pokemon.getStorage() instanceof PlayerPartyStorage)) {
            return;
        }
        super.func_70030_z();
    }

    public void onLanding() {
    }

    public float getFlyingDirection() {
        return this.func_184179_bs().field_70177_z;
    }

    private float getRideSpeed() {
        return 0.07f + 0.05f * (float)this.pokemon.getStat(BattleStatsType.SPEED) / 500.0f;
    }

    protected void func_184225_p(Entity passenger) {
        super.func_184225_p(passenger);
        this.resetAI();
        this.lastSpeed = -1.0f;
        this.setFlying(false);
        this.field_70125_A = 0.0f;
        this.rotationRoll = 0.0f;
    }

    public int getFlyHeight() {
        if (this.flyHeight == -1) {
            this.flyHeight = RandomHelper.getRandomNumberBetween(this.getFlyingParameters().getFlyHeightMin(), this.getFlyingParameters().getFlyHeightMax());
        }
        return this.flyHeight;
    }

    public void setFlyHeight(int flyHeight) {
        this.flyHeight = flyHeight;
    }

    public int getSwimDepth() {
        if (this.swimDepth == -1) {
            this.swimDepth = this.field_70170_p.func_234923_W_() == DrownedWorld.WORLD ? RandomHelper.getRandomNumberBetween(10, 235) : (this.getSwimmingParameters() == null ? RandomHelper.getRandomNumberBetween(1, 10) : RandomHelper.getRandomNumberBetween(this.getSwimmingParameters().getDepthRangeStart(), this.getSwimmingParameters().getDepthRangeEnd()));
        }
        return this.swimDepth;
    }

    public void setSwimDepth(int swimDepth) {
        this.swimDepth = swimDepth;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        compound.func_74768_a(NBT_FLY_HEIGHT, this.getFlyHeight());
        compound.func_74757_a(NBT_CAN_FLY, this.canFly);
        compound.func_74757_a(NBT_IS_FLYING, this.isFlying());
        return compound;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.flyHeight = nbt.func_74762_e(NBT_FLY_HEIGHT);
        this.canFly = nbt.func_74767_n(NBT_CAN_FLY);
        this.setFlying(nbt.func_74767_n(NBT_IS_FLYING));
        super.deserializeNBT(nbt);
    }

    public boolean func_145770_h(double p_145770_1_, double p_145770_3_, double p_145770_5_) {
        if (this.isFlying()) {
            double d3 = this.func_226277_ct_() - p_145770_1_;
            double d5 = this.func_226281_cx_() - p_145770_5_;
            double d6 = d3 * d3 + d5 * d5;
            return this.func_70112_a(d6);
        }
        double d3 = this.func_226277_ct_() - p_145770_1_;
        double d4 = this.func_226278_cu_() - p_145770_3_;
        double d5 = this.func_226281_cx_() - p_145770_5_;
        double d6 = d3 * d3 + d4 * d4 + d5 * d5;
        return this.func_70112_a(d6);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b();
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 1200.0 * 1.0) * d0;
    }

    public void setCanFly(boolean canFly) {
        this.canFly = canFly;
    }

    public boolean getCanFly() {
        return this.getForm().getMovement().getMountedFlyingParameters() != null;
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (this.getForm() == null || this.getForm().getMovement() == null || this.getForm().getMovement().getRidingOffsets() == null) {
            return;
        }
        Vector3f offsets = this.getForm().getMovement().getRidingOffsets().standing != null ? this.getForm().getMovement().getRidingOffsets().standing : new Vector3f();
        if (this.getForm().getMovement().getRidingOffsets().moving != null && (this.flyingDelayCounter >= flyingDelayLimit || this.getUsingRidingSpecialConditions())) {
            offsets = this.getForm().getMovement().getRidingOffsets().moving;
        }
        if (this.func_184196_w(passenger) && this.isFlying()) {
            this.getMovement().updatePassenger(passenger, offsets);
        } else {
            Vector3d vec = new Vector3d((double)(offsets.func_195899_a() * this.getPixelmonScale() * this.getScaleFactor()), (double)((offsets.func_195900_b() + this.func_213302_cg()) * this.getPixelmonScale() * this.getScaleFactor()), (double)(offsets.func_195902_c() * this.getPixelmonScale() * this.getScaleFactor()));
            vec = vec.func_178785_b(-1.0f * this.field_70761_aq * (float)Math.PI / 180.0f);
            passenger.func_70107_b(this.func_226277_ct_() + vec.field_72450_a, this.func_226278_cu_() + vec.field_72448_b, this.func_226281_cx_() + vec.field_72449_c);
        }
    }

    public boolean getStaysHorizontalInRender() {
        ControlledMovementLogic mountedFlyingParameters = this.getPokemon().getForm().getMovement().getMountedFlyingParameters();
        if (mountedFlyingParameters == null) {
            return false;
        }
        return mountedFlyingParameters.getStaysHorizontalInRender(this);
    }

    public float getMoveMultiplier() {
        return this.moveMultiplier;
    }

    public void setMoveMultiplier(float moveMultiplier) {
        this.moveMultiplier = moveMultiplier;
    }

    public float getStrafeUpDown() {
        return this.strafeUpDown;
    }

    public void setStrafeUpDown(float strafeUpDown) {
        this.strafeUpDown = strafeUpDown;
    }

    public void setThermalPower(float thermalPower) {
        this.thermalPower = thermalPower;
    }

    public float getThermalPower() {
        return this.thermalPower;
    }

    public float getHoverRotationPitch() {
        return this.hoverRotationPitch;
    }

    public void setHoverRotationPitch(float hoverRotationPitch) {
        this.hoverRotationPitch = hoverRotationPitch;
    }

    public float getFallRate() {
        return this.fallRate;
    }

    public void setPixelmonToFlyForBattle() {
        if (this.canFly() && this.field_70170_p.func_180495_p(new BlockPos(this.func_213303_ch().func_72441_c(0.0, -4.0, 0.0))).func_203425_a(Blocks.field_150350_a) && this instanceof PixelmonEntity) {
            this.field_70714_bg.func_75776_a(0, (Goal)new FlyingPersistentGoal((PixelmonEntity)this));
        }
    }
}

