/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.CommandHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.PlayerHelper;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class PokeSeeCommand
extends PixelCommand {
    public PokeSeeCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "pokesee", "/pokesee [player]", 2);
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException, CommandSyntaxException {
        args = this.setupTargetOrSourceAsTarget(sender, args, 0);
        PlayerPartyStorage storage = PixelmonCommandUtils.require(StorageProxy.getParty(this.findUuid(sender, args[0])), "pixelmon.command.general.invalidplayer", new Object[0]);
        Pokemon[] party = storage.getAll();
        sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.AQUA, "pixelmon.command.pokesee.header", args[0]), false);
        for (Pokemon pokemon : party) {
            if (pokemon == null) {
                sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.GREEN, "pixelmon.command.pokesee.empty", new Object[0]), false);
                continue;
            }
            if (pokemon.isEgg()) {
                sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.GREEN, "pixelmon.command.pokesee.egg", new Object[0]), false);
                continue;
            }
            sender.func_197030_a(CommandHelper.getHoverTextPokemon(pokemon, new int[0]), false);
        }
    }

    private UUID findUuid(CommandSource sender, String username) throws CommandSyntaxException {
        if (PixelmonConfigProxy.getCommands().isPokeseeAllowOfflineCheck()) {
            GameProfile profile = PixelmonCommandUtils.require(PixelmonCommandUtils.findProfile(username), "pixelmon.command.general.invalidplayer", new Object[0]);
            return profile.getId();
        }
        ServerPlayerEntity player = PixelmonCommandUtils.requireEntityPlayer(username);
        if (PlayerHelper.hasPermission(player, "pixelmon.pokesee.exempt") && !PlayerHelper.hasPermission(sender.func_197035_h(), "pixelmon.pokesee.exempt")) {
            throw PixelmonCommandUtils.getException("pixelmon.command.pokesee.exempt", username);
        }
        return player.func_110124_au();
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1 && this.hasPermissionOtherTarget(sender)) {
            return PixelmonCommandUtils.tabCompleteUsernames();
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

