/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.daycare.event.DayCareEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.egg.BreedingLogicProxy;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.eventbus.api.Event;

public class BreedCommand
extends PixelCommand {
    public BreedCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "breed", "/breed [player] <party slot #1> <party slot #2>", 2);
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException, CommandSyntaxException {
        if ((args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 0)).length < 3) {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        ServerPlayerEntity player = PixelmonCommandUtils.requireEntityPlayer(args[0]);
        PlayerPartyStorage storage = PixelmonCommandUtils.require(PixelmonCommandUtils.getPlayerStorage(player), "pixelmon.command.general.invalidplayer", new Object[0]);
        int slot1 = PixelmonCommandUtils.requireInt(args[1], 1, 6, "pixelmon.command.invalidslot", args[1]);
        int slot2 = PixelmonCommandUtils.requireInt(args[2], 1, 6, "pixelmon.command.invalidslot", args[2]);
        Pokemon pokemon1 = PixelmonCommandUtils.require(storage.get(slot1 - 1), "pixelmon.command.breed.nullslot", slot1);
        Pokemon pokemon2 = PixelmonCommandUtils.require(storage.get(slot2 - 1), "pixelmon.command.breed.nullslot", slot2);
        if (pokemon1.isEgg()) {
            PixelmonCommandUtils.endCommand("pixelmon.command.breed.egg", pokemon2.getLocalizedName());
        }
        if (pokemon2.isEgg()) {
            PixelmonCommandUtils.endCommand("pixelmon.command.breed.egg", pokemon1.getLocalizedName());
        }
        if (pokemon1 == pokemon2) {
            PixelmonCommandUtils.endCommand("pixelmon.command.breed.same", pokemon1.getLocalizedName());
        }
        if (!BreedingLogicProxy.canBreed(pokemon1, pokemon2)) {
            PixelmonCommandUtils.endCommand("pixelmon.command.breed.notcompatible", pokemon1.getLocalizedName(), pokemon2.getLocalizedName());
        }
        if (pokemon1.hasFlag("unbreedable")) {
            PixelmonCommandUtils.endCommand("pixelmon.ranch.cannotbreed", pokemon1.getLocalizedName());
        } else if (pokemon2.hasFlag("unbreedable")) {
            PixelmonCommandUtils.endCommand("pixelmon.ranch.cannotbreed", pokemon2.getLocalizedName());
        }
        Pokemon egg = BreedingLogicProxy.makeEgg(pokemon1, pokemon2).orElse(null);
        DayCareEvent.PrePokemonAdd event = new DayCareEvent.PrePokemonAdd(player, storage, pokemon1, pokemon2, egg);
        if (Pixelmon.EVENT_BUS.post((Event)event)) {
            return;
        }
        Pixelmon.EVENT_BUS.post((Event)new DayCareEvent.PostPokemonAdd(player, storage, event.getParentOne(), event.getParentTwo(), event.getChildCreated()));
        DayCareEvent.PreCollect preEvent = new DayCareEvent.PreCollect(player, storage, event.getParentOne(), event.getParentTwo(), event.getChildCreated());
        if (Pixelmon.EVENT_BUS.post((Event)preEvent)) {
            return;
        }
        PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.breed.giveegg", pokemon1.getLocalizedName(), pokemon2.getLocalizedName());
        storage.add(preEvent.getChildGiven());
        Pixelmon.EVENT_BUS.post((Event)new DayCareEvent.PostCollect(player, storage, preEvent.getParentOne(), preEvent.getParentTwo(), preEvent.getChildGiven(), preEvent.shouldAddToHistory()));
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (this.hasPermissionOtherTarget(sender)) {
            if (args.length == 1) {
                return PixelmonCommandUtils.tabCompleteUsernames();
            }
            if (args.length <= 3) {
                return PixelmonCommandUtils.PARTY_SLOTS;
            }
        } else if (args.length <= 2) {
            return PixelmonCommandUtils.PARTY_SLOTS;
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

