/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor;

import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.items.PokemonEditorItem;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class RandomizePokemonPacket
extends AbstractPixelmonPacket {
    private UUID playerID;

    public RandomizePokemonPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public RandomizePokemonPacket(UUID playerUUID) {
        super(PacketDirection.PLAY_SERVER, true);
        this.playerID = playerUUID;
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_179252_a(this.playerID);
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.playerID = buf.func_179253_g();
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        if (!PokemonEditorItem.checkPermission(context.getSender())) {
            return;
        }
        PlayerPartyStorage party = StorageProxy.getParty(this.playerID);
        for (int i = 0; i < 6; ++i) {
            party.set(i, PokemonFactory.create(PixelmonSpecies.getRandomSpecies()));
        }
        PokemonEditorItem.updateEditedPlayer(context.getSender(), this.playerID);
    }
}

