/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SwapPositionPacket
extends AbstractPixelmonPacket {
    private UUID user;
    private UUID target;

    public SwapPositionPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public SwapPositionPacket(PixelmonWrapper user, PixelmonWrapper target) {
        super(PacketDirection.PLAY_CLIENT);
        this.user = user.getPokemonUUID();
        this.target = target.getPokemonUUID();
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.user = buf.func_179253_g();
        this.target = buf.func_179253_g();
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_179252_a(this.user);
        buf.func_179252_a(this.target);
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        PixelmonClientData userPokemon = null;
        PixelmonClientData targetPokemon = null;
        for (PixelmonClientData pokemon : ClientProxy.battleManager.displayedOurPokemon) {
            if (this.user.equals(pokemon.pokemonUUID)) {
                userPokemon = pokemon;
                continue;
            }
            if (!this.target.equals(pokemon.pokemonUUID)) continue;
            targetPokemon = pokemon;
        }
        for (PixelmonClientData pokemon : ClientProxy.battleManager.displayedEnemyPokemon) {
            if (this.user.equals(pokemon.pokemonUUID)) {
                userPokemon = pokemon;
                continue;
            }
            if (!this.target.equals(pokemon.pokemonUUID)) continue;
            targetPokemon = pokemon;
        }
        if (userPokemon != null && targetPokemon != null) {
            int userPosition = userPokemon.position;
            userPokemon.position = targetPokemon.position;
            targetPokemon.position = userPosition;
        }
    }
}

