/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ParticipantReadyPacket
extends AbstractPixelmonPacket {
    private UUID uuid;
    private int battleIndex;

    public ParticipantReadyPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public ParticipantReadyPacket(int battleControllerIndex, UUID uuid) {
        super(PacketDirection.PLAY_SERVER, true);
        this.uuid = uuid;
        this.battleIndex = battleControllerIndex;
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.battleIndex = buf.readInt();
        this.uuid = buf.func_179253_g();
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.battleIndex);
        buf.func_179252_a(this.uuid);
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        context.getSender().func_143004_u();
        BattleController bc = BattleRegistry.getBattle(this.battleIndex);
        if (bc == null) {
            return;
        }
        for (BattleParticipant participant : bc.participants) {
            if (!(participant instanceof PlayerParticipant) || !Objects.equals(((PlayerParticipant)participant).player.func_110124_au(), this.uuid)) continue;
            bc.participantReady((PlayerParticipant)participant);
        }
    }
}

