/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.ZygardeCellBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.ZygardeCellTileEntity;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.tileEntities.TileEntityRenderer;
import com.pixelmonmod.pixelmon.listener.ZygardeCellsListener;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class RenderTileEntityZygardeCell
extends TileEntityRenderer<ZygardeCellTileEntity> {
    private static final GenericModelHolder<GenericSmdModel> MODEL = new GenericModelHolder("blocks/cell/cell.pqc");
    private static final GenericModelHolder<GenericSmdModel> CORE = new GenericModelHolder("blocks/cell/core.pqc");
    private static final ResourceLocation ZYGARDE_CELL = ResourceLocationHelper.of("pixelmon", "textures/block/cell/zygarde_cell.png");
    private static final ResourceLocation ZYGARDE_CORE = ResourceLocationHelper.of("pixelmon", "textures/block/cell/zygarde_core.png");
    private static boolean clientHasCube = false;
    private static long clientLastCheck = 0L;

    public RenderTileEntityZygardeCell(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    public void render(ZygardeCellTileEntity te, BlockState state, double x, double y, double z, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (!(player.func_175149_v() || player.func_184812_l_() || RenderTileEntityZygardeCell.clientHasCube())) {
            return;
        }
        if (!(state.func_177230_c() instanceof ZygardeCellBlock)) {
            return;
        }
        ResourceLocation texture = null;
        texture = state.func_177230_c() == PixelmonBlocks.zygarde_cell.getBlock() ? ZYGARDE_CELL : ZYGARDE_CORE;
        ((GenericSmdModel)((Object)RenderTileEntityZygardeCell.CORE.getModel())).modelRenderer.setTransparent(0.8f);
        ((GenericSmdModel)((Object)RenderTileEntityZygardeCell.MODEL.getModel())).modelRenderer.setTransparent(0.8f);
        Direction orientation = (Direction)state.func_177229_b((Property)ZygardeCellBlock.ORIENTATION_PROPERTY);
        if (orientation.func_176740_k() != Direction.Axis.Y) {
            Direction rotation = (Direction)state.func_177229_b((Property)ZygardeCellBlock.ROTATION_PROPERTY);
            matrix.func_227861_a_(0.0, -0.5, 0.0);
            matrix.func_227863_a_(QuaternionHelper.fromEuler(270.0f, rotation == Direction.UP ? 1.0f : -1.0f, 0.0f, 0.0f));
            if (rotation == Direction.DOWN) {
                matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
            }
            matrix.func_227861_a_(0.0, 0.5, 0.0);
        } else if (orientation == Direction.UP) {
            matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 1.0f, 0.0f, 0.0f));
            matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 0.0f, 1.0f, 0.0f));
            matrix.func_227861_a_(0.0, 1.0, 0.0);
        }
        float scale = 0.03f;
        matrix.func_227862_a_(scale, scale, scale);
        this.renderSMD(matrix, buffer, (Model)MODEL.getModel(), texture, combinedLight, combinedOverlay);
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.0, -5.0, 0.0);
        this.renderSMD(matrix, buffer, (Model)CORE.getModel(), texture, combinedLight, combinedOverlay);
        matrix.func_227865_b_();
    }

    @Override
    protected int getRotation(BlockState state) {
        if (this.hasProperty(state, (Property<?>)ZygardeCellBlock.ORIENTATION_PROPERTY) && this.hasProperty(state, (Property<?>)ZygardeCellBlock.ROTATION_PROPERTY)) {
            Direction orientation = (Direction)state.func_177229_b((Property)ZygardeCellBlock.ORIENTATION_PROPERTY);
            Direction rotation = (Direction)state.func_177229_b((Property)ZygardeCellBlock.ROTATION_PROPERTY);
            if (orientation.func_176740_k() == Direction.Axis.Y) {
                if (rotation == Direction.EAST) {
                    return 270;
                }
                if (rotation == Direction.NORTH) {
                    return 0;
                }
                if (rotation == Direction.WEST) {
                    return 90;
                }
                if (rotation == Direction.SOUTH) {
                    return 180;
                }
            } else {
                if (orientation == Direction.EAST) {
                    return 270;
                }
                if (orientation == Direction.NORTH) {
                    return 0;
                }
                if (orientation == Direction.WEST) {
                    return 90;
                }
                if (orientation == Direction.SOUTH) {
                    return 180;
                }
            }
        }
        return 0;
    }

    private static boolean clientHasCube() {
        long time = System.currentTimeMillis();
        if (clientLastCheck < time - 1000L) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            clientHasCube = ZygardeCellsListener.checkForCube((PlayerEntity)player);
            clientLastCheck = time;
        }
        return clientHasCube;
    }
}

