/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.models.ModelHolder;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasData;
import com.pixelmonmod.pixelmon.storage.extras.PlayerExtraDataStore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class PixelmonLayerHead
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    private final ResourceLocation TOP_HAT_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/tophat.png");
    private final ResourceLocation FEZ_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/fez.png");
    private final ResourceLocation FEDORA_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/fedora.png");
    private final ResourceLocation TRAINERHAT_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/trainerhat.png");
    private final ResourceLocation PIKAHOOD_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/pikahood.png");
    private final ResourceLocation EEVEEHOOD_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/eeveehood.png");
    private final ResourceLocation SCORHOOD_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/scorhood.png");
    private final ResourceLocation ESPEON_SCARF_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/espeon_scarf.png");
    private final ResourceLocation FLAREON_SCARF_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/flareon_scarf.png");
    private final ResourceLocation GLACEON_SCARF_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/glaceon_scarf.png");
    private final ResourceLocation JOLTEON_SCARF_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/jolteon_scarf.png");
    private final ResourceLocation LEAFEON_SCARF_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/leafeon_scarf.png");
    private final ResourceLocation SYLVEON_SCARF_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/sylveon_scarf.png");
    private final ResourceLocation UMBREON_SCARF_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/umbreon_scarf.png");
    private final ResourceLocation VAPOREON_SCARF_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/vaporeon_scarf.png");
    private final ResourceLocation WIKI_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/grad_cap.png");
    private final ResourceLocation GOLD_MONOCLE_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/monocle_gold.png");
    private final ResourceLocation BLACK_MONOCLE_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/monocle_black.png");
    private final ResourceLocation QUAGSIRE_MASK_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/quagsire_mask.png");
    private final ResourceLocation QUARANTINE_MASK_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/quarantine_mask.png");
    private final ResourceLocation WELKIN_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/welkin.png");
    private final ResourceLocation SABLEYE_HOOD_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/sableye_hood.png");
    public static final ResourceLocation WITCH_HAT_MODEL = ResourceLocationHelper.of("pixelmon", "playeritems/hats/witch");
    private final ModelHolder<GenericSmdModel> TOPHAT_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/tophat.pqc");
    private final ModelHolder<GenericSmdModel> FEZ_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/fez.pqc");
    private final ModelHolder<GenericSmdModel> FEDORA_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/fedora.pqc");
    private final ModelHolder<GenericSmdModel> TRAINERHAT_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/trainerhat.pqc");
    private final ModelHolder<GenericSmdModel> PIKAHOOD_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/pikahood.pqc");
    private final ModelHolder<GenericSmdModel> ESPEON_SCARF = new GenericModelHolder<GenericSmdModel>("playeritems/hats/espeon_scarf.pqc");
    private final ModelHolder<GenericSmdModel> FLAREON_SCARF = new GenericModelHolder<GenericSmdModel>("playeritems/hats/flareon_scarf.pqc");
    private final ModelHolder<GenericSmdModel> GLACEON_SCARF = new GenericModelHolder<GenericSmdModel>("playeritems/hats/glaceon_scarf.pqc");
    private final ModelHolder<GenericSmdModel> JOLTEON_SCARF = new GenericModelHolder<GenericSmdModel>("playeritems/hats/jolteon_scarf.pqc");
    private final ModelHolder<GenericSmdModel> LEAFEON_SCARF = new GenericModelHolder<GenericSmdModel>("playeritems/hats/leafeon_scarf.pqc");
    private final ModelHolder<GenericSmdModel> SYLVEON_SCARF = new GenericModelHolder<GenericSmdModel>("playeritems/hats/sylveon_scarf.pqc");
    private final ModelHolder<GenericSmdModel> UMBREON_SCARF = new GenericModelHolder<GenericSmdModel>("playeritems/hats/umbreon_scarf.pqc");
    private final ModelHolder<GenericSmdModel> VAPOREON_SCARF = new GenericModelHolder<GenericSmdModel>("playeritems/hats/vaporeon_scarf.pqc");
    private final ModelHolder<GenericSmdModel> WIKI_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/grad_cap.pqc");
    private final ModelHolder<GenericSmdModel> MONOCLE_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/monocle.pqc");
    private final ModelHolder<GenericSmdModel> QUAGSIRE_MASK_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/quagsire_mask.pqc");
    private final ModelHolder<GenericSmdModel> QUARANTINE_MASK_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/quarantine_mask.pqc");
    private final ModelHolder<GenericSmdModel> WELKIN_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/welkin.pqc");
    private final ModelHolder<GenericSmdModel> SABLEYE_HOOD_HEAD_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/sableye_hood_head.pqc");
    private final ModelHolder<GenericSmdModel> SABLEYE_HOOD_BODY_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/sableye_hood_body.pqc");
    private final ResourceLocation SPHEAL_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/sphealhat.png");
    private final ResourceLocation SHINYSPHEAL_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/shinysphealhat.png");
    private final ResourceLocation SPHEAL_STITCHED_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/sphealhatstitches.png");
    private final ResourceLocation SHINYSPHEAL_STICHED_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/shinysphealhatstitches.png");
    private final ModelHolder<GenericSmdModel> SPHEALHAT_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/sphealhat.pqc");
    private ModelRenderer head;
    private final PlayerRenderer renderer;
    private ResourceLocation locationCapBG;
    private DynamicTexture capBG;
    private boolean init = false;

    public PixelmonLayerHead(PlayerRenderer renderer) {
        super((IEntityRenderer)renderer);
        this.renderer = renderer;
    }

    public void render(MatrixStack matrix, IRenderTypeBuffer buffer, int packedLight, AbstractClientPlayerEntity player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        PixelExtrasData extras;
        if (!this.init) {
            this.capBG = new DynamicTexture(1, 1, true);
            this.capBG.func_195414_e().func_195700_a(0, 0, -1);
            this.capBG.func_110564_a();
            this.locationCapBG = Minecraft.func_71410_x().func_110434_K().func_110578_a("capbg", this.capBG);
            this.init = true;
        }
        if (!(extras = PlayerExtraDataStore.get((PlayerEntity)player)).isReady() || player.func_82150_aj()) {
            return;
        }
        int packedOverlay = LivingRenderer.func_229117_c_((LivingEntity)player, (float)0.0f);
        this.head = ((PlayerModel)this.renderer.func_217764_d()).field_78116_c;
        Minecraft.func_71410_x().func_213239_aq().func_76320_a("layer_hat");
        if (extras.isEnabled(PixelExtrasData.Category.HAT) && extras.getHatType() != PixelExtrasData.HatType.NONE) {
            if (extras.getHatType() == PixelExtrasData.HatType.SABLEYE_HOOD) {
                matrix.func_227860_a_();
                ModelRenderer body = ((PlayerModel)this.renderer.func_217764_d()).field_78115_e;
                body.func_228307_a_(matrix);
                matrix.func_227861_a_(0.0, 1.4, 0.0);
                this.SABLEYE_HOOD_BODY_MODEL.getModel().getModel().animate();
                this.SABLEYE_HOOD_BODY_MODEL.getModel().render(matrix, buffer.getBuffer(PixelmonRendering.getSMDRenderType(this.SABLEYE_HOOD_TEXTURE)), packedLight, packedOverlay);
                matrix.func_227865_b_();
            } else if (extras.getHatType() == PixelExtrasData.HatType.WITCH) {
                matrix.func_227860_a_();
                IBakedModel model = Minecraft.func_71410_x().func_209506_al().getModel(WITCH_HAT_MODEL);
                ((PlayerModel)this.renderer.func_217764_d()).func_205072_a().func_228307_a_(matrix);
                matrix.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(180.0f));
                matrix.func_227861_a_(-0.5, 0.4, -0.5);
                if (model != null) {
                    PixelmonRendering.renderQuadList(matrix.func_227866_c_(), buffer.getBuffer(RenderType.func_228643_e_()), 1.0f, 1.0f, 1.0f, model.getQuads(null, null, RandomHelper.getRandom(), (IModelData)EmptyModelData.INSTANCE), packedLight, packedOverlay);
                }
                matrix.func_227865_b_();
            }
            matrix.func_227860_a_();
            this.renderHat(matrix, buffer, packedLight, packedOverlay, (PlayerEntity)player, extras, partialTicks);
            matrix.func_227865_b_();
        }
        if (extras.isEnabled(PixelExtrasData.Category.MONOCLE) && (extras.getMonocleType() == PixelExtrasData.MonocleType.QUAGSIRE_MASK || extras.getMonocleType() == PixelExtrasData.MonocleType.QUARANTINE_MASK)) {
            matrix.func_227860_a_();
            this.renderMask(matrix, buffer, packedLight, packedOverlay, (PlayerEntity)player, extras, partialTicks);
            matrix.func_227865_b_();
        } else if (extras.isEnabled(PixelExtrasData.Category.MONOCLE) && extras.getMonocleType() != PixelExtrasData.MonocleType.NONE) {
            matrix.func_227860_a_();
            this.renderMonocle(matrix, buffer, packedLight, packedOverlay, (PlayerEntity)player, extras, partialTicks);
            matrix.func_227865_b_();
        }
        Minecraft.func_71410_x().func_213239_aq().func_76319_b();
    }

    public void renderHat(MatrixStack matrix, IRenderTypeBuffer buffer, int light, int overlay, PlayerEntity player, PixelExtrasData data, float partialTicks) {
        IVertexBuilder vertices;
        ResourceLocation path;
        ModelHolder<GenericSmdModel> hat;
        block0 : switch (data.getHatType()) {
            case TOP_HAT: {
                hat = this.TOPHAT_MODEL;
                path = this.TOP_HAT_TEXTURE;
                break;
            }
            case FEZ: {
                hat = this.FEZ_MODEL;
                path = this.FEZ_TEXTURE;
                break;
            }
            case FEDORA: {
                hat = this.FEDORA_MODEL;
                path = this.FEDORA_TEXTURE;
                break;
            }
            case TRAINER_CAP: {
                hat = this.TRAINERHAT_MODEL;
                path = this.TRAINERHAT_TEXTURE;
                break;
            }
            case PIKA_HOOD: {
                hat = this.PIKAHOOD_MODEL;
                path = this.PIKAHOOD_TEXTURE;
                break;
            }
            case EEVEE_HOOD: {
                hat = this.PIKAHOOD_MODEL;
                path = this.EEVEEHOOD_TEXTURE;
                break;
            }
            case SCOR_HOOD: {
                hat = this.PIKAHOOD_MODEL;
                path = this.SCORHOOD_TEXTURE;
                break;
            }
            case WIKI: {
                hat = this.WIKI_MODEL;
                path = this.WIKI_TEXTURE;
                break;
            }
            case WELKIN_HAT: {
                hat = this.WELKIN_MODEL;
                path = this.WELKIN_TEXTURE;
                break;
            }
            case ESPEON_SCARF: {
                hat = this.ESPEON_SCARF;
                path = this.ESPEON_SCARF_TEXTURE;
                break;
            }
            case FLAREON_SCARF: {
                hat = this.FLAREON_SCARF;
                path = this.FLAREON_SCARF_TEXTURE;
                break;
            }
            case GLACEON_SCARF: {
                hat = this.GLACEON_SCARF;
                path = this.GLACEON_SCARF_TEXTURE;
                break;
            }
            case JOLTEON_SCARF: {
                hat = this.JOLTEON_SCARF;
                path = this.JOLTEON_SCARF_TEXTURE;
                break;
            }
            case LEAFEON_SCARF: {
                hat = this.LEAFEON_SCARF;
                path = this.LEAFEON_SCARF_TEXTURE;
                break;
            }
            case SYLVEON_SCARF: {
                hat = this.SYLVEON_SCARF;
                path = this.SYLVEON_SCARF_TEXTURE;
                break;
            }
            case UMBREON_SCARF: {
                hat = this.UMBREON_SCARF;
                path = this.UMBREON_SCARF_TEXTURE;
                break;
            }
            case VAPOREON_SCARF: {
                hat = this.VAPOREON_SCARF;
                path = this.VAPOREON_SCARF_TEXTURE;
                break;
            }
            case SABLEYE_HOOD: {
                hat = this.SABLEYE_HOOD_HEAD_MODEL;
                path = this.SABLEYE_HOOD_TEXTURE;
                break;
            }
            case SPHEAL_HAT: {
                hat = this.SPHEALHAT_MODEL;
                switch (data.getSphealType()) {
                    default: {
                        path = this.SPHEAL_TEXTURE;
                        break block0;
                    }
                    case SHINY: {
                        path = this.SHINYSPHEAL_TEXTURE;
                        break block0;
                    }
                    case STITCHED: {
                        path = this.SPHEAL_STITCHED_TEXTURE;
                        break block0;
                    }
                    case SHINY_STITCHED: 
                }
                path = this.SHINYSPHEAL_STICHED_TEXTURE;
                break;
            }
            default: {
                return;
            }
        }
        matrix.func_227860_a_();
        this.head.func_228307_a_(matrix);
        matrix.func_227861_a_(0.0, 1.5, 0.0);
        if (data.getHatType() == PixelExtrasData.HatType.TRAINER_CAP) {
            vertices = buffer.getBuffer(PixelmonRendering.getSMDRenderType(this.locationCapBG));
            if (data.getColours(PixelExtrasData.Category.HAT)[0] == -1) {
                int i = player.field_70173_aa / 25 + player.func_145782_y();
                int j = DyeColor.values().length;
                int k = i % j;
                int l = (i + 1) % j;
                float f7 = ((float)(player.field_70173_aa % 25) + partialTicks) / 25.0f;
                float[] afloat1 = SheepEntity.func_175513_a((DyeColor)DyeColor.func_196056_a((int)k));
                float[] afloat2 = SheepEntity.func_175513_a((DyeColor)DyeColor.func_196056_a((int)l));
                float r = afloat1[0] * (1.0f - f7) + afloat2[0] * f7;
                float g = afloat1[1] * (1.0f - f7) + afloat2[1] * f7;
                float b = afloat1[2] * (1.0f - f7) + afloat2[2] * f7;
                this.capBG.func_195414_e().func_195700_a(0, 0, 0xFF000000 | (int)((double)(r * 255.0f) + 0.5) << 16 | (int)((double)(g * 255.0f) + 0.5) << 8 | (int)((double)(b * 255.0f) + 0.5));
            } else {
                this.capBG.func_195414_e().func_195700_a(0, 0, 0xFF000000 | data.getColours(PixelExtrasData.Category.HAT)[0] << 16 | data.getColours(PixelExtrasData.Category.HAT)[1] << 8 | data.getColours(PixelExtrasData.Category.HAT)[2]);
            }
            this.capBG.func_110564_a();
            hat.getModel().getModel().animate();
            hat.getModel().render(matrix, vertices, light, overlay);
        }
        vertices = buffer.getBuffer(PixelmonRendering.getSMDRenderType(path));
        hat.getModel().getModel().animate();
        hat.getModel().render(matrix, vertices, light, overlay);
        matrix.func_227865_b_();
    }

    public void renderMonocle(MatrixStack matrix, IRenderTypeBuffer buffer, int light, int overlay, PlayerEntity player, PixelExtrasData data, float partialTicks) {
        matrix.func_227860_a_();
        this.head.func_228307_a_(matrix);
        matrix.func_227861_a_(0.0, 1.5, 0.0);
        matrix.func_227861_a_((double)0.15f, (double)-1.45f, (double)-0.29f);
        matrix.func_227862_a_(0.3f, 0.3f, 0.3f);
        ResourceLocation texture = data.getMonocleType() == PixelExtrasData.MonocleType.GOLD_MONOCLE ? this.GOLD_MONOCLE_TEXTURE : (data.getMonocleType() == PixelExtrasData.MonocleType.BLACK_MONOCLE ? this.BLACK_MONOCLE_TEXTURE : this.GOLD_MONOCLE_TEXTURE);
        IVertexBuilder vertices = buffer.getBuffer(PixelmonRendering.getSMDRenderType(texture));
        this.MONOCLE_MODEL.getModel().getModel().animate();
        this.MONOCLE_MODEL.getModel().render(matrix, vertices, light, overlay);
        matrix.func_227865_b_();
    }

    public void renderMask(MatrixStack matrix, IRenderTypeBuffer buffer, int light, int overlay, PlayerEntity player, PixelExtrasData data, float partialTicks) {
        matrix.func_227860_a_();
        this.head.func_228307_a_(matrix);
        matrix.func_227861_a_(0.0, (double)1.7f, (double)-1.735f);
        if (data.getMonocleType() == PixelExtrasData.MonocleType.QUAGSIRE_MASK) {
            IVertexBuilder vertices = buffer.getBuffer(PixelmonRendering.getSMDRenderType(this.QUAGSIRE_MASK_TEXTURE));
            this.QUAGSIRE_MASK_MODEL.getModel().getModel().animate();
            this.QUAGSIRE_MASK_MODEL.getModel().render(matrix, vertices, light, overlay);
        } else {
            IVertexBuilder vertices = buffer.getBuffer(PixelmonRendering.getSMDRenderType(this.QUARANTINE_MASK_TEXTURE));
            this.QUARANTINE_MASK_MODEL.getModel().getModel().animate();
            this.QUARANTINE_MASK_MODEL.getModel().render(matrix, vertices, light, overlay);
        }
        matrix.func_227865_b_();
    }
}

