/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.zygarde;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.PowerConstruct;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.blocks.tileentity.ReassemblyUnitTileEntity;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.PokemonUI;
import com.pixelmonmod.pixelmon.client.gui.widgets.RoundButton;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.zygarde.ZygardeReassemblyPacket;
import com.pixelmonmod.pixelmon.items.ZygardeCubeItem;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.StringTextComponent;

public class ZygardeReassemblyUnitScreen
extends Screen {
    BlockPos pos;
    Mode mode = null;
    StoragePosition position = null;
    boolean requirementsMet = true;
    List<RoundButton> field_230710_m_ = Lists.newArrayList();
    List<PokemonUI> pokemon = Lists.newArrayList();
    List<String> lines = Lists.newArrayList();
    int buttonOffset = 30;
    private int centerW;
    private int centerH;

    public ZygardeReassemblyUnitScreen(int x, int y, int z) {
        super(StringTextComponent.field_240750_d_);
        this.field_230706_i_ = Minecraft.func_71410_x();
        this.pos = new BlockPos(x, y, z);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.centerW = this.field_230708_k_ / 2;
        this.centerH = this.field_230709_l_ / 2;
        this.field_230710_m_.clear();
        this.pokemon.clear();
        this.lines.clear();
        if (this.mode == null) {
            this.buttonOffset = 30;
            this.lines.add(I18n.func_135052_a((String)"pixelmon.gui.zygarde_reassembly.select", (Object[])new Object[0]));
            this.field_230710_m_.add(new RoundButton(0, 0, I18n.func_135052_a((String)"pixelmon.gui.zygarde_reassembly.assembly", (Object[])new Object[0]), 150, 20));
            this.field_230710_m_.add(new RoundButton(0, 0, I18n.func_135052_a((String)"pixelmon.gui.zygarde_reassembly.with_zygarde", (Object[])new Object[0]), 150, 20));
            this.field_230710_m_.add(new RoundButton(0, 0, I18n.func_135052_a((String)"pixelmon.gui.zygarde_reassembly.separation", (Object[])new Object[0]), 150, 20));
        } else if (this.mode == Mode.SEPARATION) {
            if (this.position == null) {
                this.lines.add(I18n.func_135052_a((String)"pixelmon.gui.zygarde_reassembly.separation.select", (Object[])new Object[0]));
                for (int i = 0; i < 6; ++i) {
                    this.pokemon.add(new PokemonUI(0, 0));
                }
            } else if (ClientStorageManager.party.get(this.position) == null || !ClientStorageManager.party.get(this.position).getSpecies().is(PixelmonSpecies.ZYGARDE)) {
                this.lines.add(I18n.func_135052_a((String)"pixelmon.gui.zygarde_reassembly.not_zygarde", (Object[])new Object[0]));
                this.field_230710_m_.add(new RoundButton(0, 0, I18n.func_135052_a((String)"gui.button.okay", (Object[])new Object[0]), 150, 20));
            } else if (ClientStorageManager.party.countPokemon() == 1) {
                this.lines.add(I18n.func_135052_a((String)"pixelmon.gui.zygarde_reassembly.last_pokemon", (Object[])new Object[0]));
                this.field_230710_m_.add(new RoundButton(0, 0, I18n.func_135052_a((String)"gui.button.okay", (Object[])new Object[0]), 150, 20));
            } else if (ClientStorageManager.party.get(this.position).getAbility() instanceof PowerConstruct) {
                this.lines.add(I18n.func_135052_a((String)"pixelmon.gui.zygarde_reassembly.separation.cannot", (Object[])new Object[0]));
                this.field_230710_m_.add(new RoundButton(0, 0, I18n.func_135052_a((String)"gui.button.okay", (Object[])new Object[0]), 150, 20));
            } else {
                this.lines.add(I18n.func_135052_a((String)"pixelmon.gui.zygarde_reassembly.separation.confirm", (Object[])new Object[0]));
                this.field_230710_m_.add(new RoundButton(0, 0, I18n.func_135052_a((String)"gui.button.yes", (Object[])new Object[0]), 150, 20));
                this.field_230710_m_.add(new RoundButton(0, 0, I18n.func_135052_a((String)"gui.button.cancel", (Object[])new Object[0]), 150, 20));
            }
        } else if (this.mode == Mode.ASSEMBLY_WITH_ZYGARDE) {
            if (this.position == null) {
                this.lines.add(I18n.func_135052_a((String)"pixelmon.gui.zygarde_reassembly.with_zygarde.select", (Object[])new Object[0]));
                for (int i = 0; i < 6; ++i) {
                    this.pokemon.add(new PokemonUI(0, 0));
                }
            } else if (ClientStorageManager.party.get(this.position) == null || !ClientStorageManager.party.get(this.position).getSpecies().is(PixelmonSpecies.ZYGARDE)) {
                this.lines.add(I18n.func_135052_a((String)"pixelmon.gui.zygarde_reassembly.not_zygarde", (Object[])new Object[0]));
                this.field_230710_m_.add(new RoundButton(0, 0, I18n.func_135052_a((String)"gui.button.okay", (Object[])new Object[0]), 150, 20));
            } else if (ClientStorageManager.party.get(this.position).getAbility() instanceof PowerConstruct) {
                this.lines.add(I18n.func_135052_a((String)"pixelmon.gui.zygarde_reassembly.with_zygarde.cannot", (Object[])new Object[0]));
                this.field_230710_m_.add(new RoundButton(0, 0, I18n.func_135052_a((String)"gui.button.okay", (Object[])new Object[0]), 150, 20));
            } else {
                Pokemon pokemon = ClientStorageManager.party.get(this.position);
                ItemStack cube = this.getCube();
                if (cube == null || pokemon == null) {
                    this.field_230706_i_.func_147108_a(null);
                    return;
                }
                int count = ZygardeCubeItem.getCellCount(cube);
                int cores = ZygardeCubeItem.getCoreCount(cube);
                if (pokemon.getForm().isForm("ten_percent")) {
                    if (count >= 90 && cores >= 1) {
                        this.lines.add(I18n.func_135052_a((String)"pixelmon.gui.zygarde_reassembly.with_zygarde.10to100", (Object[])new Object[0]));
                    } else if (count >= 40) {
                        this.lines.add(I18n.func_135052_a((String)"pixelmon.gui.zygarde_reassembly.with_zygarde.10to50", (Object[])new Object[0]));
                        this.lines.add("");
                    } else {
                        this.lines.add(I18n.func_135052_a((String)"pixelmon.gui.zygarde_reassembly.missingcells", (Object[])new Object[0]));
                        this.requirementsMet = false;
                    }
                } else if (pokemon.getForm().isForm("fifty_percent")) {
                    if (count >= 50 && cores >= 1) {
                        this.lines.add(I18n.func_135052_a((String)"pixelmon.gui.zygarde_reassembly.with_zygarde.50to100", (Object[])new Object[0]));
                    } else if (count >= 50) {
                        this.lines.add(I18n.func_135052_a((String)"pixelmon.gui.zygarde_reassembly.with_zygarde.missingcores", (Object[])new Object[0]));
                        this.requirementsMet = false;
                    } else {
                        this.lines.add(I18n.func_135052_a((String)"pixelmon.gui.zygarde_reassembly.missingcells", (Object[])new Object[0]));
                        this.requirementsMet = false;
                    }
                }
                this.field_230710_m_.add(new RoundButton(0, 0, I18n.func_135052_a((String)"gui.button.okay", (Object[])new Object[0]), 150, 20));
                if (this.requirementsMet) {
                    this.field_230710_m_.add(new RoundButton(0, 0, I18n.func_135052_a((String)"gui.button.cancel", (Object[])new Object[0]), 150, 20));
                }
            }
        } else if (this.mode == Mode.ASSEMBLY) {
            ItemStack cube = this.getCube();
            if (cube != null) {
                int count = ZygardeCubeItem.getCellCount(cube);
                int cores = ZygardeCubeItem.getCoreCount(cube);
                if (count >= 100 && cores >= 2) {
                    this.lines.add(I18n.func_135052_a((String)"pixelmon.gui.zygarde_reassembly.assembly.100", (Object[])new Object[0]));
                } else if (count >= 50 && cores >= 1) {
                    this.lines.add(I18n.func_135052_a((String)"pixelmon.gui.zygarde_reassembly.assembly.50", (Object[])new Object[0]));
                } else if (count >= 10 && cores >= 1) {
                    this.lines.add(I18n.func_135052_a((String)"pixelmon.gui.zygarde_reassembly.assembly.10", (Object[])new Object[0]));
                } else if (count >= 10) {
                    this.lines.add(I18n.func_135052_a((String)"pixelmon.gui.zygarde_reassembly.assembly.missingcore", (Object[])new Object[0]));
                    this.requirementsMet = false;
                } else {
                    this.lines.add(I18n.func_135052_a((String)"pixelmon.gui.zygarde_reassembly.missingcells", (Object[])new Object[0]));
                    this.requirementsMet = false;
                }
            } else {
                this.field_230706_i_.func_147108_a(null);
            }
            this.buttonOffset = 30;
            this.field_230710_m_.add(new RoundButton(0, 0, I18n.func_135052_a((String)"gui.button.okay", (Object[])new Object[0]), 150, 20));
            if (this.requirementsMet) {
                this.field_230710_m_.add(new RoundButton(0, 0, I18n.func_135052_a((String)"gui.button.cancel", (Object[])new Object[0]), 150, 20));
            }
        }
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        int i;
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        if (!this.lines.isEmpty()) {
            ScreenHelper.drawDialogueBox(matrix, (Screen)this, "", this.lines, 0.0f);
        }
        PlayerPartyStorage party = ClientStorageManager.party;
        for (i = 0; i < this.pokemon.size(); ++i) {
            boolean highlight = this.pokemon.get(i).isMouseOver(i < 3 ? this.centerW - 110 : this.centerW + 5, this.field_230709_l_ / 4 + 20 + this.buttonOffset * (i % 3 + 1), mouseX, mouseY);
            this.pokemon.get(i).drawPokemon(matrix, party.get(i), i < 3 ? this.centerW - 110 : this.centerW + 5, this.field_230709_l_ / 4 + 20 + this.buttonOffset * (i % 3 + 1), mouseX, mouseY, 0.0f, highlight);
        }
        for (i = 0; i < this.field_230710_m_.size(); ++i) {
            RoundButton button = this.field_230710_m_.get(i);
            button.drawButton(matrix, this.centerW - 70, this.field_230709_l_ / 4 + 20 + this.buttonOffset * (i + 1), mouseX, mouseY, 0.0f);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        int i;
        for (i = 0; i < this.pokemon.size(); ++i) {
            PokemonUI pokemonUI = this.pokemon.get(i);
            if (!pokemonUI.isMouseOver(i < 3 ? this.centerW - 110 : this.centerW + 5, this.field_230709_l_ / 4 + 20 + this.buttonOffset * (i % 3 + 1), mouseX, mouseY) || this.mode != Mode.SEPARATION && (this.mode != Mode.ASSEMBLY_WITH_ZYGARDE || this.position != null)) continue;
            if (ClientStorageManager.party.get(new StoragePosition(-1, i)) == null) {
                return false;
            }
            this.position = new StoragePosition(-1, i);
            this.func_231160_c_();
            return false;
        }
        for (i = 0; i < this.field_230710_m_.size(); ++i) {
            ItemStack cube;
            RoundButton button = this.field_230710_m_.get(i);
            if (!button.isMouseOver(this.centerW - 70, this.field_230709_l_ / 4 + 20 + this.buttonOffset * (i + 1), mouseX, mouseY)) continue;
            if (this.mode == null) {
                this.mode = i == 0 ? Mode.ASSEMBLY : (i == 1 ? Mode.ASSEMBLY_WITH_ZYGARDE : Mode.SEPARATION);
                this.func_231160_c_();
                continue;
            }
            if (this.mode == Mode.SEPARATION || this.mode == Mode.ASSEMBLY_WITH_ZYGARDE) {
                ItemStack cube2;
                if (this.position == null) continue;
                Pokemon pokemon = ClientStorageManager.party.get(this.position);
                if (this.requirementsMet && pokemon != null && ClientStorageManager.party.countPokemon() != 1 && pokemon.getSpecies().is(PixelmonSpecies.ZYGARDE) && !(pokemon.getAbility() instanceof PowerConstruct) && i == 0 && (cube2 = this.getCube()) != null) {
                    NetworkHelper.sendToServer(new ZygardeReassemblyPacket(this.pos, this.mode == Mode.SEPARATION ? ReassemblyUnitTileEntity.Mode.SEPARATING : ReassemblyUnitTileEntity.Mode.ASSEMBLING, this.position, this.field_230706_i_.field_71439_g.field_71071_by.func_184429_b(cube2)));
                }
                this.field_230706_i_.func_147108_a(null);
                continue;
            }
            if (this.mode != Mode.ASSEMBLY) continue;
            if (i == 0 && this.requirementsMet && (cube = this.getCube()) != null) {
                NetworkHelper.sendToServer(new ZygardeReassemblyPacket(this.pos, ReassemblyUnitTileEntity.Mode.ASSEMBLING, null, this.field_230706_i_.field_71439_g.field_71071_by.func_184429_b(cube)));
            }
            this.field_230706_i_.func_147108_a(null);
        }
        return true;
    }

    public boolean func_231177_au__() {
        return false;
    }

    private ItemStack getCube() {
        PlayerInventory inv = this.field_230706_i_.field_71439_g.field_71071_by;
        Predicate<ItemStack> check = itemStack -> itemStack.func_77973_b() == PixelmonItems.zygarde_cube.getItem();
        Optional<ItemStack> opt = inv.field_70462_a.stream().filter(check).findFirst();
        if (!opt.isPresent()) {
            opt = inv.field_184439_c.stream().filter(check).findFirst();
        }
        return opt.orElse(null);
    }

    public static enum Mode {
        ASSEMBLY,
        ASSEMBLY_WITH_ZYGARDE,
        SEPARATION;

    }
}

