/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.widgets;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.text.StringTextComponent;

public class TabCompleteTranslateableTextField<T extends ITranslatable>
extends TextFieldWidget {
    private Collection<T> completions = Collections.emptyList();
    private List<T> cache = Lists.newArrayList();
    private boolean isCompleting = false;
    private int index = 0;
    private int id;
    private T value;

    public TabCompleteTranslateableTextField(int componentId, FontRenderer fontrendererObj, int x, int y, int par5Width, int par6Height) {
        super(fontrendererObj, x, y, par5Width, par6Height, StringTextComponent.field_240750_d_);
        this.id = componentId;
    }

    public TabCompleteTranslateableTextField<T> setCompletions(Collection<T> completions) {
        this.completions = completions;
        return this;
    }

    public boolean func_231046_a_(int key, int scanCode, int modifiers) {
        if (!this.func_230999_j_()) {
            return super.func_231046_a_(key, scanCode, modifiers);
        }
        if (key == 258) {
            if (this.isCompleting) {
                this.func_146175_b(0);
                this.func_146175_b(this.func_146187_c(-1) - this.func_146198_h());
                if (this.index >= this.cache.size()) {
                    this.index = 0;
                }
            } else {
                int i = this.func_146187_c(-1);
                String s = this.field_146216_j.substring(0, this.func_146198_h());
                this.index = 0;
                this.createCompletionsFor(s);
                if (this.cache.isEmpty()) {
                    return true;
                }
                this.isCompleting = true;
                this.func_146175_b(i - this.func_146198_h());
            }
            ITranslatable t = (ITranslatable)this.cache.get(this.index++);
            this.func_146180_a(t.getLocalizedName());
            this.value = t;
            return true;
        }
        this.isCompleting = false;
        return super.func_231046_a_(key, scanCode, modifiers);
    }

    public String func_146179_b() {
        return this.value.getLocalizedName();
    }

    public T getTranslatableValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
        this.func_146180_a(this.value.getTranslatedName().getString());
    }

    public boolean func_231042_a_(char typedChar, int keyCode) {
        if (!this.func_230999_j_()) {
            return super.func_231042_a_(typedChar, keyCode);
        }
        if (keyCode == 258) {
            if (this.isCompleting) {
                this.func_146175_b(0);
                this.func_146175_b(this.func_146187_c(-1) - this.func_146198_h());
                if (this.index >= this.cache.size()) {
                    this.index = 0;
                }
            } else {
                int i = this.func_146187_c(-1);
                String s = this.field_146216_j.substring(0, this.func_146198_h());
                this.index = 0;
                this.createCompletionsFor(s);
                if (this.cache.isEmpty()) {
                    return true;
                }
                this.isCompleting = true;
                this.func_146175_b(i - this.func_146198_h());
            }
            ITranslatable t = (ITranslatable)this.cache.get(this.index++);
            this.func_146180_a(t.getLocalizedName());
            this.value = t;
            return true;
        }
        this.isCompleting = false;
        return super.func_231042_a_(typedChar, keyCode);
    }

    protected void createCompletionsFor(String leftOfCursor) {
        this.cache.clear();
        if (leftOfCursor.isEmpty()) {
            this.cache.addAll(this.completions);
            return;
        }
        for (ITranslatable completion : this.completions) {
            if (!completion.getLocalizedName().regionMatches(true, 0, leftOfCursor, 0, leftOfCursor.length())) continue;
            this.cache.add(completion);
        }
    }
}

