/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.npcEditor;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BaseStatsLearnType;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.client.gui.PixelmonOverlayScreen;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.chooseMoveset.ClickableElement;
import com.pixelmonmod.pixelmon.client.gui.chooseMoveset.TutorListScreen;
import com.pixelmonmod.pixelmon.client.gui.npc.TutorScreen;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.TextureEditorNPC;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDownScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.TabCompleteTextField;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.DeleteTrainerPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.StoreTutorDataPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.INestedGuiEventHandler;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class TutorEditorScreen
extends DropDownScreen
implements INestedGuiEventHandler,
ClickableElement<NPCTutor.LearnableMove> {
    public static EnumSet<BaseStatsLearnType> learnTypes = EnumSet.noneOf(BaseStatsLearnType.class);
    private final Map<String, Item> itemMap = new HashMap<String, Item>();
    private final Map<String, Item> idMap = new HashMap<String, Item>();
    private final Map<String, Item> modAndIdMap = new HashMap<String, Item>();
    NPCTutor tutor;
    List<ItemStack> cost;
    int listTop;
    int listLeft;
    int listHeight;
    int listWidth;
    TutorListScreen guiMoveList;
    int selectedMove = -1;
    TextFieldWidget newMove;
    TextFieldWidget newItem;
    TextFieldWidget newItemAmount;
    TextFieldWidget newItemDamage;
    Button okayButton;
    Button addMove;
    Button deleteMove;
    Button addItem;
    Button[] deleteCost = new Button[4];
    Button[] learnTypeButtons = new Button[BaseStatsLearnType.GEN8_DEFAULT.length];
    Button deleteTutor;
    private TextureEditorNPC textureEditor;

    public TutorEditorScreen(int tutorID) {
        super(StringTextComponent.field_240750_d_);
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        Optional<NPCTutor> entityNPCOptional = NPCEntity.locateNPCClient((World)Minecraft.func_71410_x().field_71441_e, tutorID, NPCTutor.class);
        if (!entityNPCOptional.isPresent()) {
            ScreenHelper.closeScreen();
            return;
        }
        this.tutor = entityNPCOptional.get();
        this.listHeight = 150;
        this.listWidth = 90;
        ForgeRegistries.ITEMS.getValues().stream().map(ItemStack::new).forEach(itemStack -> {
            Item item = itemStack.func_77973_b();
            this.itemMap.put(itemStack.func_200301_q().getString(), item);
            ResourceLocation location = itemStack.func_77973_b().getRegistryName();
            this.idMap.put(location.func_110623_a().toLowerCase(Locale.ROOT), item);
            this.modAndIdMap.put((location.func_110624_b() + ":" + location.func_110623_a()).toLowerCase(Locale.ROOT), item);
        });
    }

    @Override
    public void func_231160_c_() {
        int i;
        super.func_231160_c_();
        PixelmonOverlayScreen.isVisible = false;
        Minecraft.func_71410_x().field_71474_y.field_74319_N = true;
        Minecraft.func_71410_x().field_71474_y.field_74330_P = false;
        this.listTop = this.field_230709_l_ / 2 - 62;
        this.listLeft = this.field_230708_k_ / 2 - 68;
        this.guiMoveList = new TutorListScreen(this, TutorScreen.moveList, this.listWidth, this.listHeight, this.listTop, this.listLeft, this.field_230706_i_);
        this.field_230705_e_.add(new IndexedButton(1, this.field_230708_k_ / 2 + 155, this.field_230709_l_ / 2 + 90, 50, 20, (ITextComponent)new TranslationTextComponent("gui.pokemoneditor.save"), this::actionPerformed));
        this.okayButton = new IndexedButton(10, this.field_230708_k_ / 2 + 20, this.field_230709_l_ / 2 + 90, 50, 20, (ITextComponent)new TranslationTextComponent("gui.guiItemDrops.ok"), this::actionPerformed);
        this.newMove = new TabCompleteTextField(1, this.field_230712_o_, this.field_230708_k_ / 2 + 54, this.field_230709_l_ / 2 - 100, 90, 16).setCompletions(AttackRegistry.getAllAttacks().stream().map(ITranslatable::getLocalizedName).collect(Collectors.toSet()));
        this.newItem = new TabCompleteTextField(2, this.field_230712_o_, this.field_230708_k_ / 2 + 80, this.field_230709_l_ / 2 + 30, 70, 16).setCompletions(this.itemMap.keySet());
        this.newItemAmount = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 + 80, this.field_230709_l_ / 2 + 50, 70, 16, StringTextComponent.field_240750_d_);
        this.newItemDamage = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 + 80, this.field_230709_l_ / 2 + 70, 70, 16, StringTextComponent.field_240750_d_);
        this.addMove = new IndexedButton(2, this.field_230708_k_ / 2 + 69, this.field_230709_l_ / 2 - 80, 60, 20, (ITextComponent)new TranslationTextComponent("gui.tutor.addmove"), this::actionPerformed);
        this.deleteMove = new IndexedButton(3, this.field_230708_k_ / 2 + 64, this.field_230709_l_ / 2 - 45, 70, 20, (ITextComponent)new TranslationTextComponent("gui.tutor.deletemove"), this::actionPerformed);
        this.addItem = new IndexedButton(4, this.field_230708_k_ / 2 + 80, this.field_230709_l_ / 2 + 90, 60, 20, (ITextComponent)new TranslationTextComponent("gui.tutor.addcost"), this::actionPerformed);
        this.field_230705_e_.add(this.guiMoveList);
        this.field_230705_e_.add(this.newMove);
        if (this.selectedMove > -1) {
            this.field_230705_e_.add(this.newItemAmount);
            this.field_230705_e_.add(this.newItemDamage);
            this.field_230705_e_.add(this.newItem);
            this.field_230705_e_.add(this.addItem);
            this.field_230705_e_.add(this.deleteMove);
            this.field_230705_e_.add(this.okayButton);
        } else {
            i = 0;
            for (BaseStatsLearnType type : BaseStatsLearnType.GEN8_DEFAULT) {
                this.learnTypeButtons[i] = new IndexedButton(11 + i, this.field_230708_k_ / 2 + 150, this.field_230709_l_ / 2 - 34 + 16 * i, 20, 16, (ITextComponent)new StringTextComponent(learnTypes.contains((Object)type) ? "O" : "X"), this::actionPerformed);
                this.field_230705_e_.add(this.learnTypeButtons[i]);
                ++i;
            }
        }
        for (i = 0; i < this.deleteCost.length; ++i) {
            this.deleteCost[i] = new IndexedButton(5 + i, this.field_230708_k_ / 2 + 80 + 20 * i, this.field_230709_l_ / 2 + 8, 20, 20, (ITextComponent)new StringTextComponent("X"), this::actionPerformed);
        }
        this.deleteTutor = new IndexedButton(9, this.field_230708_k_ / 2 - 173, this.field_230709_l_ / 2 - 100, 80, 20, (ITextComponent)new TranslationTextComponent("gui.tutor.deletetutor"), this::actionPerformed);
        this.textureEditor = new TextureEditorNPC(this, this.tutor, this.field_230708_k_ / 2 - 190, this.field_230709_l_ / 2 + 55, 100, -28);
        this.field_230705_e_.add(this.textureEditor.customTextureBox);
        this.field_230705_e_.add(this.addMove);
    }

    public void func_231175_as__() {
        super.func_231175_as__();
        this.saveFields();
        PixelmonOverlayScreen.isVisible = true;
        Minecraft.func_71410_x().field_71474_y.field_74319_N = false;
    }

    @Override
    protected void drawBackgroundUnderMenus(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        String text;
        float sixteenthWidth = 40.0f;
        float sixteenthHeight = 20.0f;
        ScreenHelper.drawImageQuad(Resources.cwPanel, matrix, 0.0f + sixteenthWidth, 0.0f + sixteenthHeight, (float)this.field_230708_k_ - sixteenthWidth * 2.0f, (float)this.field_230709_l_ - sixteenthHeight * 2.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.9f, 0.9f, 0.9f, 0.75f, 0.0f);
        RenderHelper.func_74518_a();
        ScreenHelper.drawInUnicode(() -> {
            String text1 = I18n.func_135052_a((String)"pixelmon.npc.tutorname", (Object[])new Object[0]);
            this.field_230712_o_.func_238421_b_(matrix, text1, (float)this.field_230708_k_ / 2.0f - (float)this.field_230712_o_.func_78256_a(text1) / 2.0f, (float)this.field_230709_l_ / 2.0f - 100.0f, 0);
        });
        ScreenHelper.drawInUnicode(() -> {
            String text1 = I18n.func_135052_a((String)"gui.choosemoveset.choosemove", (Object[])new Object[0]);
            this.field_230712_o_.func_238421_b_(matrix, text1, (float)this.field_230708_k_ / 2.0f - 33.0f - (float)this.field_230712_o_.func_78256_a(text1) / 2.0f, (float)this.field_230709_l_ / 2.0f - 76.0f, 0);
        });
        ScreenHelper.drawEntity(matrix, (LivingEntity)this.tutor, this.field_230708_k_ / 2 - 133, this.field_230709_l_ / 2 + 50, 50.0f, 0.0f, 0.0f);
        if (this.selectedMove >= 0) {
            text = TutorScreen.moveList.get(this.selectedMove).attack().getLocalizedName();
            this.field_230706_i_.field_71466_p.func_238421_b_(matrix, text, (float)this.field_230708_k_ / 2.0f + 99.0f - (float)this.field_230712_o_.func_78256_a(text) / 2.0f, (float)this.field_230709_l_ / 2.0f - 20.0f, 0);
            text = I18n.func_135052_a((String)"gui.choosemoveset.cost", (Object[])new Object[0]);
            this.field_230706_i_.field_71466_p.func_238421_b_(matrix, text, (float)this.field_230708_k_ / 2.0f + 74.0f - (float)this.field_230712_o_.func_78256_a(text), (float)this.field_230709_l_ / 2.0f - 5.0f, 0);
            if (this.cost.size() < 4) {
                text = I18n.func_135052_a((String)"gui.tutor.itemname", (Object[])new Object[0]);
                this.field_230706_i_.field_71466_p.func_238421_b_(matrix, text, (float)this.field_230708_k_ / 2.0f + 75.0f - (float)this.field_230712_o_.func_78256_a(text), (float)this.field_230709_l_ / 2.0f + 35.0f, 0);
                text = I18n.func_135052_a((String)"gui.tutor.itemamount", (Object[])new Object[0]);
                this.field_230706_i_.field_71466_p.func_238421_b_(matrix, text, (float)this.field_230708_k_ / 2.0f + 75.0f - (float)this.field_230712_o_.func_78256_a(text), (float)this.field_230709_l_ / 2.0f + 55.0f, 0);
                text = I18n.func_135052_a((String)"gui.tutor.itemdamage", (Object[])new Object[0]);
                this.field_230706_i_.field_71466_p.func_238421_b_(matrix, text, (float)this.field_230708_k_ / 2.0f + 75.0f - (float)this.field_230712_o_.func_78256_a(text), (float)this.field_230709_l_ / 2.0f + 75.0f, 0);
            }
        } else {
            text = I18n.func_135052_a((String)"gui.tutor.learntypes", (Object[])new Object[0]);
            this.field_230712_o_.func_238421_b_(matrix, text, (float)this.field_230708_k_ / 2.0f + 160.0f - (float)this.field_230712_o_.func_78256_a(text), (float)this.field_230709_l_ / 2.0f - 45.0f, 0);
            int count = 0;
            for (BaseStatsLearnType type : BaseStatsLearnType.GEN8_DEFAULT) {
                text = I18n.func_135052_a((String)("gui.tutor.learntype." + type.name().toLowerCase(Locale.ROOT)), (Object[])new Object[0]);
                this.field_230712_o_.func_238421_b_(matrix, text, (float)this.field_230708_k_ / 2.0f + 140.0f - (float)this.field_230712_o_.func_78256_a(text), (float)this.field_230709_l_ / 2.0f - 30.0f + (float)(16 * count), 0);
                ++count;
            }
        }
        this.textureEditor.drawCustomTextBox(matrix, mouseX, mouseY, partialTicks);
        if (this.cost != null && !this.cost.isEmpty()) {
            int i = 0;
            for (ItemStack item : this.cost) {
                this.field_230707_j_.func_180450_b(item, this.field_230708_k_ / 2 + 80 + i * 21, this.field_230709_l_ / 2 - 10);
                this.field_230707_j_.func_180453_a(this.field_230706_i_.field_71466_p, item, this.field_230708_k_ / 2 + 80 + i * 21, this.field_230709_l_ / 2 - 10, null);
                if (i < this.deleteCost.length && !this.field_230705_e_.contains(this.deleteCost[i])) {
                    this.field_230705_e_.add(this.deleteCost[i]);
                }
                ++i;
            }
        }
    }

    @Override
    public void elementClicked(List<NPCTutor.LearnableMove> list, int index) {
        if (!TutorScreen.moveList.isEmpty() && index < TutorScreen.moveList.size()) {
            this.selectedMove = index;
            this.cost = TutorScreen.moveList.get(index).costs();
            if (!this.field_230705_e_.contains(this.deleteMove)) {
                this.field_230705_e_.add(this.deleteMove);
            }
            if (!this.field_230705_e_.contains(this.addItem) && this.cost.size() < 4) {
                this.field_230705_e_.add(this.addItem);
            }
            for (Button deleteCostButton : this.deleteCost) {
                this.field_230705_e_.remove(deleteCostButton);
            }
            this.field_230705_e_.removeAll(Arrays.asList(this.learnTypeButtons));
            this.field_230705_e_.add(this.okayButton);
            this.field_230705_e_.add(this.newItem);
            this.field_230705_e_.add(this.newItemDamage);
            this.field_230705_e_.add(this.newItemAmount);
        }
    }

    public boolean func_231042_a_(char key, int keyCode) {
        if (keyCode == 256 || keyCode == 257) {
            this.saveFields();
        }
        return super.func_231042_a_(key, keyCode);
    }

    protected void actionPerformed(Button button) {
        if (button instanceof IndexedButton) {
            int id = ((IndexedButton)button).id;
            if (id == 1) {
                this.saveFields();
            } else if (id == 2) {
                Optional<ImmutableAttack> optional = AttackRegistry.getAttackBase(this.newMove.func_146179_b());
                if (optional.isPresent()) {
                    ImmutableAttack move = optional.get();
                    if (TutorScreen.moveList.stream().noneMatch(it -> it.attack() == move)) {
                        TutorScreen.moveList.add(new NPCTutor.LearnableMove(move, Lists.newArrayList(), true));
                    }
                }
            } else if (id == 3) {
                if (this.selectedMove >= 0 && this.selectedMove < TutorScreen.moveList.size()) {
                    TutorScreen.moveList.remove(this.selectedMove);
                    this.cost = null;
                    this.selectedMove = -1;
                    this.field_230705_e_.remove(this.addItem);
                    this.field_230705_e_.remove(this.deleteMove);
                    this.field_230705_e_.remove(this.newItem);
                    this.field_230705_e_.remove(this.newItemDamage);
                    this.field_230705_e_.remove(this.newItemAmount);
                    this.field_230705_e_.remove(this.okayButton);
                    for (Button deleteCostButton : this.deleteCost) {
                        this.field_230705_e_.remove(deleteCostButton);
                    }
                    this.field_230705_e_.addAll(Arrays.asList(this.learnTypeButtons));
                }
            } else if (id == 4) {
                if (this.cost.size() < 4) {
                    String itemString = this.newItem.func_146179_b();
                    Item item = null;
                    if (this.itemMap.containsKey(itemString)) {
                        item = this.itemMap.get(itemString);
                    } else if (this.idMap.containsKey(itemString.toLowerCase(Locale.ROOT))) {
                        item = this.idMap.get(itemString.toLowerCase(Locale.ROOT));
                    } else if (this.modAndIdMap.containsKey(itemString.toLowerCase(Locale.ROOT))) {
                        item = this.modAndIdMap.get(itemString.toLowerCase(Locale.ROOT));
                    } else {
                        try {
                            item = Item.func_150899_d((int)Integer.parseInt(itemString));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (item != null) {
                        int amount = 1;
                        int damage = 0;
                        try {
                            amount = Math.max(amount, Integer.parseInt(this.newItemAmount.func_146179_b()));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        try {
                            damage = Math.max(damage, Integer.parseInt(this.newItemDamage.func_146179_b()));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        ItemStack newItem = new ItemStack((IItemProvider)item, amount);
                        if (amount > newItem.func_77976_d()) {
                            newItem.func_190920_e(newItem.func_77976_d());
                        }
                        if (damage != 0) {
                            newItem.func_196085_b(damage);
                        }
                        this.cost.add(newItem);
                        if (this.cost.size() >= 4) {
                            this.field_230705_e_.remove(this.addItem);
                        }
                    }
                }
            } else if (id >= 5 && id <= 8) {
                int deleteButtonIndex = id - 5;
                if (this.cost.size() > deleteButtonIndex) {
                    this.cost.remove(deleteButtonIndex);
                    for (Button deleteCostButton : this.deleteCost) {
                        this.field_230705_e_.remove(deleteCostButton);
                    }
                    if (!this.field_230705_e_.contains(this.addItem)) {
                        this.field_230705_e_.add(this.addItem);
                    }
                }
            } else if (id == 9) {
                NetworkHelper.sendToServer(new DeleteTrainerPacket(this.tutor.getNPCID()));
                ScreenHelper.closeScreen();
            } else if (id == 10) {
                this.cost = null;
                this.selectedMove = -1;
                this.field_230705_e_.remove(this.addItem);
                this.field_230705_e_.remove(this.okayButton);
                this.field_230705_e_.remove(this.deleteMove);
                this.field_230705_e_.remove(this.newItem);
                this.field_230705_e_.remove(this.newItemDamage);
                this.field_230705_e_.remove(this.newItemAmount);
                for (Button deleteCostButton : this.deleteCost) {
                    this.field_230705_e_.remove(deleteCostButton);
                }
                this.field_230705_e_.addAll(Arrays.asList(this.learnTypeButtons));
            } else if (id >= 11 && id <= 11 + this.learnTypeButtons.length) {
                int index = id - 11;
                if (this.learnTypeButtons[index].func_230458_i_().getString().equals("X")) {
                    this.learnTypeButtons[index].func_238482_a_((ITextComponent)new StringTextComponent("0"));
                    learnTypes.add(BaseStatsLearnType.GEN8_DEFAULT[index]);
                } else {
                    this.learnTypeButtons[index].func_238482_a_((ITextComponent)new StringTextComponent("X"));
                    learnTypes.remove((Object)BaseStatsLearnType.GEN8_DEFAULT[index]);
                }
            }
        }
    }

    @Override
    public boolean func_231177_au__() {
        return false;
    }

    private void saveFields() {
        if (!TutorScreen.moveList.isEmpty()) {
            if (this.tutor != null) {
                NetworkHelper.sendToServer(new StoreTutorDataPacket(this.tutor.func_145782_y(), TutorScreen.moveList, learnTypes));
                this.textureEditor.saveCustomTexture();
            }
            ScreenHelper.closeScreen();
        }
    }

    public boolean func_231046_a_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        if (p_231046_1_ == 256 && this.func_231178_ax__()) {
            this.func_231175_as__();
            return true;
        }
        return this.func_241217_q_() != null && this.func_241217_q_().func_231046_a_(p_231046_1_, p_231046_2_, p_231046_3_);
    }
}

