/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.npc;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.chooseMoveset.ClickableElement;
import com.pixelmonmod.pixelmon.client.gui.chooseMoveset.MoveListScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.comm.packetHandlers.NPCTeachMovePacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCRelearner;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class RelearnerScreen
extends Screen
implements ClickableElement<Attack> {
    Pokemon pokemon;
    NPCRelearner relearner;
    ItemStack cost;
    public static List<Attack> attackList;
    int listTop;
    int listLeft;
    int listHeight;
    int listWidth;
    MoveListScreen attackListGui;

    public RelearnerScreen(Pokemon pokemon) {
        super(StringTextComponent.field_240750_d_);
        Optional<NPCRelearner> entityNPCOptional = NPCEntity.locateNPCClient((World)Minecraft.func_71410_x().field_71441_e, ServerStorageDisplay.npcInteractID, NPCRelearner.class);
        if (!entityNPCOptional.isPresent()) {
            ScreenHelper.closeScreen();
            return;
        }
        this.relearner = entityNPCOptional.get();
        this.cost = this.relearner.getCost();
        this.pokemon = pokemon;
        attackList = Lists.newArrayList();
        for (ImmutableAttack attack : NPCRelearner.getRelearnableMoves(pokemon)) {
            attackList.add(attack.ofMutable());
        }
        this.listHeight = 150;
        this.listWidth = 90;
        this.field_230706_i_ = Minecraft.func_71410_x();
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.listTop = this.field_230709_l_ / 2 - 62;
        this.listLeft = this.field_230708_k_ / 2 - 40;
        this.attackListGui = new MoveListScreen(this, attackList, this.listWidth, this.listHeight, this.listTop, this.listLeft, this.field_230706_i_);
        this.func_230480_a_(this.attackListGui);
        this.func_230480_a_((Widget)new IndexedButton(1, this.field_230708_k_ / 2 + 155, this.field_230709_l_ / 2 + 90, 50, 20, (ITextComponent)new TranslationTextComponent("gui.cancel.text"), this::actionPerformed));
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float mFloat) {
        ScreenHelper.drawImageQuad(Resources.cwPanel, matrix, 2.0f, 2.0f, (float)this.field_230708_k_ - 6.0f, (float)this.field_230709_l_ - 6.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.75f, 0.0f);
        RenderHelper.func_74518_a();
        String text = I18n.func_135052_a((String)"gui.choosemoveset.relearnmove", (Object[])new Object[0]);
        this.field_230706_i_.field_71466_p.func_238421_b_(matrix, text, (float)this.field_230708_k_ / 2.0f - (float)this.field_230712_o_.func_78256_a(text) / 2.0f, (float)this.field_230709_l_ / 2.0f - 110.0f, 0);
        text = I18n.func_135052_a((String)"gui.choosemoveset.choosemove", (Object[])new Object[0]);
        this.field_230706_i_.field_71466_p.func_238421_b_(matrix, text, (float)this.field_230708_k_ / 2.0f - 15.0f - (float)this.field_230712_o_.func_78256_a(text) / 2.0f, (float)this.field_230709_l_ / 2.0f - 92.0f, 0);
        this.attackListGui.func_230430_a_(matrix, mouseX, mouseY, mFloat);
        ScreenHelper.drawImageQuad(this.pokemon.getSprite(), matrix, (float)this.field_230708_k_ / 2.0f - 211.0f, (float)this.field_230709_l_ / 2.0f - 98.0f, 84.0f, 84.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        ScreenHelper.drawAttackInfoBox(matrix, 0.0f, this.field_230708_k_, this.field_230709_l_);
        for (int i = 0; i < attackList.size(); ++i) {
            if (!this.attackListGui.isMouseOver(i, mouseX, mouseY)) continue;
            ScreenHelper.drawAttackInfoList(matrix, attackList.get(i), this.field_230708_k_, this.field_230709_l_);
        }
        if (this.cost != null) {
            text = I18n.func_135052_a((String)"gui.choosemoveset.cost", (Object[])new Object[0]);
            this.field_230706_i_.field_71466_p.func_238421_b_(matrix, text, (float)this.field_230708_k_ / 2.0f + 130.0f - (float)this.field_230712_o_.func_78256_a(text), (float)this.field_230709_l_ / 2.0f + 60.0f, 0);
            this.field_230707_j_.func_180450_b(this.cost, this.field_230708_k_ / 2 + 130, this.field_230709_l_ / 2 + 55);
            this.field_230707_j_.func_180453_a(this.field_230706_i_.field_71466_p, this.cost, this.field_230708_k_ / 2 + 130, this.field_230709_l_ / 2 + 55, null);
        }
        super.func_230430_a_(matrix, mouseX, mouseY, mFloat);
    }

    @Override
    public void elementClicked(List<Attack> list, int index) {
        Attack a = attackList.get(index);
        this.field_230706_i_.field_71439_g.func_71053_j();
        NetworkHelper.sendToServer(new NPCTeachMovePacket(this.pokemon.getUUID(), a.getActualMove().getAttackName(), this.relearner.getNPCID()));
    }

    public boolean func_231177_au__() {
        return false;
    }

    protected void actionPerformed(Button button) {
        this.field_230706_i_.field_71439_g.func_71053_j();
    }
}

