/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.inventory;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.inventory.InventoryPixelmon;
import com.pixelmonmod.pixelmon.client.gui.inventory.InventoryPixelmonBase;
import com.pixelmonmod.pixelmon.client.gui.inventory.tabs.PixelmonTabs;
import com.pixelmonmod.pixelmon.client.gui.inventory.tabs.SurvivalTab;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.extensions.IForgeEffectInstance;

public class InventoryPixelmonExtendedScreen
extends InventoryScreen
implements InventoryPixelmonBase {
    public static final ResourceLocation INVENTORY_LOCATION = new ResourceLocation("textures/gui/demo_background.png");
    private InventoryPixelmon inventory = new InventoryPixelmon<InventoryPixelmonExtendedScreen>(this, 42);
    private static int selectedTab = 1;

    public InventoryPixelmonExtendedScreen(PlayerEntity player) {
        super(player);
    }

    public void func_238811_b_(MatrixStack matrix) {
        matrix.func_227860_a_();
        matrix.func_227861_a_((double)(-(this.inventory.getPartyWidth() + this.inventory.getDrawerOffset())), 0.0, 0.0);
        int i = this.field_147003_i - 124;
        Collection collection = this.field_230706_i_.field_71439_g.func_70651_bq();
        if (!collection.isEmpty()) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int j = 33;
            if (collection.size() > 5) {
                j = 132 / (collection.size() - 1);
            }
            Iterable iterable = collection.stream().filter(IForgeEffectInstance::shouldRender).sorted().collect(Collectors.toList());
            this.func_238810_a_(matrix, i, j, iterable);
            this.func_238812_b_(matrix, i, j, iterable);
            this.func_238813_c_(matrix, i, j, iterable);
        }
        matrix.func_227865_b_();
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.inventory.initGui();
        selectedTab = 1;
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (selectedTab != 1) {
            this.func_230446_a_(matrix);
            this.renderTabs(matrix);
            this.renderSpecialBg(matrix, partialTicks, mouseX, mouseY);
        }
        SurvivalTab selectedTab = PixelmonTabs.getAll().stream().filter(survivalTab -> survivalTab.getId() == selectedTab).findFirst().orElse(null);
        if (InventoryPixelmonExtendedScreen.selectedTab == 1) {
            super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        } else {
            selectedTab.render(matrix, mouseX, mouseY, partialTicks);
        }
        this.inventory.render(matrix, mouseX, mouseY, partialTicks);
        this.field_230706_i_.func_110434_K().func_110577_a(ItemGroup.field_78036_m.getTabsImage());
        this.renderTabButton(matrix, selectedTab);
        if (!this.func_194310_f().func_191878_b()) {
            this.field_230706_i_.func_110434_K().func_110577_a(Resources.pixelmonOverlayExtended2);
            this.func_238474_b_(matrix, this.field_147003_i - 80, this.field_230709_l_ / 2 - 83, 0, 0, 90, 166);
            this.inventory.drawGuiContainerBackgroundLayer(matrix, partialTicks, mouseX, mouseY);
        }
        this.func_230459_a_(matrix, mouseX, mouseY);
    }

    protected void renderSpecialBg(MatrixStack p_230450_1_, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(INVENTORY_LOCATION);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_238474_b_(p_230450_1_, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    @Override
    public float getZLevel() {
        return 1.0f;
    }

    @Override
    public int getGUILeft() {
        return this.field_147003_i;
    }

    @Override
    public void offsetGUILeft(int offset) {
        this.field_147003_i += offset;
    }

    protected void func_230450_a_(MatrixStack matrix, float par1, int par2, int par3) {
        if (selectedTab == 1) {
            this.renderTabs(matrix);
        }
        if (selectedTab != 1 && this.field_147045_u) {
            this.func_238811_b_(matrix);
        }
        super.func_230450_a_(matrix, par1, par2, par3);
    }

    private void renderTabs(MatrixStack matrix) {
        for (SurvivalTab survivalTab : PixelmonTabs.getAll()) {
            if (survivalTab.getId() == selectedTab) continue;
            this.field_230706_i_.func_110434_K().func_110577_a(ItemGroup.field_78036_m.getTabsImage());
            this.renderTabButton(matrix, survivalTab);
        }
    }

    protected void renderTabButton(MatrixStack matrix, SurvivalTab tab) {
        if (tab == null) {
            return;
        }
        boolean selected = tab.getId() == selectedTab;
        boolean topRow = tab.isTopRow();
        int i = tab.getColumn();
        int j = i * 28;
        int k = 0;
        int l = this.field_147003_i + 28 * i;
        int i1 = this.field_147009_r;
        int j1 = 32;
        if (selected) {
            k += 32;
        }
        if (tab.isAlignedRight()) {
            l = this.field_147003_i + this.field_146999_f - 28 * (6 - i);
        } else if (i > 0) {
            l += i;
        }
        if (topRow) {
            i1 -= 28;
        } else {
            k += 64;
            i1 += this.field_147000_g - 4;
        }
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        this.func_238474_b_(matrix, l, i1, j, k, 28, 32);
        this.field_230707_j_.field_77023_b = 100.0f;
        i1 = i1 + 8 + (topRow ? 1 : -1);
        RenderSystem.enableRescaleNormal();
        ItemStack itemstack = tab.getIconItem();
        this.field_230707_j_.func_180450_b(itemstack, l += 6, i1);
        this.field_230707_j_.func_175030_a(this.field_230712_o_, itemstack, l, i1);
        this.field_230707_j_.field_77023_b = 0.0f;
    }

    @Override
    public List<Widget> getButtonList() {
        return this.field_230710_m_;
    }

    @Override
    public void refreshSearchResults() {
    }

    public boolean func_231044_a_(double x, double y, int mouseButton) {
        SurvivalTab selectedTab;
        if (mouseButton == 0) {
            double relativeX = x - (double)this.field_147003_i;
            double relativeY = y - (double)this.field_147009_r;
            for (SurvivalTab tab : PixelmonTabs.getAll()) {
                if (tab == null || !this.checkTabClicked(tab, relativeX, relativeY)) continue;
                return true;
            }
        }
        if ((selectedTab = (SurvivalTab)PixelmonTabs.getAll().stream().filter(survivalTab -> survivalTab.getId() == selectedTab).findFirst().orElse(null)) != null && selectedTab.mouseClicked(x, y, mouseButton)) {
            return true;
        }
        if (this.func_194310_f().func_191878_b() || this.inventory.mouseClicked(x, y, mouseButton) && this.isOutsideParty((int)x, (int)y)) {
            try {
                super.func_231044_a_(x, y, mouseButton);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return true;
    }

    protected boolean checkTabClicked(SurvivalTab tab, double x, double y) {
        if (tab.getId() == selectedTab) {
            return false;
        }
        int i = tab.getColumn();
        int j = 28 * i;
        int k = 0;
        if (tab.isAlignedRight()) {
            j = this.field_146999_f - 28 * (6 - i) + 2;
        } else if (i > 0) {
            j += i;
        }
        k = tab.isTopRow() ? (k -= 32) : (k += this.field_147000_g);
        return x >= (double)j && x <= (double)(j + 28) && y >= (double)k && y <= (double)(k + 32);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int state) {
        if (state == 0) {
            double relativeX = mouseX - (double)this.field_147003_i;
            double relativeY = mouseY - (double)this.field_147009_r;
            for (SurvivalTab tab : PixelmonTabs.getAll()) {
                if (tab == null || !this.checkTabClicked(tab, relativeX, relativeY)) continue;
                selectedTab = tab.getId();
                SurvivalTab selectedTab = PixelmonTabs.getAll().stream().filter(survivalTab -> survivalTab.getId() == selectedTab).findFirst().orElse(null);
                if (selectedTab != null) {
                    if (this.func_194310_f().func_191878_b()) {
                        this.func_194310_f().func_191866_a();
                        this.func_194310_f().func_201518_a(this.field_230708_k_ < 379);
                        this.field_147003_i = this.func_194310_f().func_193011_a(this.field_230708_k_ < 379, this.field_230708_k_, this.field_146999_f);
                    }
                    selectedTab.init();
                }
                return true;
            }
        }
        if (this.isOutsideParty((int)mouseX, (int)mouseY)) {
            return super.func_231048_c_(mouseX, mouseY, state);
        }
        return false;
    }

    private boolean isOutsideParty(int x, int y) {
        return !this.isWithinParty(x, y) && !this.isWithinLureBox(x, y);
    }

    private boolean isWithinParty(int x, int y) {
        int centerW = this.field_230708_k_ / 2;
        int centerH = this.field_230709_l_ / 2;
        return x > centerW + -128 && x < centerW + -80 && y > centerH + -84 && y < centerH + 60;
    }

    private boolean isWithinLureBox(int x, int y) {
        int centerW = this.field_230708_k_ / 2;
        int centerH = this.field_230709_l_ / 2;
        return x > centerW + -168 && x < centerW + -128 && y > centerH + -84 && y < centerH + -42;
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.inventory.tick();
    }
}

