/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.BiConsumer;
import net.minecraft.util.ResourceLocation;

public class ScreenParticleEngine {
    private final HashSet<GuiParticle> particles = new HashSet();

    public void draw(MatrixStack matrix) {
        this.particles.removeIf(particle -> ((GuiParticle)particle).draw(matrix));
    }

    public void draw(MatrixStack matrix, String caller) {
        Iterator<GuiParticle> iterator = this.particles.iterator();
        while (iterator.hasNext()) {
            GuiParticle particle = iterator.next();
            if (!particle.draw(matrix, caller)) continue;
            iterator.remove();
        }
    }

    public void drawAtOffset(MatrixStack matrix, String caller, double dx, double dy, double sdx, double sdy) {
        Iterator<GuiParticle> iterator = this.particles.iterator();
        while (iterator.hasNext()) {
            GuiParticle particle = iterator.next();
            if (!particle.draw(matrix, caller, dx, dy, sdx, sdy)) continue;
            iterator.remove();
        }
    }

    public void addParticle(GuiParticle particle) {
        this.particles.add(particle);
    }

    public static class GuiParticle {
        public ResourceLocation image;
        public double x;
        public double y;
        public double z;
        public double mX;
        public double mY;
        public double mZ;
        public float r;
        public float g;
        public float b;
        public float a;
        public float w;
        public float h;
        public int age;
        public int maxAge;
        public boolean setStaticOffsets = false;
        public double sdx;
        public double sdy;
        private final BiConsumer<GuiParticle, MatrixStack> logic;
        private final String caller;

        public GuiParticle(ResourceLocation image, double x, double y, double z, double mX, double mY, double mZ, float r, float g, float b, float a, float w, float h, int maxAge, BiConsumer<GuiParticle, MatrixStack> logic) {
            this(null, image, x, y, z, mX, mY, mZ, r, g, b, a, w, h, maxAge, logic);
        }

        public GuiParticle(String caller, ResourceLocation image, double x, double y, double z, double mX, double mY, double mZ, float r, float g, float b, float a, float w, float h, int maxAge, BiConsumer<GuiParticle, MatrixStack> logic) {
            this.caller = caller;
            this.image = image;
            this.x = x;
            this.y = y;
            this.z = z;
            this.mX = mX;
            this.mY = mY;
            this.mZ = mZ;
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
            this.w = w;
            this.h = h;
            this.age = 0;
            this.maxAge = maxAge;
            this.logic = logic;
        }

        private boolean draw(MatrixStack matrix) {
            return this.draw(matrix, null);
        }

        private boolean draw(MatrixStack matrix, String caller) {
            return this.draw(matrix, caller, 0.0, 0.0, 0.0, 0.0);
        }

        private boolean draw(MatrixStack matrix, String caller, double dx, double dy, double sdx, double sdy) {
            if (this.caller == null || this.caller.equalsIgnoreCase(caller)) {
                if (!this.setStaticOffsets) {
                    this.sdx = sdx;
                    this.sdy = sdy;
                    this.setStaticOffsets = true;
                }
                ++this.age;
                matrix.func_227860_a_();
                if (this.logic != null) {
                    this.logic.accept(this, matrix);
                }
                if (this.image != null) {
                    RenderSystem.enableBlend();
                    RenderSystem.blendFunc((int)770, (int)771);
                    ScreenHelper.drawImage(matrix, this.image, (float)(dx + this.sdx + this.x), (float)(dy + this.sdy + this.y), this.w, this.h, this.r, this.g, this.b, this.a, (float)this.z);
                }
                matrix.func_227865_b_();
                this.x += this.mX;
                this.y += this.mY;
                this.z += this.mZ;
                return this.age >= this.maxAge;
            }
            return false;
        }
    }
}

