/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.client.gui.machines.washingmachine.WashingMachineContainer;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.items.ItemStackHandler;

public class WashingMachineTileEntity
extends TileEntity
implements INamedContainerProvider {
    private int furnaceBurnTime = 0;
    private ItemStackHandler cooking = new ItemStackHandler(1);
    private ItemStackHandler cooked = new ItemStackHandler(1);

    public WashingMachineTileEntity() {
        super((TileEntityType)TileEntityRegistration.WASHING_MACHINE.get());
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_74768_a("smeltTime", this.furnaceBurnTime);
        nbt.func_218657_a("Cooking", (INBT)this.cooking.serializeNBT());
        nbt.func_218657_a("Cooked", (INBT)this.cooked.serializeNBT());
        return super.func_189515_b(nbt);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.cooking.deserializeNBT(nbt.func_74775_l("Cooking"));
        this.cooked.deserializeNBT(nbt.func_74775_l("Cooked"));
    }

    public void update() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.furnaceBurnTime;
            if (this.furnaceBurnTime >= 75) {
                this.furnaceBurnTime = 0;
                this.smeltItem();
            }
            this.func_70296_d();
        }
    }

    private boolean canSmelt() {
        if (this.cooking.getStackInSlot(0).func_190926_b()) {
            return false;
        }
        ItemStack itemstack = this.cooking.getStackInSlot(0).func_77946_l();
        if (itemstack.func_190926_b()) {
            return false;
        }
        ItemStack itemstack1 = this.cooked.getStackInSlot(0);
        ItemStack itemstack2 = itemstack.func_77946_l();
        itemstack2.func_190920_e(1);
        if (itemstack1.func_190926_b()) {
            return true;
        }
        if (itemstack1.func_77973_b() == itemstack2.func_77973_b() && itemstack1.func_77985_e()) {
            return true;
        }
        if (itemstack1.func_190916_E() + itemstack2.func_190916_E() <= this.cooked.getSlotLimit(0) && itemstack1.func_190916_E() + itemstack2.func_190916_E() <= itemstack1.func_77976_d()) {
            return true;
        }
        return itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack.func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = this.cooking.getStackInSlot(0);
            ItemStack itemstack1 = itemstack.func_77946_l();
            itemstack1.func_190920_e(1);
            itemstack1.func_196085_b(0);
            ItemStack itemstack2 = this.cooked.getStackInSlot(0);
            if (itemstack2.func_190926_b()) {
                this.cooked.setStackInSlot(0, itemstack1);
            } else if (itemstack2.func_77985_e() && itemstack2.func_77969_a(itemstack1)) {
                itemstack2.func_190917_f(itemstack1.func_190916_E());
            }
            itemstack.func_190918_g(1);
        }
    }

    private BlockState getState() {
        return this.field_145850_b.func_180495_p(this.field_174879_c);
    }

    public void add(ItemStack stack) {
        this.cooked.insertItem(0, stack, false);
    }

    public boolean isRunning() {
        return this.canSmelt();
    }

    public int getSmeltTimeRemainingScaled(int i) {
        return (int)((double)i * ((double)this.furnaceBurnTime / 120.0));
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = new CompoundNBT();
        this.func_189515_b(tag);
        return tag;
    }

    public ItemStackHandler getCooked() {
        return this.cooked;
    }

    public ItemStackHandler getCooking() {
        return this.cooking;
    }

    public int getSmeltTime() {
        return this.furnaceBurnTime;
    }

    public void setSmeltTime(int smeltTime) {
        this.furnaceBurnTime = smeltTime;
    }

    public ITextComponent func_145748_c_() {
        return StringTextComponent.field_240750_d_;
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
        return new WashingMachineContainer(id, inventory, this);
    }
}

