/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.PixelmonTradeEvent;
import com.pixelmonmod.pixelmon.api.events.PokedexEvent;
import com.pixelmonmod.pixelmon.api.events.PokemonReceivedEvent;
import com.pixelmonmod.pixelmon.api.pokedex.PokedexRegistrationStatus;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.PixelmonStatsData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trading.RegisterTraderPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trading.SetSelectedStatsPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trading.SetTradeTargetPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trading.TradeReadyPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class TradeMachineTileEntity
extends TileEntity
implements ITickableTileEntity {
    private UUID owner = null;
    public int playerCount = 0;
    public ServerPlayerEntity player1;
    public ServerPlayerEntity player2;
    public boolean ready1;
    public boolean ready2;
    public int pos1 = -1;
    public int pos2 = -1;
    public String user1 = "";
    public String user2 = "";
    public CompoundNBT poke1;
    public CompoundNBT poke2;
    private int ticks = 1;
    private boolean tradePushed = false;

    public TradeMachineTileEntity() {
        super((TileEntityType)TileEntityRegistration.TRADE_MACHINE.get());
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.owner != null) {
            compound.func_186854_a("owner", this.owner);
        }
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("owner")) {
            this.owner = compound.func_186857_a("owner");
        }
    }

    public void setColour(DyeColor dyeColor) {
        this.field_145850_b.func_180501_a(this.func_174877_v(), ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("pixelmon", dyeColor.name().toLowerCase(Locale.ROOT) + "_trade_machine"))).func_176223_P(), 3);
    }

    public UUID getOwnerUUID() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.func_70296_d();
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        nbt.func_74778_a("user1", this.player1 == null ? "" : this.player1.func_200200_C_().getString());
        nbt.func_74778_a("user2", this.player2 == null ? "" : this.player2.func_200200_C_().getString());
        nbt.func_74757_a("ready1", this.ready1);
        nbt.func_74757_a("ready2", this.ready2);
        if (this.poke1 != null) {
            nbt.func_218657_a("poke1", (INBT)this.poke1);
        }
        if (this.poke2 != null) {
            nbt.func_218657_a("poke2", (INBT)this.poke2);
        }
        return nbt;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager networkManager, SUpdateTileEntityPacket packet) {
        CompoundNBT data = packet.func_148857_g();
        this.user1 = data.func_74779_i("user1");
        this.user2 = data.func_74779_i("user2");
        this.ready1 = data.func_74767_n("ready1");
        this.ready2 = data.func_74767_n("ready2");
        this.poke1 = data.func_74764_b("poke1") ? (data.func_74775_l("poke1").isEmpty() ? null : data.func_74775_l("poke1")) : null;
        this.poke2 = data.func_74764_b("poke2") ? (data.func_74775_l("poke2").isEmpty() ? null : data.func_74775_l("poke2")) : null;
    }

    public void registerPlayer(ServerPlayerEntity player) {
        if (this.playerCount == 1 && this.player1 == player) {
            return;
        }
        ++this.playerCount;
        if (this.playerCount == 1) {
            this.player1 = player;
        } else if (this.playerCount == 2) {
            this.player2 = player;
        } else {
            return;
        }
        OpenScreenPacket.open((PlayerEntity)player, EnumGuiScreen.Trading, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        if (player == this.player2) {
            NetworkHelper.sendPacket(new RegisterTraderPacket(this.player1.func_110124_au(), this.hasMoreThan1HatchedPokemon(this.player1.func_110124_au())), this.player2);
            NetworkHelper.sendPacket(new RegisterTraderPacket(this.player2.func_110124_au(), this.hasMoreThan1HatchedPokemon(this.player2.func_110124_au())), this.player1);
            if (this.pos1 != -1) {
                PlayerPartyStorage party = StorageProxy.getParty(this.player1);
                NetworkHelper.sendPacket(new SetTradeTargetPacket(party.get(this.pos1), new PixelmonStatsData(party.get(this.pos1).getStats())), this.player2);
                NetworkHelper.sendPacket(new SetSelectedStatsPacket(new PixelmonStatsData(party.get(this.pos1).getStats())), this.player1);
            }
        }
        this.sendChanges();
    }

    public boolean ready(PlayerEntity player, boolean ready) {
        if (this.player1 != null && this.player2 != null) {
            if (player.func_110124_au().equals(this.player1.func_110124_au())) {
                this.ready1 = ready;
                NetworkHelper.sendPacket(new TradeReadyPacket(ready), this.player2);
            }
            if (player.func_110124_au().equals(this.player2.func_110124_au())) {
                this.ready2 = ready;
                NetworkHelper.sendPacket(new TradeReadyPacket(ready), this.player1);
            }
        }
        this.tradePushed = false;
        this.sendChanges();
        return false;
    }

    public void setPos1(int pos) {
        this.ready1 = false;
        this.ready2 = false;
        PlayerPartyStorage party = StorageProxy.getParty(this.player1);
        Pokemon pokemon = party.get(pos);
        if (pokemon == null || pokemon.isUntradeable()) {
            this.pos1 = -1;
            this.poke1 = null;
            this.sendChanges();
            return;
        }
        this.pos1 = pos;
        pokemon.ifEntityExists(PixelmonEntity::unloadEntity);
        this.poke1 = new CompoundNBT();
        this.poke1.func_74778_a("Name", pokemon.getSpecies().getName());
        this.poke1.func_74768_a("Level", pokemon.getPokemonLevel());
        this.poke1.func_74757_a("isEgg", pokemon.isEgg());
        this.poke1.func_74768_a("eggCycles", pokemon.getEggCycles());
        this.poke1.func_74778_a("Variant", pokemon.getForm().getName());
        this.poke1.func_74778_a("palette", pokemon.getPalette().getName());
        this.poke1.func_74778_a("CaughtBall", pokemon.getBall().getName());
        if (pokemon.getHeldItem() != ItemStack.field_190927_a) {
            this.poke1.func_218657_a("HeldItemStack", (INBT)pokemon.getHeldItem().func_77955_b(new CompoundNBT()));
        }
        this.sendChanges();
        NetworkHelper.sendPacket(new SetSelectedStatsPacket(new PixelmonStatsData(pokemon.getStats())), this.player1);
        if (this.player2 == null) {
            return;
        }
        NetworkHelper.sendPacket(new SetTradeTargetPacket(pokemon, new PixelmonStatsData(pokemon.getStats())), this.player2);
    }

    public void setPos2(int pos) {
        this.ready1 = false;
        this.ready2 = false;
        PlayerPartyStorage party = StorageProxy.getParty(this.player2);
        Pokemon pokemon = party.get(pos);
        if (pokemon == null || pokemon.isUntradeable()) {
            this.pos2 = -1;
            this.poke2 = null;
            this.sendChanges();
            return;
        }
        this.pos2 = pos;
        pokemon.ifEntityExists(PixelmonEntity::unloadEntity);
        this.poke2 = new CompoundNBT();
        this.poke2.func_74778_a("Name", pokemon.getSpecies().getName());
        this.poke2.func_74768_a("Level", pokemon.getPokemonLevel());
        this.poke2.func_74757_a("isEgg", pokemon.isEgg());
        this.poke2.func_74768_a("eggCycles", pokemon.getEggCycles());
        this.poke2.func_74778_a("Variant", pokemon.getForm().getName());
        this.poke2.func_74778_a("palette", pokemon.getPalette().getName());
        this.poke2.func_74778_a("CaughtBall", pokemon.getBall().getName());
        if (pokemon.getHeldItem() != ItemStack.field_190927_a) {
            this.poke2.func_218657_a("HeldItemStack", (INBT)pokemon.getHeldItem().func_77955_b(new CompoundNBT()));
        }
        this.sendChanges();
        NetworkHelper.sendPacket(new SetSelectedStatsPacket(new PixelmonStatsData(pokemon.getStats())), this.player2);
        if (this.player1 == null) {
            return;
        }
        NetworkHelper.sendPacket(new SetTradeTargetPacket(pokemon, new PixelmonStatsData(pokemon.getStats())), this.player1);
    }

    public void removePlayer(PlayerEntity player) {
        this.ready1 = false;
        this.ready2 = false;
        if (this.player1 == player) {
            this.player1 = this.player2;
            this.player2 = null;
            this.pos1 = this.pos2;
            this.pos2 = -1;
            this.poke1 = this.poke2;
            this.poke2 = null;
            --this.playerCount;
        } else if (this.player2 == player) {
            this.player2 = null;
            this.pos2 = -1;
            this.poke2 = null;
            --this.playerCount;
        }
        if (this.playerCount < 0) {
            this.playerCount = 0;
        }
        if (this.playerCount == 1) {
            NetworkHelper.sendPacket(new RegisterTraderPacket(null, false), this.player1);
            NetworkHelper.sendPacket(new SetTradeTargetPacket(true), this.player1);
        }
        this.sendChanges();
    }

    public void trade() {
        PokedexEvent.Pre preEvent;
        if (this.tradePushed || this.playerCount < 2 || !this.ready1 || !this.ready2) {
            return;
        }
        if (this.player1 == this.player2) {
            Pixelmon.LOGGER.warn("Self-trade detected! " + this.player1.func_200200_C_() + " is probably using hacks!");
            this.abortTrade();
            return;
        }
        PlayerPartyStorage party1 = StorageProxy.getParty(this.player1);
        PlayerPartyStorage party2 = StorageProxy.getParty(this.player2);
        party1.retrieveAll("BlockInteract");
        party2.retrieveAll("BlockInteract");
        this.tradePushed = true;
        Pokemon pokemon1 = party1.get(this.pos1);
        Pokemon pokemon2 = party2.get(this.pos2);
        if (pokemon1 == null || pokemon2 == null) {
            this.abortTrade();
            return;
        }
        if (!this.hasOtherHatchedPokemon(this.pos1, party1, pokemon2.isEgg()) || !this.hasOtherHatchedPokemon(this.pos2, party2, pokemon1.isEgg())) {
            this.abortTrade();
            return;
        }
        if (Pixelmon.EVENT_BUS.post((Event)new PixelmonTradeEvent.Pre((PlayerEntity)this.player1, (PlayerEntity)this.player2, pokemon1, pokemon2))) {
            this.abortTrade();
            return;
        }
        if (Pixelmon.EVENT_BUS.post((Event)new PokemonReceivedEvent(this.player1, pokemon2, "Trade"))) {
            return;
        }
        if (Pixelmon.EVENT_BUS.post((Event)new PokemonReceivedEvent(this.player2, pokemon1, "Trade"))) {
            return;
        }
        if (party1.playerPokedex.get(pokemon2.getSpecies().getDex()) != PokedexRegistrationStatus.CAUGHT && !Pixelmon.EVENT_BUS.post((Event)(preEvent = new PokedexEvent.Pre(this.player1.func_110124_au(), pokemon2, PokedexRegistrationStatus.CAUGHT, "tradePlayer")))) {
            party1.playerPokedex.set(preEvent.getPokemon(), preEvent.getNewStatus());
            party1.playerPokedex.update();
            Pixelmon.EVENT_BUS.post((Event)new PokedexEvent.Post(this.player1.func_110124_au(), preEvent.getOldStatus(), preEvent.getPokemon(), preEvent.getNewStatus(), preEvent.getCause()));
        }
        if (party2.playerPokedex.get(pokemon1.getSpecies().getDex()) != PokedexRegistrationStatus.CAUGHT && !Pixelmon.EVENT_BUS.post((Event)(preEvent = new PokedexEvent.Pre(this.player2.func_110124_au(), pokemon1, PokedexRegistrationStatus.CAUGHT, "tradePlayer")))) {
            party1.playerPokedex.set(preEvent.getPokemon(), preEvent.getNewStatus());
            party2.playerPokedex.update();
            Pixelmon.EVENT_BUS.post((Event)new PokedexEvent.Post(this.player2.func_110124_au(), preEvent.getOldStatus(), preEvent.getPokemon(), preEvent.getNewStatus(), preEvent.getCause()));
        }
        party1.transfer(party2, new StoragePosition(-1, this.pos2), new StoragePosition(-1, this.pos1));
        this.player1.func_71053_j();
        this.player2.func_71053_j();
        this.playerCount = 0;
        PixelmonEntity pixelmon1 = pokemon1.getOrSpawnPixelmon((Entity)this.player1);
        PixelmonEntity pixelmon2 = pokemon2.getOrSpawnPixelmon((Entity)this.player2);
        Species species1 = pokemon1.getSpecies();
        Species species2 = pokemon2.getSpecies();
        pokemon1.setFriendship(pokemon1.getForm().getSpawn().getBaseFriendship());
        if (!pixelmon1.testTradeEvolution(species2)) {
            pixelmon1.retrieve("Forced");
        }
        pokemon2.setFriendship(pokemon2.getForm().getSpawn().getBaseFriendship());
        if (!pixelmon2.testTradeEvolution(species1)) {
            pixelmon2.retrieve("Forced");
        }
        this.sendChanges();
        Pixelmon.EVENT_BUS.post((Event)new PixelmonTradeEvent.Post((PlayerEntity)this.player1, (PlayerEntity)this.player2, pokemon1, pokemon2));
    }

    public void func_73660_a() {
        if (this.player1 == null && this.playerCount > 0) {
            this.player1 = this.player2;
            this.player2 = null;
            --this.playerCount;
            this.pos2 = -1;
            this.poke2 = null;
        } else if (this.player2 == null && this.playerCount > 1) {
            --this.playerCount;
            this.pos2 = -1;
            this.poke2 = null;
        }
        if (this.playerCount == 1) {
            NetworkHelper.sendPacket(new RegisterTraderPacket(null, false), this.player1);
        }
        ++this.ticks;
        if (this.ticks % 20 == 0) {
            if (this.player1 != null && this.player1.func_193105_t()) {
                this.abortTrade();
            }
            if (this.player2 != null && this.player2.func_193105_t()) {
                this.abortTrade();
            }
            this.ticks = 0;
        }
    }

    public void sendChanges() {
        if (this.func_145830_o()) {
            ((ServerWorld)this.field_145850_b).func_72863_F().func_217217_a(this.field_174879_c);
            this.func_70296_d();
        }
    }

    private boolean hasOtherHatchedPokemon(int except, PlayerPartyStorage party, boolean isOtherAnEgg) {
        for (int i = 0; i < 6; ++i) {
            Pokemon p;
            if (i == except || (p = party.get(i)) == null || p.isEgg()) continue;
            return true;
        }
        return !isOtherAnEgg;
    }

    private boolean hasMoreThan1HatchedPokemon(UUID player) {
        if (player == null) {
            return false;
        }
        PlayerPartyStorage party1 = StorageProxy.getParty(player);
        return this.hasMoreThan1HatchedPokemon(party1);
    }

    private boolean hasMoreThan1HatchedPokemon(PlayerPartyStorage party) {
        int nonEggs = 0;
        for (int i = 0; i < 6; ++i) {
            Pokemon p = party.get(i);
            if (p != null && !p.isEgg()) {
                ++nonEggs;
            }
            if (nonEggs <= true) continue;
            return true;
        }
        return false;
    }

    private void abortTrade() {
        if (this.player1 != null) {
            this.player1.func_71053_j();
        }
        if (this.player2 != null) {
            this.player2.func_71053_j();
        }
        this.playerCount = 0;
        this.sendChanges();
    }
}

