/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.legendary.Gen2BellEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.blocks.BellBlock;
import com.pixelmonmod.pixelmon.client.particle.ParticleSystems;
import com.pixelmonmod.pixelmon.comm.packetHandlers.PlayParticleSystemPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.RotateEntityPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class BellTileEntity
extends TileEntity
implements ITickableTileEntity {
    private boolean spawning = false;
    private BellBlock.Type type;
    public UUID owner;
    private int ticks = 0;

    public BellTileEntity() {
        super((TileEntityType)TileEntityRegistration.BELL.get());
    }

    public BellTileEntity(BellBlock.Type type) {
        this();
        this.type = type;
    }

    public CompoundNBT func_189517_E_() {
        return this.serializeNBT();
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.deserializeNBT(tag);
    }

    public int getTicks() {
        return this.ticks;
    }

    public void setTicks(int ticks) {
        this.ticks = ticks;
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("BellSpawning", this.spawning);
        nbt.func_74768_a("BellType", this.type.ordinal());
        nbt.func_186854_a("BellOwner", this.owner == null ? Util.field_240973_b_ : this.owner);
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.spawning = nbt.func_74767_n("BellSpawning");
        this.type = BellBlock.Type.values()[nbt.func_74762_e("BellType")];
        UUID uuid = nbt.func_186857_a("BellOwner");
        this.owner = Objects.equals(Util.field_240973_b_, uuid) ? null : uuid;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.deserializeNBT(pkt.func_148857_g());
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    public void func_70296_d() {
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        super.func_70296_d();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            int clampedTime = (int)(this.field_145850_b.func_72820_D() % 24000L);
            if (this.spawning) {
                double d = this.field_145850_b.field_73012_v.nextDouble();
                double d2 = this.field_145850_b.func_82737_E() > 12000L ? (this.field_145850_b.func_82737_E() > 12500L ? 0.01 : 0.005) : 0.001;
                if (d < d2) {
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, (SoundEvent)SoundRegistration.BELL_RING.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            }
            if (clampedTime == 1) {
                if (!this.spawning) {
                    Gen2BellEvent.RollSuccessEvent event;
                    int count = this.countNearbyBells();
                    if (count == 0) {
                        ++count;
                    }
                    if (!Pixelmon.EVENT_BUS.post((Event)(event = new Gen2BellEvent.RollSuccessEvent(this.owner, this))) && RandomHelper.getRandomChance(event.chance * (double)count)) {
                        this.spawning = true;
                        this.func_70296_d();
                    }
                }
            } else if (clampedTime == 13000 && this.spawning) {
                ServerPlayerEntity ownerPlayer = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(this.owner);
                if (ownerPlayer == null || ownerPlayer.func_70092_e((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p()) > 4096.0) {
                    this.spawning = false;
                    this.func_70296_d();
                    return;
                }
                Pokemon pokemon = PokemonFactory.create(this.type == BellBlock.Type.TIDAL ? PixelmonSpecies.LUGIA.getValueUnsafe() : PixelmonSpecies.HOOH.getValueUnsafe());
                if (pokemon.getSpecies().is(PixelmonSpecies.HOOH)) {
                    if ((double)this.field_145850_b.field_73012_v.nextFloat() > 0.2) {
                        pokemon.setHeldItem(new ItemStack((IItemProvider)PixelmonItems.sacredash));
                    } else {
                        pokemon.setHeldItem(new ItemStack((IItemProvider)PixelmonItems.rainbow_wing));
                    }
                }
                if (this.owner != null) {
                    PlayerPartyStorage storage = StorageProxy.getParty(ownerPlayer);
                    if (ownerPlayer == null || storage.countAblePokemon() < 1 || BattleRegistry.getBattle((PlayerEntity)ownerPlayer) != null) {
                        PixelmonEntity pixelmon = pokemon.getOrCreatePixelmon(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o() - 1, (double)this.field_174879_c.func_177952_p() + 0.5);
                        Gen2BellEvent.SummonLegendary.Pre pre = new Gen2BellEvent.SummonLegendary.Pre(this.owner, this, pixelmon);
                        if (Pixelmon.EVENT_BUS.post((Event)pre)) {
                            return;
                        }
                        this.field_145850_b.func_217376_c((Entity)pixelmon);
                        Pixelmon.EVENT_BUS.post((Event)new Gen2BellEvent.SummonLegendary.Post(this.owner, this, pixelmon));
                    } else {
                        PixelmonEntity startingPixelmon = storage.findOne(Pokemon::canBattle).getOrSpawnPixelmon((Entity)ownerPlayer);
                        PixelmonEntity pixelmon = pokemon.getOrSpawnPixelmon(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o() - 1, (double)this.field_174879_c.func_177952_p() + 0.5);
                        Gen2BellEvent.SummonLegendary.Pre pre = new Gen2BellEvent.SummonLegendary.Pre(this.owner, this, pixelmon);
                        if (Pixelmon.EVENT_BUS.post((Event)pre)) {
                            return;
                        }
                        PlayerParticipant playerParticipant = new PlayerParticipant(ownerPlayer, startingPixelmon);
                        WildPixelmonParticipant wildPixelmonParticipant = new WildPixelmonParticipant(false, pre.getPixelmonEntity());
                        wildPixelmonParticipant.startedBattle = true;
                        BattleRegistry.startBattle(playerParticipant, wildPixelmonParticipant);
                        Pixelmon.EVENT_BUS.post((Event)new Gen2BellEvent.SummonLegendary.Post(ownerPlayer.func_110124_au(), this, pixelmon));
                    }
                    NetworkHelper.sendToDimension(new PlayParticleSystemPacket(ParticleSystems.DISCHARGE, (double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o() - 1, (double)this.field_174879_c.func_177952_p() + 0.5, this.field_145850_b, 0.0f, false, 0.0, 0.0, 0.0, 1.0), this.field_145850_b);
                    this.field_145850_b.func_217377_a(this.field_174879_c, false);
                    this.field_145850_b.func_175713_t(this.field_174879_c);
                }
            }
        }
    }

    private int countNearbyBells() {
        int bells = 0;
        for (TileEntity te : this.field_145850_b.field_147482_g) {
            if (!(te instanceof BellTileEntity) || te == this || !(te.func_174877_v().func_177951_i((Vector3i)this.field_174879_c) <= (double)(PixelmonConfigProxy.getSpawning().getBellInclusionRange() * PixelmonConfigProxy.getSpawning().getBellInclusionRange()))) continue;
            ++bells;
        }
        return bells;
    }

    public void spawnEntity(PixelmonEntity pixelmonEntity, double x, double y, double z, float rotation) {
        pixelmonEntity.func_70080_a(x, y, z, rotation, pixelmonEntity.field_70125_A);
        this.func_145831_w().func_217376_c((Entity)pixelmonEntity);
        NetworkHelper.sendToDimension(new RotateEntityPacket(pixelmonEntity.func_145782_y(), rotation, pixelmonEntity.field_70125_A), pixelmonEntity.field_70170_p);
        pixelmonEntity.func_213315_a(null, new Vector3d(0.1, 0.1, 0.1));
        pixelmonEntity.field_70126_B = rotation;
        pixelmonEntity.field_70177_z = rotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public boolean isSpawning() {
        return this.spawning;
    }
}

