/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.spawning;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.BattleStartTypes;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.api.events.PixelmonBlockStartingBattleEvent;
import com.pixelmonmod.pixelmon.api.events.PixelmonBlockTriggeredBattleEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.RibbonRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.IVStore;
import com.pixelmonmod.pixelmon.api.pokemon.stats.PokemonLevel;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.conditions.LocationType;
import com.pixelmonmod.pixelmon.api.spawning.util.SpatialData;
import com.pixelmonmod.pixelmon.api.spawning.util.SpawningHeightmap;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.world.MutableLocation;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractHasStatsEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumBerryFlavor;
import com.pixelmonmod.pixelmon.enums.EnumCurryRating;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.Event;

public class BlockSpawningHandler {
    private static final BlockSpawningHandler instance = new BlockSpawningHandler();

    public static BlockSpawningHandler getInstance() {
        return instance;
    }

    public void performBattleStartCheck(World world, BlockPos pos, Entity entity, PixelmonEntity entityPixelmon, BattleStartTypes startType, BlockState state, Object ... extra) {
        ServerPlayerEntity playerMP = (ServerPlayerEntity)entity;
        if (BattleRegistry.getBattle((PlayerEntity)playerMP) != null) {
            return;
        }
        PlayerPartyStorage party = StorageProxy.getParty(playerMP);
        if (party.guiOpened) {
            return;
        }
        if (Pixelmon.EVENT_BUS.post((Event)new PixelmonBlockTriggeredBattleEvent(this, world, pos, playerMP, entityPixelmon, startType))) {
            return;
        }
        if (startType == BattleStartTypes.HEADBUTT) {
            if (RandomHelper.getRandom().nextInt(100) <= 25) {
                playerMP.func_145747_a((ITextComponent)new TranslationTextComponent("pixelmon.moveskill.headbutt.nothing"), Util.field_240973_b_);
                return;
            }
            this.grabSpawns(world, pos, playerMP, startType, entityPixelmon, state, extra);
        } else if (startType == BattleStartTypes.ROCKSMASH) {
            if (RandomHelper.getRandom().nextInt(100) <= 40) {
                return;
            }
            this.grabSpawns(world, pos, playerMP, startType, entityPixelmon, state, extra);
        } else if (startType == BattleStartTypes.CURRY) {
            if (RandomHelper.getRandom().nextInt(100) <= 7) {
                return;
            }
            this.grabSpawns(world, pos, playerMP, startType, entityPixelmon, state, extra);
        } else if (startType == BattleStartTypes.FORAGE) {
            if (!RandomHelper.getRandomChance(PixelmonConfigProxy.getExternalMoves().getForageChance())) {
                playerMP.func_145747_a((ITextComponent)new TranslationTextComponent("pixelmon.moveskill.forage.nothing", new Object[]{entityPixelmon.getNickname()}), Util.field_240973_b_);
                return;
            }
            this.grabSpawns(world, pos, playerMP, startType, entityPixelmon, state, extra);
        } else {
            this.grabSpawns(world, pos, playerMP, startType, entityPixelmon, state, extra);
        }
    }

    private void grabSpawns(World worldIn, BlockPos pos, ServerPlayerEntity player, BattleStartTypes startType, PixelmonEntity fightingPokemon, BlockState state, Object ... extra) {
        AbstractHasStatsEntity pixelmon = null;
        ItemEntity item = null;
        PlayerPartyStorage party = StorageProxy.getParty(player);
        Pokemon firstAble = party.findOne(Pokemon::canBattle);
        if (firstAble == null) {
            return;
        }
        if (startType == BattleStartTypes.PUGRASSSINGLE) {
            if (PixelmonSpawning.grassSpawner != null && PixelmonSpawning.coordinator != null) {
                SpatialData data = PixelmonSpawning.grassSpawner.calculateSpatialData(worldIn, pos.func_177984_a(), 10, true, block -> true);
                SpawnLocation spawnLocation = new SpawnLocation((Entity)player, new MutableLocation(worldIn, pos), Sets.newHashSet((Object[])new LocationType[]{LocationType.GRASS}), worldIn.func_180495_p(pos).func_177230_c(), data.uniqueSurroundingBlocks, worldIn.func_226691_t_(pos), SpawningHeightmap.canSeeSky(pos, worldIn), 6, worldIn.func_201696_r(pos.func_177984_a()));
                Entity entity = PixelmonSpawning.grassSpawner.trigger(spawnLocation);
                if (entity instanceof PixelmonEntity) {
                    pixelmon = (PixelmonEntity)entity;
                }
            }
            if (pixelmon == null) {
                return;
            }
            if (PixelmonConfigProxy.getBattle().isScaleGrassBattles()) {
                int minLvl;
                int maxLvl = Math.min(party.getHighestLevel(), PixelmonServerConfig.maxLevel);
                if (maxLvl - (minLvl = party.getLowestLevel()) > 5) {
                    minLvl = maxLvl - minLvl;
                }
                PokemonLevel pokemonLevel = pixelmon.getLvl();
                if (minLvl < maxLvl) {
                    int lvl = RandomHelper.getRandom().nextInt(maxLvl - minLvl) + minLvl;
                    pokemonLevel.setLevel(lvl);
                } else {
                    pokemonLevel.setLevel(maxLvl);
                }
                pixelmon.getPokemon().getMoveset().clear();
                pixelmon.getPokemon().getMoveset().addAll(pixelmon.getForm().getMoves().loadMoveset(pokemonLevel.getPokemonLevel()));
            }
            PixelmonEntity startingPixelmon = firstAble.getOrSpawnPixelmon((Entity)player);
            this.setupBattle(worldIn, pos, player, startType, startingPixelmon, (PixelmonEntity)pixelmon);
        } else if (startType == BattleStartTypes.PUGRASSDOUBLE) {
            if (PixelmonSpawning.tallGrassSpawner != null && PixelmonSpawning.coordinator != null) {
                SpatialData data = PixelmonSpawning.tallGrassSpawner.calculateSpatialData(worldIn, pos.func_177984_a(), 10, true, block -> true);
                SpawnLocation spawnLocation = new SpawnLocation((Entity)player, new MutableLocation(worldIn, pos), Sets.newHashSet((Object[])new LocationType[]{LocationType.DOUBLE_GRASS}), worldIn.func_180495_p(pos).func_177230_c(), data.uniqueSurroundingBlocks, worldIn.func_226691_t_(pos), SpawningHeightmap.canSeeSky(pos, worldIn), 6, worldIn.func_201696_r(pos.func_177984_a()));
                Entity entity = PixelmonSpawning.tallGrassSpawner.trigger(spawnLocation);
                if (entity instanceof PixelmonEntity) {
                    pixelmon = (PixelmonEntity)entity;
                }
            }
            if (pixelmon == null) {
                return;
            }
            if (PixelmonConfigProxy.getBattle().isScaleGrassBattles()) {
                int minLvl;
                int maxLvl = Math.min(party.getHighestLevel(), PixelmonServerConfig.maxLevel);
                if (maxLvl - (minLvl = party.getLowestLevel()) > 5) {
                    minLvl = maxLvl - minLvl;
                }
                PokemonLevel pokemonLevel = pixelmon.getLvl();
                if (minLvl < maxLvl) {
                    int lvl = RandomHelper.getRandom().nextInt(maxLvl - minLvl) + minLvl;
                    pokemonLevel.setLevel(lvl);
                } else {
                    pokemonLevel.setLevel(maxLvl);
                }
                pixelmon.getPokemon().getMoveset().clear();
                pixelmon.getPokemon().getMoveset().addAll(pixelmon.getForm().getMoves().loadMoveset(pokemonLevel.getPokemonLevel()));
            }
            PixelmonEntity startingPixelmon = firstAble.getOrSpawnPixelmon((Entity)player);
            this.setupBattle(worldIn, pos, player, startType, startingPixelmon, (PixelmonEntity)pixelmon);
        } else if (startType == BattleStartTypes.CAVEROCK) {
            if (PixelmonSpawning.caveRockSpawner != null && PixelmonSpawning.coordinator != null) {
                SpatialData data = PixelmonSpawning.caveRockSpawner.calculateSpatialData(worldIn, pos.func_177984_a(), 10, true, block -> true);
                SpawnLocation spawnLocation = new SpawnLocation((Entity)player, new MutableLocation(worldIn, pos.func_177984_a()), Sets.newHashSet((Object[])new LocationType[]{LocationType.CAVE_ROCK}), worldIn.func_180495_p(pos).func_177230_c(), data.uniqueSurroundingBlocks, worldIn.func_226691_t_(pos), SpawningHeightmap.canSeeSky(pos, worldIn), 6, worldIn.func_201696_r(pos.func_177984_a()));
                Entity entity = PixelmonSpawning.caveRockSpawner.trigger(spawnLocation);
                if (entity instanceof PixelmonEntity) {
                    pixelmon = (PixelmonEntity)entity;
                }
            }
            if (pixelmon == null) {
                return;
            }
            if (PixelmonConfigProxy.getBattle().isScaleGrassBattles()) {
                int minLvl;
                int maxLvl = Math.min(party.getHighestLevel(), PixelmonServerConfig.maxLevel);
                if (maxLvl - (minLvl = party.getLowestLevel()) > 5) {
                    minLvl = maxLvl - minLvl;
                }
                PokemonLevel pokemonLevel = pixelmon.getLvl();
                if (minLvl < maxLvl) {
                    int lvl = RandomHelper.getRandom().nextInt(maxLvl - minLvl) + minLvl;
                    pokemonLevel.setLevel(lvl);
                } else {
                    pokemonLevel.setLevel(maxLvl);
                }
                pixelmon.getPokemon().getMoveset().clear();
                pixelmon.getPokemon().getMoveset().addAll(pixelmon.getForm().getMoves().loadMoveset(pokemonLevel.getPokemonLevel()));
            }
            PixelmonEntity startingPixelmon = firstAble.getOrSpawnPixelmon((Entity)player);
            this.setupBattle(worldIn, pos.func_177984_a(), player, startType, startingPixelmon, (PixelmonEntity)pixelmon);
        } else if (startType == BattleStartTypes.HEADBUTT) {
            if (PixelmonSpawning.headbuttSpawner != null && PixelmonSpawning.coordinator != null) {
                SpatialData data = PixelmonSpawning.headbuttSpawner.calculateSpatialData(worldIn, pos.func_177984_a(), 10, true, block -> true);
                data.baseBlock = worldIn.func_180495_p(pos).func_177230_c();
                SpawnLocation spawnLocation = new SpawnLocation((Entity)player, new MutableLocation(worldIn, pos), Sets.newHashSet((Object[])new LocationType[]{LocationType.HEADBUTT}), worldIn.func_180495_p(pos).func_177230_c(), data.uniqueSurroundingBlocks, worldIn.func_226691_t_(pos), SpawningHeightmap.canSeeSky(pos, worldIn), 6, worldIn.func_201696_r(pos.func_177984_a()));
                Entity entity = PixelmonSpawning.headbuttSpawner.trigger(spawnLocation);
                if (entity instanceof PixelmonEntity) {
                    pixelmon = (PixelmonEntity)entity;
                } else if (entity instanceof ItemEntity) {
                    item = (ItemEntity)entity;
                }
            }
            if (pixelmon != null) {
                this.setupBattle(worldIn, pos, player, startType, fightingPokemon, (PixelmonEntity)pixelmon);
                player.func_145747_a((ITextComponent)new TranslationTextComponent("pixelmon.moveskill.headbutt.battle", new Object[]{pixelmon.getLocalizedName()}), Util.field_240973_b_);
            } else if (item != null) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("pixelmon.moveskill.headbutt.item", new Object[]{item.func_92059_d().func_77973_b().func_200295_i(item.func_92059_d())}), Util.field_240973_b_);
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("pixelmon.moveskill.headbutt.nothing"), Util.field_240973_b_);
            }
        } else if (startType == BattleStartTypes.ROCKSMASH) {
            if (PixelmonSpawning.rocksmashSpawner != null && PixelmonSpawning.coordinator != null) {
                SpatialData data = PixelmonSpawning.rocksmashSpawner.calculateSpatialData(worldIn, pos.func_177984_a(), 10, true, block -> true);
                data.baseBlock = state.func_177230_c();
                SpawnLocation spawnLocation = new SpawnLocation((Entity)player, new MutableLocation(worldIn, pos), Sets.newHashSet((Object[])new LocationType[]{LocationType.ROCK_SMASH}), data.baseBlock, data.uniqueSurroundingBlocks, worldIn.func_226691_t_(pos), SpawningHeightmap.canSeeSky(pos, worldIn), 10, worldIn.func_201696_r(pos.func_177984_a()));
                Entity entity = PixelmonSpawning.rocksmashSpawner.trigger(spawnLocation);
                if (entity instanceof PixelmonEntity) {
                    pixelmon = (PixelmonEntity)entity;
                }
            }
            if (pixelmon != null) {
                this.setupBattle(worldIn, pos, player, startType, fightingPokemon, (PixelmonEntity)pixelmon);
            }
        } else if (startType == BattleStartTypes.SWEETSCENT) {
            if (PixelmonSpawning.sweetscentSpawner != null && PixelmonSpawning.coordinator != null) {
                SpatialData data = PixelmonSpawning.sweetscentSpawner.calculateSpatialData(worldIn, pos.func_177984_a(), 10, true, block -> true);
                SpawnLocation spawnLocation = new SpawnLocation((Entity)player, new MutableLocation(worldIn, pos), Sets.newHashSet((Object[])new LocationType[]{LocationType.SWEET_SCENT}), worldIn.func_180495_p(pos).func_177230_c(), data.uniqueSurroundingBlocks, worldIn.func_226691_t_(pos), SpawningHeightmap.canSeeSky(pos, worldIn), 6, worldIn.func_201696_r(pos.func_177984_a()));
                Entity entity = PixelmonSpawning.sweetscentSpawner.trigger(spawnLocation);
                if (entity instanceof PixelmonEntity) {
                    pixelmon = (PixelmonEntity)entity;
                }
                if (pixelmon != null) {
                    this.setupBattle(worldIn, pos, player, startType, fightingPokemon, (PixelmonEntity)pixelmon);
                }
            }
        } else if (startType == BattleStartTypes.CURRY) {
            if (PixelmonSpawning.currySpawner != null && PixelmonSpawning.coordinator != null) {
                SpawnLocation spawnLocation;
                Entity entity;
                SpatialData data = PixelmonSpawning.currySpawner.calculateSpatialData(worldIn, pos.func_177984_a(), 10, true, block -> true);
                LocationType type = LocationType.CURRY_NONE;
                if (extra != null && extra[0] instanceof EnumBerryFlavor) {
                    switch ((EnumBerryFlavor)((Object)extra[0])) {
                        case SPICY: {
                            type = LocationType.CURRY_SPICY;
                            break;
                        }
                        case DRY: {
                            type = LocationType.CURRY_DRY;
                            break;
                        }
                        case SWEET: {
                            type = LocationType.CURRY_SWEET;
                            break;
                        }
                        case BITTER: {
                            type = LocationType.CURRY_BITTER;
                            break;
                        }
                        case SOUR: {
                            type = LocationType.CURRY_SOUR;
                        }
                    }
                }
                if ((entity = PixelmonSpawning.currySpawner.trigger(spawnLocation = new SpawnLocation((Entity)player, new MutableLocation(worldIn, pos), Sets.newHashSet((Object[])new LocationType[]{type}), worldIn.func_180495_p(pos).func_177230_c(), data.uniqueSurroundingBlocks, worldIn.func_226691_t_(pos), SpawningHeightmap.canSeeSky(pos, worldIn), 6, worldIn.func_201696_r(pos.func_177984_a())))) instanceof PixelmonEntity) {
                    pixelmon = (PixelmonEntity)entity;
                }
                if (pixelmon != null) {
                    if (extra != null && extra.length >= 2) {
                        EnumCurryRating rating = (EnumCurryRating)((Object)extra[1]);
                        IVStore ivs = pixelmon.getPokemon().getIVs();
                        switch (rating) {
                            case KOFFING: {
                                for (BattleStatsType t : BattleStatsType.values()) {
                                    ivs.setStat(t, RandomHelper.getRandomNumberBetween(0, 15));
                                }
                                break;
                            }
                            case MILCERY: {
                                for (int i : RandomHelper.getRandomDistinctNumbersBetween(0, 5, 1)) {
                                    ivs.setStat(BattleStatsType.values()[i], 31);
                                }
                                break;
                            }
                            case COPPERAJAH: {
                                for (int i : RandomHelper.getRandomDistinctNumbersBetween(0, 5, 2)) {
                                    ivs.setStat(BattleStatsType.values()[i], 31);
                                }
                                break;
                            }
                            case CHARIZARD: {
                                for (int i : RandomHelper.getRandomDistinctNumbersBetween(0, 5, 3)) {
                                    ivs.setStat(BattleStatsType.values()[i], 31);
                                }
                                break;
                            }
                        }
                    }
                    pixelmon.getPokemon().addRibbon(RibbonRegistry.CURRY.getValueUnsafe());
                }
            }
        } else if (startType == BattleStartTypes.FORAGE && PixelmonSpawning.forageSpawner != null && PixelmonSpawning.coordinator != null) {
            BlockPos up = pos.func_177984_a();
            SpatialData data = PixelmonSpawning.forageSpawner.calculateSpatialData(worldIn, up, 10, true, block -> true);
            data.baseBlock = worldIn.func_180495_p(pos).func_177230_c();
            SpawnLocation spawnLocation = new SpawnLocation((Entity)player, new MutableLocation(worldIn, pos), Sets.newHashSet((Object[])new LocationType[]{LocationType.FORAGE}), worldIn.func_180495_p(pos).func_177230_c(), data.uniqueSurroundingBlocks, worldIn.func_226691_t_(pos), SpawningHeightmap.canSeeSky(up, worldIn), 6, worldIn.func_201696_r(up));
            Entity entity = PixelmonSpawning.forageSpawner.trigger(spawnLocation);
            if (entity instanceof PixelmonEntity) {
                pixelmon = (PixelmonEntity)entity;
            }
            if (pixelmon != null) {
                this.setupBattle(worldIn, pos, player, startType, fightingPokemon, (PixelmonEntity)pixelmon);
            }
        }
    }

    private void setupBattle(World worldIn, BlockPos pos, ServerPlayerEntity player, BattleStartTypes startType, PixelmonEntity fightingPokemon, PixelmonEntity pixelmon) {
        PlayerParticipant playerParticipant = new PlayerParticipant(player, fightingPokemon);
        WildPixelmonParticipant wildPixelmonParticipant = new WildPixelmonParticipant(true, pixelmon);
        if (pixelmon == null || Pixelmon.EVENT_BUS.post((Event)new PixelmonBlockStartingBattleEvent(worldIn, pos, player, startType, fightingPokemon, pixelmon, null))) {
            return;
        }
        wildPixelmonParticipant.startedBattle = true;
        BattleRegistry.startBattle(playerParticipant, wildPixelmonParticipant);
    }
}

