/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.machines;

import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.blocks.GenericRotatableModelBlock;
import com.pixelmonmod.pixelmon.blocks.enums.EnumBlockPos;
import com.pixelmonmod.pixelmon.blocks.tileentity.TimespaceAltarTileEntity;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TimespaceAltarBlock
extends GenericRotatableModelBlock {
    public static final EnumProperty<EnumBlockPos> BLOCKPOS = EnumProperty.func_177709_a((String)"blockpos", EnumBlockPos.class);
    public static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)30.0, (double)16.0);

    public TimespaceAltarBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_226896_b_().func_200948_a(-1.0f, 6000000.0f).func_200944_c());
    }

    public VoxelShape func_220071_b(BlockState p_220071_1_, IBlockReader p_220071_2_, BlockPos p_220071_3_, ISelectionContext p_220071_4_) {
        return SHAPE;
    }

    public VoxelShape func_199600_g(BlockState p_199600_1_, IBlockReader p_199600_2_, BlockPos p_199600_3_) {
        return SHAPE;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{BLOCKPOS});
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        if (state.func_177229_b(BLOCKPOS) == EnumBlockPos.BOTTOM) {
            return new TimespaceAltarTileEntity();
        }
        return null;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TimespaceAltarTileEntity tile;
        ItemStack heldItem = player.func_184586_b(hand);
        if (world.field_72995_K || hand == Hand.OFF_HAND) {
            return ActionResultType.SUCCESS;
        }
        if (state.func_177229_b(BLOCKPOS) == EnumBlockPos.TOP) {
            pos = pos.func_177977_b();
        }
        if ((tile = BlockHelper.getTileEntity(TimespaceAltarTileEntity.class, (IBlockReader)world, pos)) != null) {
            if (!heldItem.func_190926_b() && heldItem.func_77973_b() == PixelmonItems.red_chain && tile.chainIn) {
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.timespace.alreadychain", new Object[0]);
                return ActionResultType.FAIL;
            }
            tile.activate(player, this, state, heldItem);
        }
        return player.func_184812_l_() ? ActionResultType.SUCCESS : ActionResultType.FAIL;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f())).func_206870_a(BLOCKPOS, (Comparable)((Object)EnumBlockPos.BOTTOM));
    }

    @Override
    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState p_220080_1_, IBlockReader p_220080_2_, BlockPos p_220080_3_) {
        return 1.0f;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return 1;
    }
}

