/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.PokemonReceivedEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.DropItemHelper;
import com.pixelmonmod.pixelmon.blocks.IBlockHasOwner;
import com.pixelmonmod.pixelmon.blocks.enums.EnumPokechestVisibility;
import com.pixelmonmod.pixelmon.blocks.tileentity.EnumPokegiftType;
import com.pixelmonmod.pixelmon.blocks.tileentity.PokeGiftTileEntity;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class PokeGiftBlock
extends ContainerBlock
implements IBlockHasOwner {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    private static final AxisAlignedBB AABB = new AxisAlignedBB((double)0.29f, 0.0, (double)0.29f, (double)0.72f, (double)0.44f, (double)0.72f);
    protected String itemName = "item.pixelmon.pokeGift";
    protected double xVel = 0.1;
    protected double yVel = 0.2;
    protected double zVel = 0.1;
    protected EnumPokegiftType type;

    public PokeGiftBlock(EnumPokegiftType type) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200943_b(1.0f));
        this.type = type;
        this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH);
    }

    public PokeGiftBlock() {
        this(EnumPokegiftType.GIFT);
    }

    public BlockState func_185499_a(BlockState p_185499_1_, Rotation p_185499_2_) {
        return (BlockState)p_185499_1_.func_206870_a((Property)FACING, (Comparable)p_185499_2_.func_185831_a((Direction)p_185499_1_.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING});
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K || hand == Hand.OFF_HAND) {
            return ActionResultType.SUCCESS;
        }
        PokeGiftTileEntity tile = BlockHelper.getTileEntity(PokeGiftTileEntity.class, (IBlockReader)worldIn, pos);
        if (tile == null) {
            return ActionResultType.SUCCESS;
        }
        if (!Objects.equals(player.func_110124_au(), tile.getOwner())) {
            if (!tile.canClaim(player.func_110124_au())) {
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.claimedloot", new Object[0]);
                return ActionResultType.SUCCESS;
            }
            if (tile.shouldBreakBlock()) {
                if (MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(worldIn, pos, state, player))) {
                    return ActionResultType.SUCCESS;
                }
                worldIn.func_217377_a(pos, false);
                if (worldIn.func_180495_p(pos).func_177230_c() == this) {
                    return ActionResultType.SUCCESS;
                }
            }
            if (tile.getPokemon() == null) {
                ChatHandler.sendChat((Entity)player, "pixelutilities.blocks.emptygift", new TranslationTextComponent(this.itemName));
                worldIn.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187576_at, SoundCategory.BLOCKS, 0.8f, 1.0f);
                return ActionResultType.SUCCESS;
            }
            if (tile.getPokemon().hasFlag("untradeable")) {
                ChatHandler.sendChat((Entity)player, "pixelutilities.blocks.untradablegift", new Object[0]);
                return ActionResultType.SUCCESS;
            }
            ChatHandler.sendChat((Entity)player, "pixelmon.blocks.chestfound", new TranslationTextComponent(this.itemName));
            PlayerPartyStorage party = StorageProxy.getParty((ServerPlayerEntity)player);
            if (Pixelmon.EVENT_BUS.post((Event)new PokemonReceivedEvent((ServerPlayerEntity)player, tile.getPokemon(), "PokeBall"))) {
                return ActionResultType.SUCCESS;
            }
            Pokemon pokemon = tile.getPokemon();
            pokemon.setUUID(UUID.randomUUID());
            party.add(pokemon);
            tile.addClaimer(player.func_110124_au());
            worldIn.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (SoundEvent)SoundRegistration.POKELOOT_OBTAINED.get(), SoundCategory.BLOCKS, 0.2f, 1.0f);
        } else {
            if (player.func_225608_bj_()) {
                if (tile.getPokemon() != null && player.func_184812_l_()) {
                    tile.setOwner(null);
                    ChatHandler.sendChat((Entity)player, "pixelmon.blocks.ownerchanged", new Object[0]);
                    return ActionResultType.SUCCESS;
                }
                if (player.func_184812_l_()) {
                    ChatHandler.sendChat((Entity)player, "pixelmon.blocks.fillmefirst", new Object[0]);
                }
                return ActionResultType.FAIL;
            }
            ServerPlayerEntity playerMP = (ServerPlayerEntity)player;
            Pokemon pokemon = tile.getPokemon();
            if (pokemon != null) {
                if (!player.func_184812_l_()) {
                    ChatHandler.sendChat((Entity)player, "pixelmon.blocks.alreadyfilled", new Object[0]);
                    return ActionResultType.SUCCESS;
                }
                String mode = "";
                if (tile.getChestMode() && tile.getDropMode()) {
                    tile.setChestOneTime(false);
                    tile.setDropOneTime(true);
                    mode = "pixelmon.blocks.chestmodePL1D";
                } else {
                    tile.setDropOneTime(true);
                    tile.setChestOneTime(true);
                    mode = "pixelmon.blocks.chestmodeFCFS";
                }
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.chestmode", new TranslationTextComponent(mode));
                return ActionResultType.SUCCESS;
            }
            PlayerPartyStorage party = StorageProxy.getParty(playerMP);
            if (party.inTemporaryMode()) {
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.intemporarymode", new Object[0]);
                return ActionResultType.FAIL;
            }
            if (party.countPokemon() <= 1) {
                ChatHandler.sendChat((Entity)playerMP, "pixelmon.blocks.lastpoke", new Object[0]);
                return ActionResultType.FAIL;
            }
            Pokemon firstPokeinWorld = null;
            for (int i = 0; i < 6; ++i) {
                Pokemon partypoke = party.get(i);
                if (partypoke == null || !partypoke.getPixelmonEntity().isPresent()) continue;
                firstPokeinWorld = partypoke;
                break;
            }
            if (firstPokeinWorld == null) {
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.nothingtoadd", new Object[0]);
                return ActionResultType.FAIL;
            }
            firstPokeinWorld.ifEntityExists(pixelmonEntity -> pixelmonEntity.retrieve("Forced"));
            int position = party.getPosition((Pokemon)firstPokeinWorld).order;
            party.set(position, null);
            firstPokeinWorld.setStorage(null, null);
            tile.setPokemon(firstPokeinWorld);
        }
        return ActionResultType.SUCCESS;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f());
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
        PokeGiftTileEntity tile = (PokeGiftTileEntity)worldIn.func_175625_s(pos);
        if (tile.getOwner() == null || Objects.equals(tile.getOwner(), player.func_110124_au())) {
            return super.func_180647_a(state, player, worldIn, pos);
        }
        return -1.0f;
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (!world.field_72995_K) {
            PokeGiftTileEntity tile = BlockHelper.getTileEntity(PokeGiftTileEntity.class, (IBlockReader)world, pos);
            Pokemon pokemon = tile.getPokemon();
            if (pokemon != null && tile.getOwner() != null) {
                PlayerPartyStorage storage = StorageProxy.getParty(tile.getOwner());
                pokemon.setUUID(UUID.randomUUID());
                storage.add(pokemon);
            } else {
                DropItemHelper.giveItemStack((ServerPlayerEntity)player, new ItemStack((IItemProvider)PixelmonBlocks.poke_gift), false);
            }
            return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
        }
        return false;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new PokeGiftTileEntity();
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        PokeGiftTileEntity tile = BlockHelper.getTileEntity(PokeGiftTileEntity.class, (IBlockReader)world, pos);
        if (tile.getVisibility() == EnumPokechestVisibility.Hidden) {
            float rand = random.nextFloat() * 0.5f + 1.0f;
            world.func_195598_a((IParticleData)ParticleTypes.field_197590_A, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 1, this.xVel * (double)rand, this.yVel * (double)rand, this.zVel * (double)rand, 0.05);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197881_a((AxisAlignedBB)AABB);
    }

    @Override
    public void setOwner(BlockPos pos, PlayerEntity playerIn) {
        PokeGiftTileEntity tile = BlockHelper.getTileEntity(PokeGiftTileEntity.class, (IBlockReader)playerIn.field_70170_p, pos);
        tile.setOwner(playerIn.func_110124_au());
        if (PixelmonConfigProxy.getGeneral().isPokeGiftReusable()) {
            tile.setChestOneTime(false);
        }
    }
}

