/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.List;

public class MagnetRise
extends StatusBase {
    private transient int duration = 5;

    public MagnetRise() {
        super(StatusType.MagnetRise);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.hasStatus(StatusType.MagnetRise, StatusType.Ingrain) || user.bc.globalStatusController.hasStatus(StatusType.Gravity)) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            user.attack.moveResult.result = AttackResult.failed;
        } else if (user.addStatus(new MagnetRise(), user)) {
            user.bc.sendToAll("pixelmon.effect.magnetrise", user.getNickname());
        }
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        if (--this.duration <= 0) {
            pw.bc.sendToAll("pixelmon.status.magicroomend", new Object[0]);
            pw.removeStatus(this);
        }
    }

    @Override
    public boolean stopsIncomingAttack(PixelmonWrapper pokemon, PixelmonWrapper user) {
        return user.attack.getType() == Element.GROUND && !user.attack.isAttack(AttackRegistry.SAND_ATTACK, AttackRegistry.THOUSAND_ARROWS) && !pokemon.isGrounded();
    }

    @Override
    public void stopsIncomingAttackMessage(PixelmonWrapper pokemon, PixelmonWrapper user) {
        user.bc.sendToAll("pixelmon.battletext.noeffect", pokemon.getNickname());
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        if (MoveChoice.hasOffensiveAttackType(MoveChoice.getTargetedChoices(pw, bestOpponentChoices), Element.GROUND)) {
            userChoice.raiseWeight(30.0f);
        }
    }
}

