/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.multiTurn;

import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.multiTurn.MultiTurnSpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Confusion;
import java.util.List;
import net.minecraft.util.text.TranslationTextComponent;

public class PetalDance
extends MultiTurnSpecialAttackBase {
    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        if (!this.doesPersist(user)) {
            this.setPersists(user, true);
            this.setTurnCount(user, RandomHelper.getRandomNumberBetween(2, 3));
        }
        this.decrementTurnCount(user);
        if (this.getTurnCount(user) == 0) {
            this.setPersists(user, false);
            TranslationTextComponent message = new TranslationTextComponent("pixelmon.effect.thrash", new Object[]{user.getNickname()});
            user.addStatus(new Confusion(), user, message);
        }
        return AttackResult.proceed;
    }

    @Override
    public void applyMissEffect(PixelmonWrapper user, PixelmonWrapper target) {
        this.setPersists(user, false);
    }

    @Override
    public void removeEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (this.getTurnCount(user) == 0 && this.doesPersist(user) && user.addStatus(new Confusion(), user)) {
            user.bc.sendToAll("pixelmon.effect.thrash", user.getNickname());
        }
        this.setPersists(user, false);
    }

    @Override
    public boolean shouldNotLosePP(PixelmonWrapper user) {
        return this.doesPersist(user);
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        if (userChoice.tier >= 3) {
            userChoice.weight /= 2.0f;
        }
    }
}

