/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import java.util.List;

public class Rototiller
extends SpecialAttackBase {
    private static final transient BattleStatsType[] raiseStats = new BattleStatsType[]{BattleStatsType.ATTACK, BattleStatsType.SPECIAL_ATTACK};

    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.targetIndex > 0) {
            return AttackResult.succeeded;
        }
        boolean succeeded = false;
        for (PixelmonWrapper pw : user.bc.getActiveUnfaintedPokemon()) {
            if (pw.isAirborne() || !pw.hasType(Element.GRASS)) continue;
            pw.getBattleStats().modifyStat(1, raiseStats);
            succeeded = true;
        }
        if (succeeded) {
            return AttackResult.succeeded;
        }
        user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
        return AttackResult.failed;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        for (PixelmonWrapper pokemon : pw.bc.getActiveUnfaintedPokemon()) {
            if (pw.isAirborne()) continue;
            int weight = 25;
            if (!pw.isSameTeam(pokemon)) {
                weight = -weight;
            }
            userChoice.raiseWeight(weight);
        }
    }
}

