/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.LiquidOoze;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.attacks.Value;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.util.List;

public class Drain
extends SpecialAttackBase {
    int drainPercent;

    public Drain(Value ... values) {
        this.drainPercent = values[0].value;
    }

    @Override
    public void dealtDamage(PixelmonWrapper user, PixelmonWrapper target, Attack attack, DamageTypeEnum damageType) {
        if (user == null || user.attack == null || user.attack.moveResult == null || user == target) {
            return;
        }
        int restoration = this.getRestoration(user.attack.moveResult.damage, user, target);
        if (restoration > 0) {
            if (target.getBattleAbility() instanceof LiquidOoze) {
                user.bc.sendToAll("pixelmon.abilities.liquidooze", user.getNickname());
                user.doBattleDamage(target, restoration, DamageTypeEnum.ABILITY);
            } else if (!user.hasFullHealth() && !user.hasStatus(StatusType.HealBlock)) {
                user.bc.sendToAll("pixelmon.effect.regainedenergy", user.getNickname());
                user.healEntityBy(restoration);
            }
        }
    }

    private int getRestoration(float damage, PixelmonWrapper user, PixelmonWrapper target) {
        int restoration = 0;
        if (damage > 0.0f && user.isAlive()) {
            restoration = Math.max(1, (int)damage * this.drainPercent / 100);
            if (user.getUsableHeldItem().getHeldItemType() == EnumHeldItems.bigRoot) {
                restoration = (int)((double)restoration * 1.3);
            }
        }
        return restoration;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        if (userChoice.hitsAlly()) {
            return;
        }
        for (PixelmonWrapper target : userChoice.targets) {
            int restoration = this.getRestoration(userChoice.result.damage, pw, target);
            if (restoration <= 0) continue;
            float restorePercent = pw.getHealthPercent(restoration);
            if (target.getBattleAbility() instanceof LiquidOoze) {
                userChoice.weight -= restorePercent;
                continue;
            }
            if (pw.hasStatus(StatusType.HealBlock)) continue;
            float healthDeficit = pw.getHealthDeficit();
            if (healthDeficit < (float)restoration) {
                restorePercent = pw.getHealthPercent(healthDeficit);
            }
            userChoice.raiseWeight(restorePercent);
        }
    }
}

