/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.StatsEffect;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Cursed;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.List;

public class Curse
extends SpecialAttackBase {
    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.hasType(Element.GHOST)) {
            if (user == target && (target = RandomHelper.getRandomElementFromList(user.getOpponentPokemon())) == null) {
                return AttackResult.notarget;
            }
            if (target.hasStatus(StatusType.Cursed)) {
                user.bc.sendToAll("attack.curse.alreadycursed", target.getNickname());
                return AttackResult.failed;
            }
            if (target.addStatus(new Cursed(), user)) {
                user.bc.sendToAll("attack.curse.curse", user.getNickname(), target.getNickname());
                user.doBattleDamage(user, user.getPercentMaxHealth(50.0f), DamageTypeEnum.STATUS);
                return AttackResult.succeeded;
            }
        } else {
            user.getBattleStats().modifyStat(new int[]{1, 1, -1}, new BattleStatsType[]{BattleStatsType.ATTACK, BattleStatsType.DEFENSE, BattleStatsType.SPEED});
            return AttackResult.succeeded;
        }
        return AttackResult.failed;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        if (pw.hasType(Element.GHOST)) {
            if (!userChoice.hitsAlly() && !(MoveChoice.getMaxDamagePercent(pw, bestOpponentChoices) > pw.getHealthPercent() - 50.0f)) {
                userChoice.raiseWeight(40.0f);
            }
        } else {
            StatsEffect attackBoost = new StatsEffect(BattleStatsType.ATTACK, 1, true);
            StatsEffect defenseBoost = new StatsEffect(BattleStatsType.DEFENSE, 1, true);
            attackBoost.weightEffect(pw, userChoice, userChoices, bestUserChoices, opponentChoices, bestOpponentChoices);
            defenseBoost.weightEffect(pw, userChoice, userChoices, bestUserChoices, opponentChoices, bestOpponentChoices);
        }
    }
}

