/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.animations.particles;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.attacks.animations.StandardParticleAnimationData;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.AttackSystem;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.EffectType;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.ParticleMathHelper;
import com.pixelmonmod.pixelmon.client.particle.particles.AttackEffect;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AttackRain
extends AttackSystem<RainData> {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void execute(Minecraft mc, World w, double x, double y, double z, float scale, boolean shiny, double ... args) {
        float height = ((RainData)this.getData()).getHeightAboveTarget();
        PixelmonEntity pixelmon = (PixelmonEntity)w.func_73045_a(this.getEndID());
        height += pixelmon == null ? 2.0f : pixelmon.func_213302_cg();
        int particlesPerWave = Math.round(1.0f * (float)((RainData)this.getData()).getPower() / (float)((RainData)this.getData()).getDurationTicks());
        for (int tick = 0; tick < ((RainData)this.getData()).getDurationTicks(); ++tick) {
            for (int i = 0; i < particlesPerWave; ++i) {
                AttackEffect effect = ((RainData)this.getData()).makeEffect(this).setHideTicks(tick + 1, true);
                double offsetX = 0.0;
                double offsetZ = 0.0;
                Vector3d startOffset = ParticleMathHelper.generatePointInSphere(height / 1.5f, w.field_73012_v);
                double startOffsetX = startOffset.field_72450_a;
                double startOffsetZ = startOffset.field_72448_b;
                if (((RainData)this.getData()).getMaxHorizontalDisplacement() > 0.0f) {
                    Vector3d offset = ParticleMathHelper.generatePointInSphere(((RainData)this.getData()).getMaxHorizontalDisplacement(), w.field_73012_v);
                    offsetX = startOffsetX + offset.field_72450_a;
                    offsetZ = startOffsetZ + offset.field_72448_b;
                } else {
                    offsetX = startOffsetX;
                    offsetZ = startOffsetZ;
                }
                effect.startX = effect.endX + startOffsetX;
                effect.startY = effect.endY + (double)height;
                effect.startZ = effect.endZ + startOffsetZ;
                effect.endX += offsetX;
                effect.endY = effect.startY - (double)height;
                effect.endZ += offsetZ;
                effect.setHeading();
                mc.field_71452_i.func_78873_a((Particle)new ParticleArcanery(effect.startX, effect.startY, effect.startZ, 0.0, 0.0, 0.0, effect));
            }
        }
    }

    public static class RainData
    extends StandardParticleAnimationData {
        private int durationTicks;
        private float maxHorizontalDisplacement = 0.0f;
        private int heightAboveTarget = 2;

        @Override
        public void initFromAttack(ImmutableAttack immutableAttack, int effectivePower, Element effectiveType) {
            if (this.getPower() == -1) {
                this.setPower(effectivePower / 2);
            }
            super.initFromAttack(immutableAttack, effectivePower, effectiveType);
            if (this.durationTicks == 0) {
                this.durationTicks = (int)Math.ceil(Math.sqrt(effectivePower) * 3.0);
            }
        }

        @Override
        public void writeToByteBuffer(ByteBuf buf) {
            super.writeToByteBuffer(buf);
            buf.writeByte(this.durationTicks);
            buf.writeBoolean(this.maxHorizontalDisplacement != 0.0f);
            if (this.maxHorizontalDisplacement != 0.0f) {
                buf.writeFloat(this.maxHorizontalDisplacement);
            }
            buf.writeByte(this.heightAboveTarget);
        }

        @Override
        public RainData readFromByteBuffer(ByteBuf buf) {
            super.readFromByteBuffer(buf);
            this.durationTicks = buf.readByte();
            if (buf.readBoolean()) {
                this.maxHorizontalDisplacement = buf.readFloat();
            }
            this.heightAboveTarget = buf.readByte();
            return this;
        }

        @Override
        public EffectType getEffectEnum() {
            return EffectType.RAIN;
        }

        public RainData setDurationTicks(int durationTicks) {
            this.durationTicks = durationTicks;
            return this;
        }

        public RainData setMaxHorizontalDisplacement(float maxHorizontalDisplacement) {
            this.maxHorizontalDisplacement = maxHorizontalDisplacement;
            return this;
        }

        public RainData setHeightAboveTarget(int heightAboveTarget) {
            this.heightAboveTarget = heightAboveTarget;
            return this;
        }

        public int getDurationTicks() {
            return this.durationTicks;
        }

        public float getMaxHorizontalDisplacement() {
            return this.maxHorizontalDisplacement;
        }

        public int getHeightAboveTarget() {
            return this.heightAboveTarget;
        }
    }
}

