/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.api.rules.teamselection;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBase;
import com.pixelmonmod.pixelmon.api.storage.PartyStorage;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.TrainerPartyStorage;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.BattleClause;
import com.pixelmonmod.pixelmon.battles.api.rules.teamselection.ParticipantSelection;
import com.pixelmonmod.pixelmon.battles.api.rules.teamselection.TeamSelectionRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.TrainerParticipant;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.CheckRulesVersionFixed;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.selection.CancelTeamSelectPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.selection.RejectTeamSelectPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.selection.ShowTeamSelectPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;

public class TeamSelection {
    public static final String FAINT_KEY = "f";
    public static final String EGG_KEY = "e";
    public static final String NONE_KEY = "n";
    protected int id;
    protected BattleRules rules;
    protected ParticipantSelection[] participants;
    protected boolean showRules;
    protected boolean showOpponentTeam;
    protected boolean closeable;
    protected Consumer<TeamSelection> cancelConsumer;
    protected Consumer<BattleController> battleStartConsumer;

    public TeamSelection(int id, BattleRules rules, boolean showRules, boolean showOpponentTeam, boolean closeable, PartyStorage ... storages) {
        this(id, rules, showRules, showOpponentTeam, closeable, (Consumer<TeamSelection>)null, (Consumer<BattleController>)null, storages);
    }

    public TeamSelection(int id, BattleRules rules, boolean showRules, boolean showOpponentTeam, boolean closeable, Consumer<TeamSelection> cancelConsumer, Consumer<BattleController> battleStartConsumer, PartyStorage ... storages) {
        this.id = id;
        this.rules = rules;
        this.showRules = showRules;
        this.showOpponentTeam = showOpponentTeam;
        this.closeable = closeable;
        this.cancelConsumer = cancelConsumer;
        this.battleStartConsumer = battleStartConsumer;
        this.participants = new ParticipantSelection[storages.length];
        for (int i = 0; i < this.participants.length; ++i) {
            this.participants[i] = new ParticipantSelection(storages[i]);
        }
    }

    public boolean hasPlayer(ServerPlayerEntity player) {
        for (ParticipantSelection p : this.participants) {
            if (!(p.storage instanceof PlayerPartyStorage) || ((PlayerPartyStorage)p.storage).getPlayer() != player) continue;
            return true;
        }
        return false;
    }

    public void handleCancel() {
        if (this.cancelConsumer != null) {
            this.cancelConsumer.accept(this);
        }
    }

    void initializeClient() {
        PartyStorage storage;
        ParticipantSelection cancelPart = null;
        boolean hasNPC = false;
        for (ParticipantSelection p : this.participants) {
            if (p.isNPC) {
                hasNPC = true;
                continue;
            }
            storage = p.storage;
            boolean hasPokemon = false;
            for (int i = 0; i < storage.getAll().length; ++i) {
                Pokemon current = storage.get(i);
                if (current == null) {
                    p.disabled[i] = NONE_KEY;
                } else if (current.isEgg()) {
                    p.disabled[i] = EGG_KEY;
                } else if (current.isFainted() && !this.rules.getOrDefault(BattleRuleRegistry.FULL_HEAL).booleanValue()) {
                    p.disabled[i] = FAINT_KEY;
                }
                if (p.disabled[i] != null) continue;
                p.disabled[i] = this.rules.validateSingle(current);
                hasPokemon = hasPokemon || p.disabled[i] == null;
            }
            if (hasPokemon) continue;
            cancelPart = p;
        }
        if (cancelPart != null && !hasNPC) {
            this.cancelBattle(cancelPart);
            return;
        }
        for (ParticipantSelection p : this.participants) {
            if (p.isNPC) continue;
            storage = (PlayerPartyStorage)p.storage;
            ServerPlayerEntity player = ((PlayerPartyStorage)storage).getPlayer();
            ParticipantSelection otherPart = this.getOther(p);
            List<Pokemon> opponentPokemon = otherPart.storage.findAll(Objects::nonNull);
            ArrayList<PokemonBase> opponentTeam = new ArrayList<PokemonBase>();
            for (Pokemon pokemon : opponentPokemon) {
                opponentTeam.add(pokemon);
            }
            AbstractPixelmonPacket packet = otherPart.isNPC ? new ShowTeamSelectPacket(this.id, p.disabled, opponentTeam, ((TrainerPartyStorage)otherPart.storage).getTrainer().getNPCID(), ((TrainerPartyStorage)otherPart.storage).getTrainer().getName(player.getLanguage()), this.rules, this.showRules, this.showOpponentTeam, this.closeable) : new ShowTeamSelectPacket(this.id, p.disabled, opponentTeam, ((PlayerPartyStorage)otherPart.storage).getPlayerUUID(), this.rules, this.showRules, this.showOpponentTeam, this.closeable);
            if (this.showRules) {
                packet = new CheckRulesVersionFixed((ShowTeamSelectPacket)packet);
            }
            NetworkHelper.sendPacket(packet, player);
        }
    }

    void startBattle() {
        PlayerParticipant part2;
        BattleParticipant part1;
        ParticipantSelection npc = null;
        ParticipantSelection cancelPart = null;
        for (ParticipantSelection p : this.participants) {
            if (p.isNPC) {
                npc = p;
                int[] teamIndices = this.rules.getOrDefault(BattleRuleRegistry.TEAM_PREVIEW) != false || this.rules.getOrDefault(BattleRuleRegistry.NUM_POKEMON) < 6 ? RandomHelper.getRandomDistinctNumbersBetween(0, 5, 6) : new int[]{0, 1, 2, 3, 4, 5};
                for (int index : teamIndices) {
                    p.addTeamMember(index);
                    if (this.rules.validateTeam(p.team) != null) {
                        p.removeTeamMember();
                    }
                    if (p.team.size() == this.rules.getOrDefault(BattleRuleRegistry.NUM_POKEMON).intValue()) break;
                }
                if (!p.team.isEmpty()) continue;
                cancelPart = p;
                break;
            }
            String initValidate = this.rules.validateTeam(p.team);
            if (!p.team.isEmpty() && initValidate == null) continue;
            ServerPlayerEntity player = ((PlayerPartyStorage)p.storage).getPlayer();
            if (player != null && initValidate != null) {
                ChatHandler.sendChat((Entity)player, "gui.battlerules.teamviolatedforce", BattleClause.getLocalizedName(initValidate));
            }
            while (!p.team.isEmpty()) {
                p.removeTeamMember();
                if (this.rules.validateTeam(p.team) != null) continue;
            }
            if (p.team.isEmpty()) {
                int[] teamIndices;
                for (int index : teamIndices = RandomHelper.getRandomDistinctNumbersBetween(0, 5, 6)) {
                    p.addTeamMember(index);
                    if (p.team.isEmpty()) continue;
                    if (this.rules.validateTeam(p.team) == null) break;
                    p.removeTeamMember();
                }
            }
            if (!p.team.isEmpty()) continue;
            cancelPart = p;
            break;
        }
        if (cancelPart != null) {
            this.cancelBattle(cancelPart);
            return;
        }
        if (npc == null) {
            part1 = this.getPlayerPart(this.participants[0]);
            part2 = this.getPlayerPart(this.participants[1]);
        } else {
            TrainerPartyStorage storage = (TrainerPartyStorage)npc.storage;
            ParticipantSelection other = this.getOther(npc);
            ServerPlayerEntity player = ((PlayerPartyStorage)other.storage).getPlayer();
            if (!storage.getTrainer().canStartBattle((PlayerEntity)player, true)) {
                NetworkHelper.sendPacket(new CancelTeamSelectPacket(), player);
                this.removeTeamSelect();
                return;
            }
            part1 = new TrainerParticipant(storage.getTrainer(), (PlayerEntity)player, this.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE).getNumPokemon(), npc.team);
            part2 = new PlayerParticipant(player, other.team, this.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE).getNumPokemon());
        }
        BattleController battleController = BattleRegistry.startBattle(new BattleParticipant[]{part1}, new BattleParticipant[]{part2}, this.rules);
        if (this.battleStartConsumer != null) {
            this.battleStartConsumer.accept(battleController);
        }
        this.removeTeamSelect();
    }

    private void cancelBattle(ParticipantSelection cancelPart) {
        if (cancelPart != null) {
            String cancelName;
            if (cancelPart.isNPC) {
                ServerPlayerEntity player = null;
                ParticipantSelection[] participantSelectionArray = this.participants;
                int n = participantSelectionArray.length;
                for (int i = 0; i < n; ++i) {
                    ParticipantSelection p = participantSelectionArray[i];
                    if (p.isNPC) continue;
                    player = ((PlayerPartyStorage)p.storage).getPlayer();
                    break;
                }
                String langCode = player == null ? "en_US" : player.getLanguage();
                cancelName = ((TrainerPartyStorage)cancelPart.storage).getTrainer().getName(langCode);
            } else {
                cancelName = ((PlayerPartyStorage)cancelPart.storage).getPlayerName();
            }
            for (ParticipantSelection p : this.participants) {
                if (p.isNPC) continue;
                CancelTeamSelectPacket packet = new CancelTeamSelectPacket();
                ServerPlayerEntity player = ((PlayerPartyStorage)p.storage).getPlayer();
                NetworkHelper.sendPacket(packet, player);
                if (p == cancelPart) {
                    ChatHandler.sendChat((Entity)player, "gui.battlerules.cancelselectyou", new Object[0]);
                    continue;
                }
                ChatHandler.sendChat((Entity)player, "gui.battlerules.cancelselect", cancelName);
            }
            this.removeTeamSelect();
            if (this.cancelConsumer != null) {
                this.cancelConsumer.accept(this);
            }
        }
    }

    private PlayerParticipant getPlayerPart(ParticipantSelection p) {
        return new PlayerParticipant(((PlayerPartyStorage)p.storage).getPlayer(), p.team, this.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE).getNumPokemon());
    }

    private ParticipantSelection getOther(ParticipantSelection selection) {
        for (ParticipantSelection other : this.participants) {
            if (other == selection) continue;
            return other;
        }
        return selection;
    }

    private ParticipantSelection getPlayer(ServerPlayerEntity player) {
        for (ParticipantSelection p : this.participants) {
            if (p.isNPC || ((PlayerPartyStorage)p.storage).getPlayer() != player) continue;
            return p;
        }
        return null;
    }

    private boolean isReady() {
        for (ParticipantSelection p : this.participants) {
            if (p.confirmed) continue;
            return false;
        }
        return true;
    }

    public void registerTeamSelect(ServerPlayerEntity player, int[] selection, boolean force) {
        ParticipantSelection ps = this.getPlayer(player);
        if (ps == null) {
            return;
        }
        ps.setTeam(selection);
        while (ps.team.size() > this.rules.getOrDefault(BattleRuleRegistry.NUM_POKEMON)) {
            ps.team.remove(ps.team.size() - 1);
        }
        String clauseID = this.rules.validateTeam(ps.team);
        if (ps.team.isEmpty()) {
            clauseID = FAINT_KEY;
        }
        if (clauseID == null || force) {
            ps.confirmed = true;
            if (this.isReady()) {
                this.startBattle();
            }
        } else {
            NetworkHelper.sendPacket(new RejectTeamSelectPacket(clauseID), player);
        }
    }

    public void unregisterTeamSelect(ServerPlayerEntity player) {
        ParticipantSelection ps = this.getPlayer(player);
        if (ps != null) {
            ps.confirmed = false;
        }
    }

    private void removeTeamSelect() {
        TeamSelectionRegistry.removeSelection(this.id);
    }

    public static String[] getReservedKeys() {
        return new String[]{FAINT_KEY, EGG_KEY, NONE_KEY};
    }
}

