/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import com.pixelmonmod.pixelmon.Pixelmon;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ReflectionHelper {
    public static <T, E> E getPrivateValue(Class<? super T> clazz, T instance, String fieldName) {
        try {
            Field field = ReflectionHelper.findField(clazz, fieldName, fieldName);
            return (E)field.get(instance);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> void setPrivateValue(Class<? super T> clazz, T instance, Object value, String fieldName) {
        try {
            Field field = ReflectionHelper.findField(clazz, fieldName, fieldName);
            field.setAccessible(true);
            field.set(instance, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Field findField(Class<?> clazz, String fieldName, String obfName) {
        try {
            Field field = clazz.getDeclaredField(Pixelmon.isDevEnvironment() ? fieldName : obfName);
            field.setAccessible(true);
            return field;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Method findMethod(Class<?> clazz, String name, String obfName, Class<?> ... parameters) {
        try {
            Method method = clazz.getDeclaredMethod(Pixelmon.isDevEnvironment() ? name : obfName, parameters);
            method.setAccessible(true);
            return method;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void flipVariableFinality(Field field) throws NoSuchFieldException, IllegalAccessException {
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
    }

    public static void flipVariableFinality(Field field, Runnable runnable) throws NoSuchFieldException, IllegalAccessException {
        ReflectionHelper.flipVariableFinality(field);
        runnable.run();
        ReflectionHelper.flipVariableFinality(field);
    }
}

