/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.IStatStore;
import com.pixelmonmod.pixelmon.api.pokemon.stats.IVStore;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class CommandHelper {
    public static ITextComponent getHoverTextPokemon(Pokemon pokemon, int ... args) {
        IFormattableTextComponent boxString = null;
        if (args.length > 0) {
            boxString = TextHelper.textWithShowTextHover(TextHelper.color(TextFormatting.YELLOW, "[").func_230529_a_((ITextComponent)TextHelper.translate(TextFormatting.YELLOW, "pixelmon.command.pokemoninfo.boxinfo")).func_230529_a_((ITextComponent)TextHelper.color(TextFormatting.YELLOW, "]")), TextHelper.translate(TextFormatting.YELLOW, "pixelmon.command.pokemoninfo.box").func_240702_b_(": " + args[0]).func_240702_b_(" ").func_230529_a_((ITextComponent)TextHelper.translate(TextFormatting.YELLOW, "pixelmon.command.pokemoninfo.slot").func_240702_b_(": " + args[1])));
        }
        IFormattableTextComponent statString = TextHelper.textWithShowTextHover(TextHelper.color(TextFormatting.RED, "[").func_230529_a_((ITextComponent)TextHelper.translate(TextFormatting.RED, "pixelmon.command.pokemoninfo.stats")).func_230529_a_((ITextComponent)TextHelper.color(TextFormatting.RED, "]")), CommandHelper.getPokemonStatsHover(pokemon));
        IFormattableTextComponent evString = TextHelper.textWithShowTextHover(TextHelper.color(TextFormatting.GOLD, "[").func_230529_a_((ITextComponent)TextHelper.translate(TextFormatting.GOLD, "pixelmon.command.pokemoninfo.evs")).func_230529_a_((ITextComponent)TextHelper.color(TextFormatting.GOLD, "]")), CommandHelper.getStatHover(pokemon.getEVs()));
        IFormattableTextComponent ivString = TextHelper.textWithShowTextHover(TextHelper.color(TextFormatting.LIGHT_PURPLE, "[").func_230529_a_((ITextComponent)TextHelper.translate(TextFormatting.LIGHT_PURPLE, "pixelmon.command.pokemoninfo.ivs")).func_230529_a_((ITextComponent)TextHelper.color(TextFormatting.LIGHT_PURPLE, "]")), CommandHelper.getStatHover(pokemon.getIVs()));
        IFormattableTextComponent movesString = TextHelper.textWithShowTextHover(TextHelper.color(TextFormatting.BLUE, "[").func_230529_a_((ITextComponent)TextHelper.translate(TextFormatting.BLUE, "pixelmon.command.pokemoninfo.moves")).func_230529_a_((ITextComponent)TextHelper.color(TextFormatting.BLUE, "]")), CommandHelper.getMovesetHover(pokemon.getMoveset()));
        IFormattableTextComponent result = TextHelper.translate(pokemon.isShiny() ? TextFormatting.GOLD : TextFormatting.GREEN, pokemon.getSpecies().getTranslationKey());
        if (boxString != null) {
            result.func_240702_b_(" ").func_230529_a_((ITextComponent)boxString);
        }
        return result.func_240702_b_(" ").func_230529_a_((ITextComponent)statString).func_240702_b_(" ").func_230529_a_((ITextComponent)evString).func_240702_b_(" ").func_230529_a_((ITextComponent)ivString).func_240702_b_(" ").func_230529_a_((ITextComponent)movesString);
    }

    private static IFormattableTextComponent getStatHover(IStatStore iStatStore) {
        if (iStatStore instanceof IVStore) {
            return TextHelper.translate(TextFormatting.DARK_PURPLE, "pixelmon.command.pokemoninfo.ivs").func_240702_b_("\n").func_230529_a_((ITextComponent)CommandHelper.getBattleStatsFormatted(iStatStore, true));
        }
        return TextHelper.translate(TextFormatting.GOLD, "pixelmon.command.pokemoninfo.evs").func_240702_b_("\n").func_230529_a_((ITextComponent)CommandHelper.getBattleStatsFormatted(iStatStore, false));
    }

    private static IFormattableTextComponent getBattleStatsFormatted(IStatStore iStatStore, boolean isIVs) {
        StringBuilder builder = new StringBuilder();
        BattleStatsType[] statValues = BattleStatsType.getEVIVStatValues();
        for (int i = 0; i < statValues.length; ++i) {
            BattleStatsType stat = statValues[i];
            boolean hyperTrained = isIVs && ((IVStore)iStatStore).isHyperTrained(stat);
            builder.append(stat.getTranslatedName().getString()).append(": ").append(iStatStore.getStat(stat)).append(hyperTrained ? TextHelper.color(TextFormatting.AQUA, "(31 ").func_230529_a_((ITextComponent)TextHelper.translate(TextFormatting.AQUA, "pixelmon.command.pokemoninfo.hypertrained").func_240702_b_(")")) : "");
            if (i == statValues.length - 1) continue;
            builder.append("\n");
        }
        return new StringTextComponent(builder.toString()).func_240699_a_(isIVs ? TextFormatting.LIGHT_PURPLE : TextFormatting.GOLD);
    }

    private static IFormattableTextComponent getMovesetHover(Moveset moveset) {
        StringBuilder builder = new StringBuilder();
        Attack[] attacks = moveset.attacks;
        for (int i = 0; i < attacks.length; ++i) {
            Attack attack = attacks[i];
            builder.append(new TranslationTextComponent("pixelmon.command.pokemoninfo.move").getString()).append(" ").append(i + 1).append(": ").append(new TranslationTextComponent(attack != null ? attack.getMove().getTranslationKey() : "pixelmon.command.pokemoninfo.none").getString());
            if (i == attacks.length - 1) continue;
            builder.append("\n");
        }
        return new StringTextComponent(builder.toString()).func_240699_a_(TextFormatting.BLUE);
    }

    private static IFormattableTextComponent getPokemonStatsHover(Pokemon pokemon) {
        return TextHelper.translate(TextFormatting.AQUA, pokemon.getSpecies().getTranslationKey()).func_240702_b_("\n").func_230529_a_((ITextComponent)TextHelper.translate(TextFormatting.AQUA, "pixelmon.command.pokemoninfo.level")).func_240702_b_(": ").func_240702_b_(pokemon.getPokemonLevel() + "\n").func_230529_a_((ITextComponent)TextHelper.translate(TextFormatting.DARK_AQUA, "pixelmon.command.pokemoninfo.nature")).func_240702_b_(": ").func_240702_b_(pokemon.getNature().getTranslatedName().getString() + "\n").func_230529_a_((ITextComponent)TextHelper.translate(TextFormatting.YELLOW, "pixelmon.command.pokemoninfo.growth")).func_240702_b_(": ").func_240702_b_(pokemon.getGrowth().getTranslatedName().getString() + "\n").func_230529_a_((ITextComponent)TextHelper.translate(TextFormatting.GOLD, "pixelmon.command.pokemoninfo.ability")).func_240702_b_(": ").func_240702_b_(pokemon.getAbility().getTranslatedName().getString() + "\n").func_230529_a_((ITextComponent)TextHelper.translate(TextFormatting.LIGHT_PURPLE, "pixelmon.command.pokemoninfo.gender")).func_240702_b_(": ").func_240702_b_(pokemon.getGender().getTranslatedName().getString() + "\n").func_230529_a_((ITextComponent)TextHelper.translate(TextFormatting.DARK_PURPLE, "pixelmon.command.pokemoninfo.originaltrainer")).func_240702_b_(": ").func_240702_b_(pokemon.getOriginalTrainer() + "\n").func_230529_a_((ITextComponent)TextHelper.translate(TextFormatting.RED, "pixelmon.command.pokemoninfo.item")).func_240702_b_(": ").func_230529_a_((ITextComponent)(pokemon.getHeldItem() == ItemStack.field_190927_a ? new TranslationTextComponent("pixelmon.command.pokemoninfo.none") : pokemon.getHeldItem().func_151000_E()));
    }
}

