/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.storage;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.economy.BankAccount;
import com.pixelmonmod.pixelmon.api.economy.EconomyEvent;
import com.pixelmonmod.pixelmon.api.enums.BattleEndTaskResult;
import com.pixelmonmod.pixelmon.api.enums.BattleEndTaskType;
import com.pixelmonmod.pixelmon.api.enums.ServerCosmetics;
import com.pixelmonmod.pixelmon.api.enums.TriBoolean;
import com.pixelmonmod.pixelmon.api.events.PokedexEvent;
import com.pixelmonmod.pixelmon.api.events.PokerusEvent;
import com.pixelmonmod.pixelmon.api.pokedex.PlayerPokedex;
import com.pixelmonmod.pixelmon.api.pokedex.PokedexRegistrationStatus;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Pokerus;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.RarityTweak;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.PartyStorage;
import com.pixelmonmod.pixelmon.api.storage.PlayerStats;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.storage.TransientData;
import com.pixelmonmod.pixelmon.api.storage.breeding.PlayerDayCare;
import com.pixelmonmod.pixelmon.api.util.helpers.CommonHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.log.BattleLog;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.PixelExtrasDisplayClientPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.QueryResourceLocationPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.CloseBattlePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.UpdateClientPlayerDataPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.storage.ClientboundSetSelectedSlotPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.storage.ServerboundSetSelectedSlotPacket;
import com.pixelmonmod.pixelmon.enums.EnumBerryFlavor;
import com.pixelmonmod.pixelmon.enums.EnumCurryKey;
import com.pixelmonmod.pixelmon.enums.EnumCurryRating;
import com.pixelmonmod.pixelmon.enums.EnumFeatureState;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumMegaItem;
import com.pixelmonmod.pixelmon.enums.EnumMegaItemsUnlocked;
import com.pixelmonmod.pixelmon.enums.EnumTrainerCardColor;
import com.pixelmonmod.pixelmon.items.LureItem;
import com.pixelmonmod.pixelmon.listener.EntityPlayerExtension;
import com.pixelmonmod.pixelmon.quests.comm.ResetQuestsPacket;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasData;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasStorage;
import com.pixelmonmod.pixelmon.storage.playerData.PlayerData;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import com.pixelmonmod.pixelmon.storage.playerData.TeleportPosition;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class PlayerPartyStorage
extends PartyStorage
implements BankAccount,
RarityTweak {
    protected String playerName = null;
    public EnumTrainerCardColor trainerCardColor = EnumTrainerCardColor.WHITE;
    public TeleportPosition teleportPos = new TeleportPosition();
    protected BigDecimal pokeDollars = BigDecimal.valueOf(PixelmonConfigProxy.getGeneral().getStartingBalance());
    public PlayerPokedex playerPokedex = new PlayerPokedex();
    public PlayerStats stats = new PlayerStats();
    public boolean guiOpened = false;
    public boolean battleEnabled = true;
    public boolean starterPicked = false;
    public boolean oldGen = false;
    private int ticksTillEncounter;
    private int selectedSlot = 0;
    private EnumMegaItemsUnlocked megaItemsUnlocked = EnumMegaItemsUnlocked.None;
    private EnumMegaItem megaItem = EnumMegaItem.Disabled;
    private ItemStack lure = ItemStack.field_190927_a;
    private EnumFeatureState shinyCharm = EnumFeatureState.Disabled;
    private EnumFeatureState ovalCharm = EnumFeatureState.Disabled;
    private EnumFeatureState expCharm = EnumFeatureState.Disabled;
    private EnumFeatureState catchingCharm = EnumFeatureState.Disabled;
    private EnumFeatureState markCharm = EnumFeatureState.Disabled;
    private EnumSet<ServerCosmetics> serverCosmetics = EnumSet.noneOf(ServerCosmetics.class);
    private int[] curryData = new int[26];
    private Map<Integer, Set<String>> megasObtained = new HashMap<Integer, Set<String>>();
    public PlayerData playerData = new PlayerData();
    private QuestData questData = new QuestData();
    private PlayerDayCare dayCare = new PlayerDayCare(this);
    protected BattleLog lastBattle = null;
    public transient TransientData transientData = new TransientData();

    public PlayerPartyStorage(UUID uuid, boolean shouldSendUpdates) {
        super(uuid);
        this.shouldSendUpdates = shouldSendUpdates;
        this.playerPokedex.setUUID(uuid);
        if (shouldSendUpdates) {
            this.tryUpdatePlayerName();
        }
    }

    public PlayerPartyStorage(UUID uuid) {
        this(uuid, true);
    }

    @Override
    public UUID getIdentifier() {
        return this.uuid;
    }

    @Override
    public boolean add(Pokemon pokemon) {
        if (!super.add(pokemon) && !super.inTemporaryMode()) {
            PCStorage pc = StorageProxy.getPCForPlayer(this.uuid);
            ServerPlayerEntity player = this.getPlayer();
            if (player != null) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("pixelmon.storage.partyfull", new Object[]{pokemon.isEgg() ? "The egg" : pokemon.getLocalizedName()}), Util.field_240973_b_);
            }
            if (!pc.add(pokemon)) {
                if (player != null) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("pixelmon.storage.compfull"), Util.field_240973_b_);
                }
                return false;
            }
            return true;
        }
        return true;
    }

    public TriBoolean addSilently(Pokemon pokemon) {
        if (!super.add(pokemon)) {
            PCStorage pc = StorageProxy.getPCForPlayer(this.uuid);
            return pc.add(pokemon) ? TriBoolean.FALSE : TriBoolean.NULL;
        }
        return TriBoolean.TRUE;
    }

    public void tryUpdatePlayerName() {
        ServerPlayerEntity player;
        if (this.shouldSendUpdates && (player = this.getPlayer()) != null) {
            this.playerName = player.func_200200_C_().getString();
        }
    }

    @Nullable
    public ServerPlayerEntity getPlayer() {
        return ServerLifecycleHooks.getCurrentServer() == null ? null : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(this.uuid);
    }

    @Nullable
    public String getPlayerName() {
        return this.playerName;
    }

    public UUID getPlayerUUID() {
        return this.uuid;
    }

    @Override
    public void set(StoragePosition position, Pokemon pokemon) {
        super.set(position, pokemon);
        if (pokemon != null && this.playerName != null && (pokemon.getOriginalTrainer() == null || pokemon.getOriginalTrainer().equals(this.playerName) && pokemon.getOriginalTrainerUUID() == null)) {
            pokemon.setOriginalTrainer(this.uuid, this.playerName);
        }
        if (this.getShouldSendUpdates()) {
            PokedexEvent.Pre preEvent;
            if (this.getPlayer() != null) {
                EntityPlayerExtension.updatePlayerPokeballs(this.getPlayer(), this.getAll());
            }
            if (pokemon != null && !pokemon.isEgg() && this.playerPokedex.getSeenMap().get(pokemon.getSpecies().getDex()) != PokedexRegistrationStatus.CAUGHT && !Pixelmon.EVENT_BUS.post((Event)(preEvent = new PokedexEvent.Pre(this.uuid, pokemon, PokedexRegistrationStatus.CAUGHT, "storageMovement")))) {
                this.playerPokedex.set(preEvent.getPokemon(), preEvent.getNewStatus());
                this.playerPokedex.update();
                Pixelmon.EVENT_BUS.post((Event)new PokedexEvent.Post(this.uuid, preEvent.getOldStatus(), preEvent.getPokemon(), preEvent.getNewStatus(), preEvent.getCause()));
            }
        }
    }

    @Override
    public CompoundNBT writeToNBT(CompoundNBT nbt) {
        if (this.playerName != null) {
            nbt.func_74778_a("player", this.playerName);
        }
        this.playerData.writeToNBT(nbt);
        this.teleportPos.writeToNBT(nbt);
        nbt.func_74768_a("SelectedSlot", this.selectedSlot);
        nbt.func_74783_a("curryDex", this.curryData);
        nbt.func_74778_a("pixelDollars", this.pokeDollars.toString());
        nbt.func_74768_a("trainerCardColor", this.trainerCardColor.ordinal());
        nbt.func_74757_a("starterPicked", this.starterPicked);
        nbt.func_74757_a("oldGen", this.oldGen);
        this.playerPokedex.writeToNBT(nbt);
        this.stats.writeToNBT(nbt);
        this.dayCare.writeToNBT(nbt);
        nbt.func_74768_a("TicksTillNextEncounter", this.ticksTillEncounter);
        nbt.func_74778_a("MegaItemString", this.megaItem.toString());
        if (this.megaItem.canEvolve() && this.megaItemsUnlocked.isNone()) {
            this.setMegaItemsUnlocked(EnumMegaItemsUnlocked.Mega);
        }
        nbt.func_74768_a("MegaItemsUnlocked", this.megaItemsUnlocked.ordinal());
        nbt.func_74768_a("ShinyCharmID", this.shinyCharm.ordinal());
        nbt.func_74768_a("OvalCharmID", this.ovalCharm.ordinal());
        nbt.func_74768_a("ExpCharmID", this.expCharm.ordinal());
        nbt.func_74768_a("CatchingCharmID", this.catchingCharm.ordinal());
        nbt.func_74768_a("MarkCharmID", this.markCharm.ordinal());
        BitSet set = new BitSet();
        for (ServerCosmetics serverCosmetics : this.serverCosmetics) {
            set.set(serverCosmetics.ordinal());
        }
        nbt.func_74773_a("ServCosm", set.toByteArray());
        ListNBT tagList = new ListNBT();
        for (Map.Entry<Integer, Set<String>> entry : this.megasObtained.entrySet()) {
            CompoundNBT megaObtainedNBT = new CompoundNBT();
            megaObtainedNBT.func_74768_a("MegaStonesObtainedDexId", entry.getKey().intValue());
            megaObtainedNBT.func_218657_a("Variant", (INBT)this.getNames(entry.getValue()));
            tagList.add((Object)megaObtainedNBT);
        }
        nbt.func_218657_a("MegaStonesObtained", (INBT)tagList);
        this.questData.writeToNBT(nbt);
        CompoundNBT compoundNBT = new CompoundNBT();
        this.lure.func_77955_b(compoundNBT);
        nbt.func_218657_a("Lure", (INBT)compoundNBT);
        return super.writeToNBT(nbt);
    }

    private ListNBT getNames(Set<String> forms) {
        ListNBT list = new ListNBT();
        for (String form : forms) {
            list.add((Object)StringNBT.func_229705_a_((String)form));
        }
        return list;
    }

    @Override
    public PlayerPartyStorage readFromNBT(CompoundNBT nbt) {
        super.readFromNBT(nbt);
        this.selectedSlot = nbt.func_74762_e("SelectedSlot");
        if (this.selectedSlot > this.party.length || this.selectedSlot < 0) {
            this.selectedSlot = 0;
        }
        this.dayCare = PlayerDayCare.readFromNBT(this, nbt);
        this.playerName = nbt.func_74779_i("player");
        this.playerData.readFromNBT(nbt);
        this.teleportPos.readFromNBT(nbt);
        if (nbt.func_74764_b("pixelDollars")) {
            try {
                this.pokeDollars = new BigDecimal(nbt.func_74779_i("pixelDollars"));
            }
            catch (NumberFormatException e) {
                this.pokeDollars = BigDecimal.valueOf(PixelmonConfigProxy.getGeneral().getStartingBalance());
            }
        }
        this.trainerCardColor = EnumTrainerCardColor.values()[nbt.func_74762_e("trainerCardColor")];
        if (nbt.func_74764_b("curryDex")) {
            this.curryData = nbt.func_74759_k("curryDex");
        }
        if (nbt.func_74764_b("starterPicked")) {
            this.starterPicked = nbt.func_74767_n("starterPicked");
        }
        if (nbt.func_74764_b("oldGen")) {
            this.oldGen = nbt.func_74767_n("oldGen");
        }
        if (nbt.func_74764_b("MegaItemString")) {
            this.setMegaItem(EnumMegaItem.getFromString(nbt.func_74779_i("MegaItemString")), false);
        }
        if (nbt.func_74764_b("MegaItemsUnlocked")) {
            this.setMegaItemsUnlocked(EnumMegaItemsUnlocked.values()[nbt.func_74762_e("MegaItemsUnlocked")]);
        } else if (this.getMegaItem().canEvolve()) {
            this.setMegaItemsUnlocked(EnumMegaItemsUnlocked.Mega);
        }
        if (nbt.func_74764_b("ShinyCharmID")) {
            this.setShinyCharm(EnumFeatureState.values()[nbt.func_74762_e("ShinyCharmID")]);
        }
        if (nbt.func_74764_b("OvalCharmID")) {
            this.setOvalCharm(EnumFeatureState.values()[nbt.func_74762_e("OvalCharmID")]);
        }
        if (nbt.func_74764_b("ExpCharmID")) {
            this.setExpCharm(EnumFeatureState.values()[nbt.func_74762_e("ExpCharmID")]);
        }
        if (nbt.func_74764_b("CatchingCharmID")) {
            this.setCatchingCharm(EnumFeatureState.values()[nbt.func_74762_e("CatchingCharmID")]);
        }
        if (nbt.func_74764_b("MarkCharmID")) {
            this.setMarkCharm(EnumFeatureState.values()[nbt.func_74762_e("MarkCharmID")]);
        }
        this.serverCosmetics.clear();
        if (nbt.func_74764_b("HweenRobe")) {
            this.serverCosmetics.add(ServerCosmetics.DROWNED_ROBE);
        }
        if (nbt.func_74764_b("ServCosm")) {
            BitSet set = BitSet.valueOf(nbt.func_74770_j("ServCosm"));
            for (ServerCosmetics cosmetics : ServerCosmetics.values()) {
                if (!set.get(cosmetics.ordinal())) continue;
                this.serverCosmetics.add(cosmetics);
            }
        }
        this.playerPokedex.readFromNBT(nbt);
        this.stats.readFromNBT(nbt);
        if (nbt.func_74764_b("MegaStonesObtained")) {
            ListNBT list = nbt.func_150295_c("MegaStonesObtained", 10);
            for (INBT inbt : list) {
                CompoundNBT megaInfo = (CompoundNBT)inbt;
                int dex = megaInfo.func_74762_e("MegaStonesObtainedDexId");
                Set<String> forms = this.fromNames(megaInfo.func_150295_c("Variant", 8));
                this.megasObtained.put(dex, forms);
            }
        }
        this.questData.readFromNBT(nbt);
        if (nbt.func_74764_b("Lure")) {
            ItemStack lure;
            CompoundNBT lureTag = nbt.func_74775_l("Lure");
            this.lure = lure = ItemStack.func_199557_a((CompoundNBT)lureTag);
        }
        return this;
    }

    private Set<String> fromNames(ListNBT array) {
        HashSet stats = Sets.newHashSet();
        for (INBT inbt : array) {
            stats.add(inbt.func_150285_a_());
        }
        return stats;
    }

    @Override
    public List<ServerPlayerEntity> getPlayersToUpdate() {
        ServerPlayerEntity player = this.getPlayer();
        if (player == null) {
            return new ArrayList<ServerPlayerEntity>();
        }
        return Lists.newArrayList((Object[])new ServerPlayerEntity[]{player});
    }

    @Override
    public boolean getShouldSave() {
        if (this.getPlayer() == null) {
            return true;
        }
        return super.getShouldSave();
    }

    @Override
    public int[] getCurryData() {
        return this.curryData;
    }

    @Override
    public void updateSingleCurryData(EnumCurryKey curryKey, EnumBerryFlavor cookingFlavor, EnumCurryRating rating) {
        byte[] cd = CommonHelper.decodeInteger(this.curryData[curryKey.ordinal()], 3);
        if (cd[cookingFlavor.ordinal()] < rating.ordinal() + 1) {
            cd[cookingFlavor.ordinal()] = (byte)(rating.ordinal() + 1);
            this.curryData[curryKey.ordinal()] = CommonHelper.encodeInteger(cd, 3);
        }
    }

    public void fillOneCurryDexFlavor(int curryDexPage, int curryDexFlavor, int curryDexRating) {
        byte[] cd = CommonHelper.decodeInteger(this.curryData[curryDexPage], 3);
        cd[curryDexFlavor] = (byte)(curryDexRating + 1);
        this.curryData[curryDexPage] = CommonHelper.encodeInteger(cd, 3);
    }

    public void fillOneCurryDexPage(int curryDexPage, int curryDexRating) {
        byte[] cd = CommonHelper.decodeInteger(this.curryData[curryDexPage], 3);
        for (int flavor = 0; flavor < EnumBerryFlavor.values().length; ++flavor) {
            cd[flavor] = (byte)(curryDexRating + 1);
            this.curryData[curryDexPage] = CommonHelper.encodeInteger(cd, 3);
        }
    }

    public void fillEntireCurryDex(int curryDexRating) {
        for (int entry = 0; entry < EnumCurryKey.values().length; ++entry) {
            byte[] cd = CommonHelper.decodeInteger(this.curryData[entry], 3);
            for (int flavor = 0; flavor < EnumBerryFlavor.values().length; ++flavor) {
                cd[flavor] = (byte)(curryDexRating + 1);
                this.curryData[entry] = CommonHelper.encodeInteger(cd, 3);
            }
        }
    }

    public boolean isMegaItemObtained(Species pokemon, Stats form) {
        if (!this.megasObtained.containsKey(pokemon.getDex())) {
            return false;
        }
        Set<String> forms = this.megasObtained.get(pokemon.getDex());
        return forms.contains(form.getName().toLowerCase(Locale.ROOT));
    }

    public void obtainedItem(Species pokemon, Stats form, ServerPlayerEntity player) {
        Set forms = this.megasObtained.computeIfAbsent(pokemon.getDex(), ___ -> Sets.newHashSet());
        if (forms.contains(form.getName().toLowerCase(Locale.ROOT))) {
            return;
        }
        forms.add(form.getName().toLowerCase(Locale.ROOT));
        this.unlockMega(true);
    }

    public void setMegaItem(EnumMegaItem megaItem, boolean giveChoice) {
        this.megaItem = megaItem;
        if (this.getPlayer() != null) {
            if (giveChoice) {
                NetworkHelper.sendPacket(new UpdateClientPlayerDataPacket(this.megaItem), this.getPlayer());
                if (!this.guiOpened) {
                    if (megaItem == EnumMegaItem.DynamaxBand) {
                        OpenScreenPacket.open((PlayerEntity)this.getPlayer(), EnumGuiScreen.MegaItem, 1);
                    } else {
                        OpenScreenPacket.open((PlayerEntity)this.getPlayer(), EnumGuiScreen.MegaItem, 0);
                    }
                }
            }
            EntityPlayerExtension.updatePlayerMegaItem(this.getPlayer(), this.megaItem);
        }
        this.setNeedsSaving();
    }

    public void unlockMega(boolean giveChoice) {
        if (!this.getMegaItemsUnlocked().canMega()) {
            if (this.getMegaItemsUnlocked().canDynamax()) {
                this.setMegaItemsUnlocked(EnumMegaItemsUnlocked.Both);
            } else {
                this.setMegaItemsUnlocked(EnumMegaItemsUnlocked.Mega);
                this.setMegaItem(EnumMegaItem.BraceletORAS, giveChoice);
            }
        }
    }

    public void lockMega() {
        if (this.getMegaItemsUnlocked().canMega()) {
            if (this.getMegaItemsUnlocked().canDynamax()) {
                this.setMegaItemsUnlocked(EnumMegaItemsUnlocked.Dynamax);
                if (this.getMegaItem().canMega()) {
                    this.setMegaItem(EnumMegaItem.None, false);
                }
            } else {
                this.setMegaItemsUnlocked(EnumMegaItemsUnlocked.None);
            }
        }
    }

    public void unlockDynamax(boolean giveChoice) {
        if (!this.getMegaItemsUnlocked().canDynamax()) {
            if (this.getMegaItemsUnlocked().canMega()) {
                this.setMegaItemsUnlocked(EnumMegaItemsUnlocked.Both);
            } else {
                this.setMegaItemsUnlocked(EnumMegaItemsUnlocked.Dynamax);
                this.setMegaItem(EnumMegaItem.DynamaxBand, giveChoice);
            }
        }
    }

    public void lockDynamax() {
        if (this.getMegaItemsUnlocked().canDynamax()) {
            if (this.getMegaItemsUnlocked().canMega()) {
                this.setMegaItemsUnlocked(EnumMegaItemsUnlocked.Mega);
                if (this.getMegaItem().canDynamax()) {
                    this.setMegaItem(EnumMegaItem.None, false);
                }
            } else {
                this.setMegaItemsUnlocked(EnumMegaItemsUnlocked.None);
            }
        }
    }

    public void setMegaItemsUnlocked(EnumMegaItemsUnlocked megaItemsUnlocked) {
        this.megaItemsUnlocked = megaItemsUnlocked;
        if (this.getPlayer() != null) {
            EntityPlayerExtension.updatePlayerMegaItemsUnlocked(this.getPlayer(), this.megaItemsUnlocked);
        }
        this.setNeedsSaving();
    }

    public void setShinyCharm(EnumFeatureState shinyCharm) {
        this.shinyCharm = shinyCharm;
        if (this.getPlayer() != null) {
            EntityPlayerExtension.updatePlayerShinyCharm(this.getPlayer(), this.shinyCharm);
        }
        this.setNeedsSaving();
    }

    public void setOvalCharm(EnumFeatureState ovalCharm) {
        this.ovalCharm = ovalCharm;
        if (this.getPlayer() != null) {
            EntityPlayerExtension.updatePlayerOvalCharm(this.getPlayer(), this.ovalCharm);
        }
        this.setNeedsSaving();
    }

    public void setExpCharm(EnumFeatureState expCharm) {
        this.expCharm = expCharm;
        if (this.getPlayer() != null) {
            EntityPlayerExtension.updatePlayerExpCharm(this.getPlayer(), this.expCharm);
        }
        this.setNeedsSaving();
    }

    public void setCatchingCharm(EnumFeatureState catchingCharm) {
        this.catchingCharm = catchingCharm;
        if (this.getPlayer() != null) {
            EntityPlayerExtension.updatePlayerCatchingCharm(this.getPlayer(), this.catchingCharm);
        }
        this.setNeedsSaving();
    }

    public void setMarkCharm(EnumFeatureState markCharm) {
        this.markCharm = markCharm;
        if (this.getPlayer() != null) {
            EntityPlayerExtension.updatePlayerMarkCharm(this.getPlayer(), this.markCharm);
        }
        this.setNeedsSaving();
    }

    @Deprecated
    public void setHweenRobe(EnumFeatureState hweenRobe) {
        if (hweenRobe.isAvailable()) {
            this.grantServerCosmetics(ServerCosmetics.DROWNED_ROBE);
        } else {
            this.revokeServerCosmetics(ServerCosmetics.DROWNED_ROBE);
        }
        this.setNeedsSaving();
    }

    public boolean canEquipMegaItem() {
        return this.megaItem != EnumMegaItem.Disabled;
    }

    public EnumMegaItem getMegaItem() {
        return this.megaItem;
    }

    public EnumMegaItemsUnlocked getMegaItemsUnlocked() {
        return this.megaItemsUnlocked;
    }

    public EnumFeatureState getShinyCharm() {
        return this.shinyCharm;
    }

    public EnumFeatureState getOvalCharm() {
        return this.ovalCharm;
    }

    public EnumFeatureState getExpCharm() {
        return this.expCharm;
    }

    public EnumFeatureState getCatchingCharm() {
        return this.catchingCharm;
    }

    public EnumFeatureState getMarkCharm() {
        return this.markCharm;
    }

    @Deprecated
    public EnumFeatureState getHweenRobe() {
        if (this.getServerCosmetics().contains((Object)ServerCosmetics.DROWNED_ROBE)) {
            return EnumFeatureState.Available;
        }
        return EnumFeatureState.Disabled;
    }

    public Set<ServerCosmetics> getServerCosmetics() {
        return ImmutableSet.copyOf(this.serverCosmetics);
    }

    public void setServerCosmetics(Set<ServerCosmetics> cosmetics) {
        this.serverCosmetics = cosmetics.isEmpty() ? EnumSet.noneOf(ServerCosmetics.class) : EnumSet.copyOf(cosmetics);
        PixelExtrasData data = PixelExtrasStorage.getData(this.uuid);
        data.updateServerCosmetics(this.serverCosmetics);
        NetworkHelper.sendToAll(new PixelExtrasDisplayClientPacket(data));
        this.setNeedsSaving();
    }

    public void grantServerCosmetics(ServerCosmetics ... cosmetics) {
        this.serverCosmetics.addAll(Arrays.asList(cosmetics));
        PixelExtrasData data = PixelExtrasStorage.getData(this.uuid);
        data.updateServerCosmetics(this.serverCosmetics);
        NetworkHelper.sendToAll(new PixelExtrasDisplayClientPacket(data));
        this.setNeedsSaving();
    }

    public void revokeServerCosmetics(ServerCosmetics ... cosmetics) {
        this.serverCosmetics.removeAll(Arrays.asList(cosmetics));
        PixelExtrasData data = PixelExtrasStorage.getData(this.uuid);
        data.updateServerCosmetics(this.serverCosmetics);
        NetworkHelper.sendToAll(new PixelExtrasDisplayClientPacket(data));
        this.setNeedsSaving();
    }

    public ItemStack getLureStack() {
        return this.lure;
    }

    @Nullable
    public LureItem getLure() {
        if (this.lure.func_77973_b() instanceof LureItem) {
            return (LureItem)this.lure.func_77973_b();
        }
        return null;
    }

    public void setLureStack(ItemStack stack) {
        ServerPlayerEntity player;
        if (stack != null && !stack.func_190926_b() && !(stack.func_77973_b() instanceof LureItem)) {
            return;
        }
        this.lure = stack == null || stack.func_190926_b() ? ItemStack.field_190927_a : stack;
        this.setHasChanged(true);
        if (this.getShouldSendUpdates() && (player = this.getPlayer()) != null) {
            NetworkHelper.sendPacket(new UpdateClientPlayerDataPacket(this.lure), player);
        }
    }

    public void setLure(LureItem lure) {
        if (lure == null) {
            this.setLureStack(ItemStack.field_190927_a);
        } else {
            this.setLureStack(new ItemStack((IItemProvider)lure));
        }
    }

    public void dropLureInLureSlot(ServerPlayerEntity player) {
        PlayerPartyStorage party = StorageProxy.getParty(player);
        player.func_146097_a(party.getLureStack(), true, false);
        party.setLureStack(ItemStack.field_190927_a);
    }

    @Override
    public boolean hasBalance(BigDecimal amount) {
        return this.getBalance().compareTo(amount) >= 0;
    }

    @Override
    public BigDecimal getBalance() {
        EconomyEvent.GetBalance getBalanceEvent = new EconomyEvent.GetBalance(this.getPlayer(), this, this.pokeDollars);
        Pixelmon.EVENT_BUS.post((Event)getBalanceEvent);
        return getBalanceEvent.getBalance();
    }

    @Override
    public void setBalance(BigDecimal amount) {
        EconomyEvent.SetBalance event = new EconomyEvent.SetBalance(this.getPlayer(), this, amount);
        if (!Pixelmon.EVENT_BUS.post((Event)event)) {
            this.pokeDollars = event.getBalance();
            this.updatePlayer(this.pokeDollars);
            this.setNeedsSaving();
        }
    }

    @Override
    public boolean add(BigDecimal amount) {
        if (amount.intValue() < 0) {
            Pixelmon.LOGGER.error("Cannot add a negative amount to bank account for " + this.playerName);
            return false;
        }
        BigDecimal oldBalance = this.pokeDollars;
        EconomyEvent.PreTransaction preEvent = new EconomyEvent.PreTransaction(this.getPlayer(), this, EconomyEvent.TransactionType.DEPOSIT, this.pokeDollars, amount);
        if (!Pixelmon.EVENT_BUS.post((Event)preEvent)) {
            this.pokeDollars = this.pokeDollars.add(amount);
            this.updatePlayer(this.pokeDollars);
            this.setNeedsSaving();
            Pixelmon.EVENT_BUS.post((Event)new EconomyEvent.PostTransaction(this.getPlayer(), this, EconomyEvent.TransactionType.DEPOSIT, oldBalance, this.pokeDollars));
            return true;
        }
        return false;
    }

    @Override
    public boolean take(BigDecimal amount) {
        if (amount.intValue() < 0) {
            Pixelmon.LOGGER.error("Cannot take a negative amount from bank account for " + this.playerName);
            return false;
        }
        BigDecimal oldBalance = this.pokeDollars;
        EconomyEvent.PreTransaction preEvent = new EconomyEvent.PreTransaction(this.getPlayer(), this, EconomyEvent.TransactionType.WITHDRAW, this.pokeDollars, amount);
        if (!Pixelmon.EVENT_BUS.post((Event)preEvent)) {
            this.pokeDollars = this.pokeDollars.subtract(preEvent.getChange());
            this.updatePlayer(this.pokeDollars);
            this.setNeedsSaving();
            Pixelmon.EVENT_BUS.post((Event)new EconomyEvent.PostTransaction(this.getPlayer(), this, EconomyEvent.TransactionType.WITHDRAW, oldBalance, this.pokeDollars));
            return true;
        }
        return false;
    }

    public void updatePartyCache() {
        this.transientData.lowestLevel = 100;
        this.transientData.highestLevel = 1;
        this.transientData.averageLevel = 0;
        int count = 0;
        for (Pokemon pokemon : this.party) {
            if (pokemon == null || pokemon.isEgg()) continue;
            int level = pokemon.getPokemonLevel();
            ++count;
            this.transientData.averageLevel += level;
            this.transientData.lowestLevel = Math.min(this.transientData.lowestLevel, level);
            this.transientData.highestLevel = Math.max(this.transientData.highestLevel, level);
        }
        if (count == 0) {
            this.transientData.averageLevel = 50;
            this.transientData.lowestLevel = 1;
            this.transientData.highestLevel = 100;
        } else {
            this.transientData.averageLevel /= count;
        }
    }

    public int getTicksTillEncounter() {
        return this.ticksTillEncounter;
    }

    public void updateTicksTillEncounter() {
        this.ticksTillEncounter = this.ticksTillEncounter <= 1 ? this.getPlayer().func_70681_au().nextInt(900) + 100 : --this.ticksTillEncounter;
    }

    public void checkPokerus() {
        ServerPlayerEntity player = this.getPlayer();
        for (Pokemon pokemon : this.getAll()) {
            int seconds;
            int duration;
            Pokerus pokerus;
            if (pokemon == null || pokemon.isEgg() || pokemon.getPokerus() == null || !(pokerus = pokemon.getPokerus()).canInfect() || (duration = pokerus.type.getDuration()) <= -1 || (seconds = pokerus.secondsSinceInfection) == -1 || seconds >= duration) continue;
            if (++seconds >= duration) {
                pokerus.secondsSinceInfection = -1;
                Pixelmon.EVENT_BUS.post((Event)new PokerusEvent.Cured(player, pokemon, this));
            } else {
                pokerus.secondsSinceInfection = seconds;
            }
            pokemon.markDirty(EnumUpdateType.Pokerus);
        }
    }

    @Override
    public float getMultiplier(AbstractSpawner spawner, SpawnInfo spawnInfo, float sum, float rarity) {
        float modifiedValue = 1.0f;
        if (this.getLure() != null) {
            modifiedValue *= this.getLure().getMultiplier(spawner, spawnInfo, sum, rarity);
        }
        if (this.getTeam().size() > 0) {
            modifiedValue *= this.getTeam().get(0).getAbility().getMultiplier(spawner, spawnInfo, sum, rarity);
        }
        return modifiedValue;
    }

    public QuestData getQuestData(boolean update) {
        return this.questData.get(this.getPlayer(), update);
    }

    public QuestData getQuestData() {
        return this.getQuestData(true);
    }

    public void resetQuestData() {
        this.questData = new QuestData();
        if (!(this.getPlayer() instanceof FakePlayer)) {
            NetworkHelper.sendPacket(new ResetQuestsPacket(), this.getPlayer());
        }
        this.getQuestData(true);
    }

    public void closeBattleSafely() {
        if (!(this.getPlayer() instanceof FakePlayer)) {
            NetworkHelper.sendPacket(new CloseBattlePacket(), this.getPlayer());
        }
    }

    public BattleEndTaskResult addTaskForBattleEnd(BattleEndTaskType type, Consumer<Optional<BattleController>> consumer) {
        if (this.guiOpened || type == BattleEndTaskType.ALWAYS_QUEUE) {
            this.transientData.onceBattleDone.add(consumer);
            return BattleEndTaskResult.QUEUED;
        }
        if (type == BattleEndTaskType.QUEUE_IF_BATTLE_OTHERWISE_RUN) {
            consumer.accept(Optional.empty());
            return BattleEndTaskResult.EXECUTED;
        }
        return BattleEndTaskResult.IGNORED;
    }

    public void queryResourceLocationExistence(ResourceLocation resource, Consumer<Boolean> result) {
        ServerPlayerEntity player = this.getPlayer();
        if (player != null) {
            UUID query = UUID.randomUUID();
            this.transientData.resourceQueries.put(query, result);
            NetworkHelper.sendPacket(new QueryResourceLocationPacket(query, resource), player);
        }
    }

    public void receiveResourceLocationQueryResult(UUID query, boolean result) {
        Consumer<Boolean> consumer = this.transientData.resourceQueries.remove(query);
        if (consumer != null) {
            consumer.accept(result);
        }
    }

    public void registerKeyListener(Object instance, Method callback) {
        this.transientData.keyListener = new Tuple(instance, (Object)callback);
    }

    public void receiveKeyInput(int keyCode, int scanCode, int modifiers) {
        if (this.transientData.keyListener != null) {
            ServerPlayerEntity player = this.getPlayer();
            if (player == null || player.field_71070_bA == player.field_71069_bz || player.field_71070_bA == null) {
                this.deregisterKeyListener();
            } else {
                try {
                    ((Method)this.transientData.keyListener.func_76340_b()).invoke(this.transientData.keyListener.func_76341_a(), keyCode, scanCode, modifiers);
                }
                catch (Exception e) {
                    Pixelmon.LOGGER.error("Key listener error: " + this.uuid.toString() + ", " + this.playerName);
                }
            }
        }
    }

    public void deregisterKeyListener() {
        this.transientData.keyListener = null;
    }

    public int getSelectedSlot() {
        return this.selectedSlot;
    }

    public void setSelectedSlot(int selectedSlot) {
        this.setSelectedSlot(selectedSlot, true);
    }

    public void setSelectedSlot(int selectedSlot, boolean sendPacket) {
        if (selectedSlot < 0 || this.getAll().length <= selectedSlot || this.getAll()[selectedSlot] == null) {
            selectedSlot = 0;
        }
        this.selectedSlot = selectedSlot;
        if (sendPacket) {
            this.sendClientUpdateSelectedPacket();
        }
    }

    public Pokemon getSelectedPokemon() {
        return this.getAll()[this.selectedSlot];
    }

    @OnlyIn(value=Dist.CLIENT)
    public void sendClientUpdatePacket() {
        NetworkHelper.sendToServer(new ServerboundSetSelectedSlotPacket(this.selectedSlot));
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public void sendClientUpdateSelectedPacket() {
        NetworkHelper.sendPacket(new ClientboundSetSelectedSlotPacket(this.selectedSlot), this.getPlayer());
    }

    public PlayerDayCare getDayCare() {
        return this.dayCare;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setDayCare(PlayerDayCare dayCare) {
        this.dayCare = dayCare;
    }

    public BattleLog getLastBattle() {
        return this.lastBattle;
    }

    public void setLastBattle(BattleLog lastBattle) {
        this.lastBattle = lastBattle;
    }
}

